/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.properties;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.properties.AxisChartTypeProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLGenerator;

public final class PointChartProperties
extends AxisChartTypeProperties {
    public static final Stroke DEFAULT_POINT_BORDER_STROKE = new BasicStroke(1.0f);
    public static final Shape SHAPE_SQUARE = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    public static final Shape SHAPE_TRIANGLE = new Polygon(new int[]{0, 5, 10}, new int[]{10, 0, 10}, 3);
    public static final Shape SHAPE_CIRCLE = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
    public static final Shape SHAPE_DIAMOND = new Polygon(new int[]{0, 5, 10, 5}, new int[]{5, 0, 5, 10}, 4);
    private Shape[] shapes;
    private boolean[] fillPointFlags;
    private Paint[] outlinePaints;

    public PointChartProperties(Shape[] shapeArray, boolean[] blArray, Paint[] paintArray) {
        this.shapes = shapeArray;
        this.fillPointFlags = blArray;
        this.outlinePaints = paintArray;
    }

    public boolean getFillPointsFlag(int n) {
        return this.fillPointFlags[n];
    }

    public Paint getPointOutlinePaints(int n) {
        return this.outlinePaints[n];
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart("PointChartProperties");
        hTMLGenerator.propertiesTableEnd();
    }

    public void validate(IAxisPlotDataSet iAxisPlotDataSet) throws PropertyException {
        if (iAxisPlotDataSet.getNumberOfDataSets() != this.shapes.length) {
            throw new PropertyException("<PointChartProperties> There must be a Shape implementation for each data set.");
        }
        if (this.shapes.length != this.fillPointFlags.length) {
            throw new PropertyException("<PointChartProperties> There is NOT an one to one mapping between 'fillPointsFlags' and Shapes");
        }
        if (this.shapes.length != this.outlinePaints.length) {
            throw new PropertyException("<PointChartProperties> There is NOT an one to one mapping between 'outlinePaints' and Shapes");
        }
    }
}

