/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData.processors;

import org.krysalis.jcharts.chartData.interfaces.IRadarChartDataSet;

public final class RadarChartDataProcessor {
    private IRadarChartDataSet iRadarChartDataSet;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;

    public RadarChartDataProcessor(IRadarChartDataSet iRadarChartDataSet) {
        this.iRadarChartDataSet = iRadarChartDataSet;
    }

    public void processData() {
        for (int i = 0; i < this.iRadarChartDataSet.getNumberOfDataSets(); ++i) {
            for (int j = 0; j < this.iRadarChartDataSet.getDataSetSize(); ++j) {
                double d = this.iRadarChartDataSet.getValue(i, j);
                if (d > this.maxValue) {
                    this.maxValue = d;
                }
                if (!(d < this.minValue)) continue;
                this.minValue = d;
            }
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

