/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.imageMap.ImageMapNotSupportedException;
import org.krysalis.jcharts.properties.DataAxisProperties;

abstract class StackedAreaChart {
    StackedAreaChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        int n;
        if (axisChart.getImageMap() != null) {
            throw new ImageMapNotSupportedException("HTML client-side image maps are not supported on Area Charts.");
        }
        float f = axisChart.getXAxis().getTickStart();
        GeneralPath[] generalPathArray = new GeneralPath[iAxisChartDataSet.getNumberOfDataSets()];
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        float f2 = 0.0f;
        for (n = 0; n < generalPathArray.length; ++n) {
            generalPathArray[n] = new GeneralPath();
            generalPathArray[n].moveTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            f2 = (float)((double)f2 + iAxisChartDataSet.getValue(n, 0));
            generalPathArray[n].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), f2, axisChart.getYAxis().getScaleCalculator().getMinValue()));
        }
        for (n = 1; n < iAxisChartDataSet.getNumberOfDataItems(); ++n) {
            f += axisChart.getXAxis().getScalePixelWidth();
            f2 = 0.0f;
            for (int i = 0; i < generalPathArray.length; ++i) {
                f2 = (float)((double)f2 + iAxisChartDataSet.getValue(i, n));
                generalPathArray[i].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), f2, axisChart.getYAxis().getScaleCalculator().getMinValue()));
            }
        }
        Area[] areaArray = new Area[generalPathArray.length];
        Area area = null;
        for (int i = 0; i < generalPathArray.length; ++i) {
            generalPathArray[i].lineTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            generalPathArray[i].closePath();
            Area area2 = new Area(generalPathArray[i]);
            if (i > 0) {
                areaArray[i] = (Area)area2.clone();
                areaArray[i].subtract(area);
                area = area2;
                continue;
            }
            areaArray[0] = area2;
            area = areaArray[0];
        }
        Graphics2D graphics2D = axisChart.getGraphics2D();
        for (int i = 0; i < areaArray.length; ++i) {
            graphics2D.setPaint(iAxisChartDataSet.getPaint(i));
            graphics2D.fill(areaArray[i]);
        }
    }
}

