/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import org.krysalis.jcharts.axisChart.ScatterPlotAxisChart;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSet;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.properties.ScatterPlotProperties;

abstract class ScatterPlotChart {
    ScatterPlotChart() {
    }

    static void render(ScatterPlotAxisChart scatterPlotAxisChart, IScatterPlotDataSet iScatterPlotDataSet) {
        Shape shape;
        int n;
        float[][] fArray = new float[iScatterPlotDataSet.getNumberOfDataSets()][iScatterPlotDataSet.getNumberOfDataItems()];
        float[][] fArray2 = new float[iScatterPlotDataSet.getNumberOfDataSets()][iScatterPlotDataSet.getNumberOfDataItems()];
        for (int i = 0; i < iScatterPlotDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < fArray2.length; ++j) {
                if (iScatterPlotDataSet.getValue(j, i) != null) {
                    fArray[j][i] = scatterPlotAxisChart.getXAxis().computeAxisCoordinate(scatterPlotAxisChart.getXAxis().getOrigin(), iScatterPlotDataSet.getValue(j, i).getX(), scatterPlotAxisChart.getXAxis().getScaleCalculator().getMinValue());
                    fArray2[j][i] = scatterPlotAxisChart.getYAxis().computeAxisCoordinate(scatterPlotAxisChart.getYAxis().getOrigin(), iScatterPlotDataSet.getValue(j, i).getY(), scatterPlotAxisChart.getYAxis().getScaleCalculator().getMinValue());
                    if (!scatterPlotAxisChart.getGenerateImageMapFlag()) continue;
                    scatterPlotAxisChart.getImageMap().addImageMapArea(new CircleMapArea(fArray[j][i], fArray2[j][i], iScatterPlotDataSet.getValue(j, i), iScatterPlotDataSet.getLegendLabel(j)));
                    continue;
                }
                fArray[j][i] = Float.NaN;
                fArray2[j][i] = Float.NaN;
            }
        }
        ScatterPlotProperties scatterPlotProperties = (ScatterPlotProperties)iScatterPlotDataSet.getChartTypeProperties();
        Graphics2D graphics2D = scatterPlotAxisChart.getGraphics2D();
        AffineTransform affineTransform = null;
        double[] dArray = null;
        double[] dArray2 = null;
        if (scatterPlotProperties.getShapes() != null) {
            dArray = new double[iScatterPlotDataSet.getNumberOfDataSets()];
            dArray2 = new double[iScatterPlotDataSet.getNumberOfDataSets()];
            affineTransform = graphics2D.getTransform();
            for (n = 0; n < iScatterPlotDataSet.getNumberOfDataSets(); ++n) {
                if (scatterPlotProperties.getShapes()[n] == null) continue;
                shape = scatterPlotProperties.getShapes()[n].getBounds2D();
                dArray[n] = ((RectangularShape)shape).getWidth() / 2.0;
                dArray2[n] = ((RectangularShape)shape).getHeight() / 2.0;
            }
        }
        shape = new Line2D.Float(fArray[0][0], fArray2[0][0], fArray[0][1], fArray2[0][1]);
        if (fArray2[0].length > 1) {
            ((Line2D.Float)shape).y2 = fArray2[0][1];
        }
        for (n = 0; n < fArray2.length; ++n) {
            ((Line2D.Float)shape).x1 = fArray[n][0];
            ((Line2D.Float)shape).y1 = fArray2[n][0];
            ((Line2D.Float)shape).x2 = ((Line2D.Float)shape).x1;
            for (int i = 1; i < fArray2[0].length; ++i) {
                if (!Float.isNaN(fArray2[n][i])) {
                    if (Float.isNaN(fArray2[n][i - 1])) {
                        ((Line2D.Float)shape).x1 = fArray[n][i];
                        ((Line2D.Float)shape).y1 = fArray2[n][i];
                        ((Line2D.Float)shape).x2 = fArray[n][i];
                        ((Line2D.Float)shape).y2 = fArray2[n][i];
                        continue;
                    }
                    ((Line2D.Float)shape).x2 = fArray[n][i];
                    ((Line2D.Float)shape).y2 = fArray2[n][i];
                    graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                    graphics2D.setStroke(scatterPlotProperties.getLineStrokes()[n]);
                    graphics2D.draw(shape);
                    if (scatterPlotProperties.getShapes()[n] != null) {
                        graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - dArray2[n]);
                        graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                        graphics2D.fill(scatterPlotProperties.getShapes()[n]);
                        graphics2D.setTransform(affineTransform);
                    }
                    ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                    ((Line2D.Float)shape).y1 = ((Line2D.Float)shape).y2;
                    continue;
                }
                if (!Float.isNaN(fArray2[n][i - 1]) && scatterPlotProperties.getShapes()[n] != null) {
                    graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - dArray2[n]);
                    graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
                    graphics2D.fill(scatterPlotProperties.getShapes()[n]);
                    graphics2D.setTransform(affineTransform);
                }
                ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2 = scatterPlotAxisChart.getXAxis().getScalePixelWidth();
            }
            if (Float.isNaN(fArray2[n][fArray2[n].length - 1]) || scatterPlotProperties.getShapes()[n] == null) continue;
            graphics2D.translate((double)((Line2D.Float)shape).x2 - dArray[n], (double)((Line2D.Float)shape).y2 - dArray2[n]);
            graphics2D.setPaint(iScatterPlotDataSet.getPaint(n));
            graphics2D.fill(scatterPlotProperties.getShapes()[n]);
            graphics2D.setTransform(affineTransform);
        }
    }
}

