/*
 * Copyright 2007 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.client.ui.canvas.impl;

import java.util.HashMap;
import java.util.Map;

import org.gwtwidgets.client.ui.canvas.Canvas;
import org.gwtwidgets.client.ui.canvas.FontLoadListener;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

/**
 * <p>
 * At the time of this writing, Firefox and Opera exhibit low performance when painting images
 * as they apparently store them in a packed format according to this
 * <a href="http://blog.persistent.info/2006/02/rendering-text-inside-canvas-object.html">blog entry</a>.
 * On Windows's Safari this implementation produces ugly artifacts and is not faster than the default
 * {@link BitmapFontImpl} - the {@link CanvasFactory} implementations make sure to return the correct fonts.
 * </p>
 * <p>
 * Please note that this implementation because of the image decomposition into character blocks 
 * is even more expensive than the default {@link BitmapFontImpl}.
 * </p>
 * @author George Georgovassilis g.georgovassilis[at]gmail.com
 *
 */
public class CanvasBackedBitmapFontImpl extends BitmapFontImpl {
	
	// map of single-character strings to canvas elements containing a single character glyph
	private Map charToCanvas = new HashMap();

	public CanvasBackedBitmapFontImpl(String bitmapPath, String descriptionPath, FontLoadListener listener) {
		super(bitmapPath, descriptionPath, listener);
	}
	
	private Element getImageFor(char c, double offsetLeft, double offsetTop, double charWidth, double charHeight){
		String sc = ""+c;
		Element canvas = (Element)charToCanvas.get(sc);
		if (canvas!=null) return canvas;
		canvas = DOM.createElement("canvas");
		DOM.setStyleAttribute(canvas, "width", charWidth+"px");
		DOM.setStyleAttribute(canvas, "height", charHeight+"px");
		DOM.setElementAttribute(canvas, "width", charWidth+"");
		DOM.setElementAttribute(canvas, "height", charHeight+"");
		FFCanvasImpl.paintCopy(canvas, bitmap, offsetLeft, offsetTop, charWidth, charHeight);
		
		charToCanvas.put(sc, canvas);
		return canvas;
	}
	
	protected void drawGlyph(char c, Canvas canvas, double charOffsetLeft, double charOffsetTop, double charWidth, double blockHeight,
			double destinationX, double destinationY, double destinationWidth, double destinationHeight) {
		Element image = getImageFor(c, charOffsetLeft, charOffsetTop, charWidth, blockHeight);
		canvas.drawImage(image, 0, 0, charWidth, blockHeight, destinationX, destinationY, charWidth, blockHeight);
	}
	
}
