/*
 * Decompiled with CFR 0.152.
 */
package net.java.mavenincrementalbuild;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.mavenincrementalbuild.Module;
import net.java.mavenincrementalbuild.ModuleIdentifier;
import net.java.mavenincrementalbuild.utils.MapFileManager;
import net.java.mavenincrementalbuild.utils.SetFileManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public class IncrementalBuildMojo
extends AbstractMojo {
    private static final String TIMESTAMPS_FILE = "timestamp";
    private static final String RESOURCES_LIST_FILE = "resourcesList";
    private MavenProject project;
    private static final Map<ModuleIdentifier, Module> resolvedDependencies = new HashMap<ModuleIdentifier, Module>();
    private MapFileManager<String, Long> timestampManager;
    private boolean noIncrementalBuild;
    private String targetDirectory = null;

    public void execute() throws MojoExecutionException {
        Module module = null;
        if (this.noIncrementalBuild) {
            this.getLog().info((CharSequence)"Incremental build deactivated.");
            return;
        }
        ModuleIdentifier moduleIdentifier = new ModuleIdentifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        if (resolvedDependencies.get(moduleIdentifier) != null) {
            this.getLog().info((CharSequence)"Incremental build test already done. Skipping...");
            return;
        }
        this.targetDirectory = this.project.getBuild().getDirectory();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved modules : " + resolvedDependencies));
            this.getLog().debug((CharSequence)"Loading previous timestamps ...");
        }
        try {
            this.timestampManager = new MapFileManager(this.getLog(), this.targetDirectory, TIMESTAMPS_FILE);
            this.timestampManager.load();
        }
        catch (IOException e1) {
            this.getLog().error((CharSequence)"Error loading previous timestamps", (Throwable)e1);
            throw new MojoExecutionException("Error loading previous timestamps.", (Exception)e1);
        }
        module = this.saveModuleState(this.project, moduleIdentifier, this.pomUpdated() || this.parentUpdated() || this.resourcesUpdated() != false || this.sourcesUpdated() != false);
        if (module.isUpdated().booleanValue()) {
            try {
                this.cleanModule();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to clean module.", (Exception)e);
            }
        }
        this.getLog().debug((CharSequence)"Saving timestamps..");
        try {
            this.timestampManager.save();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error saving timestamps.", (Throwable)e);
            throw new MojoExecutionException("Error saving timestamps.", (Exception)e);
        }
    }

    private void cleanModule() throws IOException {
        this.getLog().debug((CharSequence)"Module updated, cleaning module");
        String buildDirectory = this.project.getBuild().getDirectory();
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        String testOutputDirectory = this.project.getBuild().getTestOutputDirectory();
        this.deleteDirectory(buildDirectory);
        if (!outputDirectory.startsWith(buildDirectory)) {
            this.deleteDirectory(outputDirectory);
        }
        if (!testOutputDirectory.startsWith(buildDirectory)) {
            this.deleteDirectory(testOutputDirectory);
        }
    }

    private void deleteDirectory(String path) throws IOException {
        this.getLog().info((CharSequence)("Deleting " + path));
        FileUtils.deleteDirectory((String)path);
    }

    private Boolean directoryUpdated(File sourceDirectory, File targetDirectory) {
        this.getLog().debug((CharSequence)("checking " + sourceDirectory + " compared to " + targetDirectory));
        Long lastSourceModificationDate = new Long(0L);
        Long lastTargetModificationDate = new Long(0L);
        if (!sourceDirectory.exists()) {
            this.getLog().info((CharSequence)"No sources to check ...");
            return false;
        }
        if (!targetDirectory.exists()) {
            this.getLog().info((CharSequence)"No target directory, build is required.");
            return true;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        this.getLog().debug((CharSequence)("Source directory : " + sourceDirectory));
        scanner.setBasedir(sourceDirectory);
        scanner.setIncludes(new String[]{"**/*"});
        scanner.setExcludes(DirectoryScanner.DEFAULTEXCLUDES);
        this.getLog().debug((CharSequence)"Scanning sources...");
        scanner.scan();
        Object[] files = scanner.getIncludedFiles();
        this.getLog().debug((CharSequence)("Source files : " + Arrays.toString(files)));
        for (int i = 0; i < files.length; ++i) {
            File file = new File(sourceDirectory, (String)files[i]);
            long lastModification = file.lastModified();
            this.getLog().debug((CharSequence)("" + lastModification));
            if (lastModification <= lastSourceModificationDate) continue;
            lastSourceModificationDate = lastModification;
        }
        this.getLog().debug((CharSequence)("Last source modification : " + lastSourceModificationDate));
        String targetDir = this.project.getBuild().getOutputDirectory();
        this.getLog().debug((CharSequence)("Target directory : " + targetDir));
        scanner = new DirectoryScanner();
        scanner.setBasedir(this.project.getBuild().getOutputDirectory());
        scanner.setIncludes(new String[]{"**/*"});
        scanner.addDefaultExcludes();
        this.getLog().debug((CharSequence)"Scanning output dir...");
        scanner.scan();
        files = scanner.getIncludedFiles();
        this.getLog().debug((CharSequence)("Target files : " + Arrays.toString(files)));
        for (int i = 0; i < files.length; ++i) {
            File file = new File(targetDir, (String)files[i]);
            Long lastModification = file.lastModified();
            if (lastModification <= lastTargetModificationDate) continue;
            lastTargetModificationDate = lastModification;
        }
        this.getLog().debug((CharSequence)("Last target modification date : " + lastTargetModificationDate));
        if (lastSourceModificationDate > lastTargetModificationDate) {
            this.getLog().info((CharSequence)"Source modification detected, clean will be called");
            return true;
        }
        this.getLog().debug((CharSequence)"No changes detected.");
        return false;
    }

    private Boolean sourcesUpdated() {
        this.getLog().info((CharSequence)"Verifying sources...");
        File sourceDirectory = new File(this.project.getBuild().getSourceDirectory());
        File targetDirectory = new File(this.project.getBuild().getOutputDirectory());
        return this.directoryUpdated(sourceDirectory, targetDirectory);
    }

    private Module saveModuleState(MavenProject project, ModuleIdentifier identifier, Boolean mustBeCleaned) {
        Module module = new Module(identifier, mustBeCleaned);
        resolvedDependencies.put(module.getIdentifier(), module);
        return module;
    }

    protected Boolean resourcesUpdated() {
        this.getLog().info((CharSequence)"Verifying resources...");
        List resources = this.project.getResources();
        SetFileManager<String> previousResources = new SetFileManager<String>(this.getLog(), this.targetDirectory, RESOURCES_LIST_FILE);
        try {
            previousResources.load();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error load previous resources file");
            return true;
        }
        SetFileManager<String> actualResources = new SetFileManager<String>(this.getLog(), this.targetDirectory, RESOURCES_LIST_FILE);
        for (Resource resource : resources) {
            String source = resource.getDirectory();
            String target = StringUtils.isNotEmpty((String)resource.getTargetPath()) ? resource.getTargetPath() : this.project.getBuild().getOutputDirectory();
            List includes = resource.getIncludes();
            List excludes = resource.getExcludes();
            this.getLog().debug((CharSequence)("Resources excludes : " + excludes));
            this.getLog().debug((CharSequence)("Resources includes : " + includes));
            if (!new File(source).exists()) {
                this.getLog().info((CharSequence)("Resources directory does not exist : " + source));
                continue;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(source);
            if (includes != null && !includes.isEmpty()) {
                this.getLog().debug((CharSequence)"add inclusion.");
                scanner.setIncludes(includes.toArray(new String[includes.size()]));
            }
            if (excludes != null && !excludes.isEmpty()) {
                this.getLog().debug((CharSequence)"add exclusions.");
                scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            }
            scanner.addDefaultExcludes();
            this.getLog().debug((CharSequence)"Starting resource scanning...");
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            this.getLog().debug((CharSequence)(files.length + " resource files found"));
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                File sourceFile = new File(source + File.separator + fileName);
                File targetFile = new File(target + File.separator + fileName);
                Boolean isUpToDate = SelectorUtils.isOutOfDate((File)targetFile, (File)sourceFile, (int)0);
                this.getLog().debug((CharSequence)(targetFile.getAbsolutePath() + " is uptodate : " + isUpToDate + " (compare to " + sourceFile.getAbsolutePath() + ")"));
                previousResources.remove(fileName);
                actualResources.add(fileName);
                if (isUpToDate.booleanValue()) continue;
                this.getLog().info((CharSequence)"resources updated, module have to be cleaned");
                return true;
            }
        }
        if (previousResources.isEmpty()) {
            this.getLog().info((CharSequence)"A resource was deleted, module have to be cleaned");
            return true;
        }
        try {
            actualResources.save();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error saving resource files list", (Throwable)e);
            return true;
        }
        return false;
    }

    private boolean parentUpdated() {
        this.getLog().info((CharSequence)"Verifying parent modules...");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            String version = artifact.getVersion();
            ModuleIdentifier identifier = new ModuleIdentifier(groupId, artifactId, version);
            Module module = resolvedDependencies.get(identifier);
            if (this.getLog().isDebugEnabled()) {
                if (module != null) {
                    this.getLog().debug((CharSequence)("Module " + identifier + " updated ? " + module.isUpdated()));
                } else {
                    this.getLog().debug((CharSequence)("Module " + identifier + " not found."));
                }
            }
            if (module == null || !module.isUpdated().booleanValue()) continue;
            this.getLog().info((CharSequence)("Module <" + groupId + ", " + artifactId + ", " + version + "> updated"));
            return true;
        }
        return false;
    }

    private boolean pomUpdated() {
        boolean modified = false;
        this.getLog().info((CharSequence)"Verifying module descriptor ...");
        File file = this.project.getFile();
        String fileName = file.getAbsolutePath();
        Long currentModifiedTime = file.lastModified();
        Long lastModifiedTime = this.timestampManager.get(fileName);
        if (lastModifiedTime == null || currentModifiedTime.compareTo(lastModifiedTime) > 0) {
            this.getLog().info((CharSequence)"Pom descriptor modification detected.");
            this.timestampManager.set(fileName, currentModifiedTime);
            modified = true;
        } else {
            this.getLog().debug((CharSequence)"No modification on descriptor.");
        }
        return modified;
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }
}

