/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.daos.ApiDetailQuery;
import net.hasor.dataway.daos.PublishApiQuery;
import net.hasor.dataway.web.BasicController;
import net.hasor.utils.StringUtils;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/publish")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class PublishController
extends BasicController {
    @Post
    public Result<Object> doPublish(final @QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) throws IOException {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        QueryResult queryDetail = new ApiDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiId", apiId);
            }
        });
        String strCodeType = ((ObjectModel)queryDetail.getData()).getValue("codeType").asString();
        String strCodeValue = ((ObjectModel)queryDetail.getData()).getObject("codeInfo").getValue("codeValue").asString();
        String requestBodyJson = ((ObjectModel)queryDetail.getData()).getObject("codeInfo").getValue("requestBody").asString();
        if (StringUtils.isBlank((String)requestBodyJson)) {
            requestBodyJson = "{}";
        }
        JSONObject strRequestBody = JSON.parseObject((String)requestBodyJson);
        if ("sql".equalsIgnoreCase(strCodeType)) {
            strCodeValue = DatawayUtils.evalCodeValueForSQL(strCodeValue, (Map<String, Object>)strRequestBody);
        }
        final String finalStrCodeValue = strCodeValue;
        new PublishApiQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiId", apiId);
                this.put("newScript", finalStrCodeValue);
            }
        });
        return Result.of(true);
    }
}

