/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.dataway.config.DatawayModule;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.FilenameUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.io.output.ByteArrayOutputStream;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterfaceUiFilter
implements InvokerFilter {
    protected static Logger logger = LoggerFactory.getLogger(InterfaceUiFilter.class);
    private static final String resourceBaseUri = "/META-INF/hasor-framework/dataway-ui/";
    private String resourceIndexUri = null;
    private String apiBaseUri;
    private String uiBaseUri;
    private String uiAdminBaseUri;

    public InterfaceUiFilter(String apiBaseUri, String uiBaseUri) {
        this.apiBaseUri = apiBaseUri;
        this.uiBaseUri = uiBaseUri;
        this.uiAdminBaseUri = DatawayModule.fixUrl(uiBaseUri + "/api/");
        this.resourceIndexUri = DatawayModule.fixUrl(uiBaseUri + "/index.html");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        httpRequest.setCharacterEncoding("UTF-8");
        httpResponse.setCharacterEncoding("UTF-8");
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.startsWith(this.uiAdminBaseUri)) {
            try {
                DatawayUtils.resetLocalTime();
                return chain.doNext(invoker);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                Map<String, Object> objectMap = DatawayUtils.exceptionToResult(e).getResult();
                PrintWriter writer = httpResponse.getWriter();
                writer.write(JSON.toJSONString(objectMap));
                writer.flush();
                return objectMap;
            }
        }
        if (this.uiBaseUri.equalsIgnoreCase(requestURI)) {
            requestURI = this.resourceIndexUri;
        }
        if (requestURI.equalsIgnoreCase(this.resourceIndexUri)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InputStream inputStream = ResourcesUtils.getResourceAsStream((String)DatawayModule.fixUrl("/META-INF/hasor-framework/dataway-ui//index.html"));
            Object writer = null;
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                writer = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (writer != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)writer).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            String htmlBody = new String(outputStream.toByteArray());
            htmlBody = htmlBody.replace("{API_BASE_URL}", DatawayModule.fixUrl(this.apiBaseUri));
            htmlBody = htmlBody.replace("{ADMIN_BASE_URL}", DatawayModule.fixUrl(this.uiBaseUri));
            htmlBody = htmlBody.replace("{ALL_MAC}", InterfaceUiFilter.allLocalMac());
            httpResponse.setContentType(invoker.getMimeType("html"));
            httpResponse.setContentLength(htmlBody.length());
            writer = httpResponse.getWriter();
            ((PrintWriter)writer).write(htmlBody);
            ((PrintWriter)writer).flush();
            return null;
        }
        if (!requestURI.startsWith(this.uiBaseUri)) return chain.doNext(invoker);
        String extension = FilenameUtils.getExtension((String)requestURI);
        String mimeType = invoker.getMimeType(extension);
        if (StringUtils.isNotBlank((String)mimeType)) {
            httpResponse.setContentType(mimeType);
        }
        String resourceName = DatawayModule.fixUrl(resourceBaseUri + requestURI.substring(this.uiBaseUri.length()));
        ServletOutputStream outputStream = httpResponse.getOutputStream();
        Throwable throwable = null;
        try {
            Throwable throwable2;
            InputStream inputStream;
            block49: {
                Object var13_26;
                block50: {
                    block51: {
                        inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
                        throwable2 = null;
                        if (inputStream != null) break block49;
                        httpResponse.sendError(404, "not found " + requestURI);
                        var13_26 = null;
                        if (inputStream == null) break block50;
                        if (throwable2 == null) break block51;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block50;
                    }
                    inputStream.close();
                }
                if (outputStream == null) return var13_26;
                if (throwable != null) {
                    try {
                        outputStream.close();
                        return var13_26;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        return var13_26;
                    }
                }
                outputStream.close();
                return var13_26;
            }
            try {
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("load " + resourceName + " failed -> " + e.getMessage(), (Throwable)e);
            }
            outputStream.flush();
            return null;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        catch (Throwable throwable9) {
            throw throwable9;
        }
    }

    private static String allLocalMac() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        HashSet<String> macPool = new HashSet<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nextElement = interfaces.nextElement();
            byte[] hardwareAddress = nextElement.getHardwareAddress();
            if (hardwareAddress == null) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < hardwareAddress.length; ++i) {
                String str = Integer.toHexString(hardwareAddress[i] & 0xFF);
                strBuilder.append(str.length() == 1 ? "0" + str : str);
            }
            macPool.add(strBuilder.toString());
        }
        return StringUtils.join((Object[])macPool.toArray(), (String)",").toUpperCase();
    }
}

