/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.CheckValidConnectionSQL;
import org.jboss.resource.adapter.jdbc.ExceptionSorter;
import org.jboss.resource.adapter.jdbc.NullExceptionSorter;
import org.jboss.resource.adapter.jdbc.NullValidConnectionChecker;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
import org.jboss.resource.adapter.jdbc.WrappedConnectionRequestInfo;
import org.jboss.resource.adapter.jdbc.WrapperDataSource;

public abstract class BaseWrapperManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected String userName;
    protected String password;
    protected HashMap connectionProps = new HashMap();
    protected int transactionIsolation = -1;
    protected int preparedStatementCacheSize = 0;
    protected boolean doQueryTimeout = false;
    protected String newConnectionSQL;
    protected String checkValidConnectionSQL;
    protected String validConnectionCheckerClassName;
    protected ValidConnectionChecker connectionChecker;
    private String exceptionSorterClassName;
    private ExceptionSorter exceptionSorter;
    private boolean trackStatements;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$WrappedConnectionRequestInfo;

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new WrapperDataSource(this, cm);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new JBossResourceException("NYI");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int size) {
        this.preparedStatementCacheSize = size;
    }

    public boolean getTxQueryTimeout() {
        return this.doQueryTimeout;
    }

    public void setTxQueryTimeout(boolean qt) {
        this.doQueryTimeout = qt;
    }

    public String getTransactionIsolation() {
        switch (this.transactionIsolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case -1: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.transactionIsolation);
    }

    public void setTransactionIsolation(String transactionIsolation) {
        if (transactionIsolation.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (transactionIsolation.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (transactionIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (transactionIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (transactionIsolation.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            try {
                this.transactionIsolation = Integer.parseInt(transactionIsolation);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Setting Isolation level to unknown state: " + transactionIsolation);
            }
        }
    }

    public String getNewConnectionSQL() {
        return this.newConnectionSQL;
    }

    public void setNewConnectionSQL(String newConnectionSQL) {
        this.newConnectionSQL = newConnectionSQL;
    }

    public String getCheckValidConnectionSQL() {
        return this.checkValidConnectionSQL;
    }

    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.checkValidConnectionSQL = checkValidConnectionSQL;
    }

    public boolean getTrackStatements() {
        return this.trackStatements;
    }

    public void setTrackStatements(boolean value) {
        this.trackStatements = value;
    }

    public String getExceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.exceptionSorterClassName = exceptionSorterClassName;
    }

    public String getValidConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public void setValidConnectionCheckerClassName(String value) {
        this.validConnectionCheckerClassName = value;
    }

    protected Properties getConnectionProperties(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri != null && cri.getClass() != (class$org$jboss$resource$adapter$jdbc$WrappedConnectionRequestInfo == null ? (class$org$jboss$resource$adapter$jdbc$WrappedConnectionRequestInfo = BaseWrapperManagedConnectionFactory.class$("org.jboss.resource.adapter.jdbc.WrappedConnectionRequestInfo")) : class$org$jboss$resource$adapter$jdbc$WrappedConnectionRequestInfo)) {
            throw new JBossResourceException("Wrong kind of ConnectionRequestInfo: " + cri.getClass());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionProps);
        if (subject != null) {
            Iterator<Object> i = subject.getPrivateCredentials().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof PasswordCredential) || !((PasswordCredential)o).getManagedConnectionFactory().equals((Object)this)) continue;
                PasswordCredential cred = (PasswordCredential)o;
                props.setProperty("user", cred.getUserName() == null ? "" : cred.getUserName());
                props.setProperty("password", new String(cred.getPassword()));
                return props;
            }
            throw new JBossResourceException("No matching credentials in Subject!");
        }
        WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)cri;
        if (lcri != null) {
            props.setProperty("user", lcri.getUserName() == null ? "" : lcri.getUserName());
            props.setProperty("password", lcri.getPassword() == null ? "" : lcri.getPassword());
            return props;
        }
        if (this.userName != null) {
            props.setProperty("user", this.userName);
            props.setProperty("password", this.password == null ? "" : this.password);
        }
        return props;
    }

    boolean isExceptionFatal(SQLException e) {
        if (this.exceptionSorter != null) {
            return this.exceptionSorter.isExceptionFatal(e);
        }
        if (this.exceptionSorterClassName != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = cl.loadClass(this.exceptionSorterClassName);
                this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
                return this.exceptionSorter.isExceptionFatal(e);
            }
            catch (Exception e2) {
                this.log.warn((Object)"exception trying to create exception sorter (disabling):", (Throwable)e2);
                this.exceptionSorter = new NullExceptionSorter();
            }
        }
        return false;
    }

    SQLException isValidConnection(Connection c) {
        if (this.connectionChecker != null) {
            return this.connectionChecker.isValidConnection(c);
        }
        if (this.validConnectionCheckerClassName != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = cl.loadClass(this.validConnectionCheckerClassName);
                this.connectionChecker = (ValidConnectionChecker)clazz.newInstance();
                return this.connectionChecker.isValidConnection(c);
            }
            catch (Exception e) {
                this.log.warn((Object)"Exception trying to create connection checker (disabling):", (Throwable)e);
                this.connectionChecker = new NullValidConnectionChecker();
            }
        }
        if (this.checkValidConnectionSQL != null) {
            this.connectionChecker = new CheckValidConnectionSQL(this.checkValidConnectionSQL);
            return this.connectionChecker.isValidConnection(c);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

