/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.httpclient.HttpAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;

final class TracingMainExec
implements ClientExecChain {
    static final Propagation.Setter<HttpRequestWrapper, String> SETTER = new Propagation.Setter<HttpRequestWrapper, String>(){

        public void put(HttpRequestWrapper carrier, String key, String value) {
            carrier.setHeader(key, value);
        }

        public String toString() {
            return "HttpRequestWrapper::setHeader";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<HttpRequestWrapper, HttpResponse> handler;
    final TraceContext.Injector<HttpRequestWrapper> injector;
    final ClientExecChain mainExec;

    TracingMainExec(HttpTracing httpTracing, ClientExecChain mainExec) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.mainExec = mainExec;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        this.handler.handleSend(this.injector, (Object)request, this.tracer.currentSpan());
        return this.mainExec.execute(route, request, context, execAware);
    }
}

