/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.model.Model;
import org.jruby.embed.IsolatedScriptingContainer;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.ruby.execute.RubyExecuteTaskFactory;

public class RubyParser {
    private final IsolatedScriptingContainer jruby;
    private final Object parser;
    private final ExecuteManager executeManager;
    private final RubyExecuteTaskFactory factory;

    public RubyParser(ExecuteManager executeManager) throws IOException {
        this.executeManager = executeManager;
        this.jruby = new IsolatedScriptingContainer();
        this.parser = this.jruby.runScriptlet(PathType.CLASSPATH, "parser.rb");
        this.factory = new RubyExecuteTaskFactory((ScriptingContainer)this.jruby);
    }

    public synchronized Model parse(String ruby, File source, Map<String, ?> options) {
        Model model = (Model)this.jruby.callMethod(this.parser, "parse", new Object[]{ruby, this.factory, source != null ? source.getAbsolutePath() : null}, Model.class);
        model.setPomFile(source);
        this.executeManager.register(model, this.factory.getExecuteTasks());
        this.executeManager.install(model, options);
        return model;
    }
}

