/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.DefaultTagsProvider;

@Component
@Order(value=-2147482648)
public class SwaggerOperationTagsReader
implements OperationBuilderPlugin {
    private final DefaultTagsProvider tagsProvider;

    @Autowired
    public SwaggerOperationTagsReader(DefaultTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    public void apply(OperationContext context) {
        Set defaultTags = this.tagsProvider.tags(context);
        Set tags = Stream.concat(this.operationTags(context).stream(), this.controllerTags(context).stream()).collect(Collectors.toSet());
        if (tags.isEmpty()) {
            context.operationBuilder().tags(defaultTags);
        } else {
            context.operationBuilder().tags(tags);
        }
    }

    private Set<String> controllerTags(OperationContext context) {
        Optional controllerAnnotation = context.findControllerAnnotation(Api.class);
        return controllerAnnotation.map(this.tagsFromController()).orElse(new HashSet());
    }

    private Set<String> operationTags(OperationContext context) {
        Optional annotation = context.findAnnotation(ApiOperation.class);
        return annotation.map(this.tagsFromOperation()).orElse(new HashSet());
    }

    private Function<ApiOperation, Set<String>> tagsFromOperation() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).distinct().collect(Collectors.toCollection(TreeSet::new));
    }

    private Function<Api, Set<String>> tagsFromController() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).distinct().collect(Collectors.toCollection(TreeSet::new));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

