/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.vertx;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.vertx.ParameterProcessor;
import io.smallrye.openapi.vertx.VertxConstants;
import io.smallrye.openapi.vertx.VertxLogging;
import io.smallrye.openapi.vertx.VertxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class VertxAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String VERTX_PACKAGE = "io.vertx.ext.web";

    public String getName() {
        return "Vert.x";
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return false;
    }

    public boolean isPostMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "POST");
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "DELETE");
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (VertxParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(VERTX_PACKAGE) && !instance.name().equals((Object)VertxConstants.REQUEST_BODY)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScannerInternalParameter(Type parameterType) {
        return VertxConstants.INTERNAL_PARAMETERS.contains(parameterType.name());
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.processRoutes(context, openApi);
        boolean tagsDefined = openApi.getTags() != null && !openApi.getTags().isEmpty();
        this.sortTags(openApi, tagsDefined);
        this.sortPaths(openApi);
        return openApi;
    }

    private boolean hasRouteMethod(MethodInfo method, String httpMethod) {
        if (method.hasAnnotation(VertxConstants.ROUTE)) {
            AnnotationInstance annotation = method.annotation(VertxConstants.ROUTE);
            AnnotationValue value = annotation.value("methods");
            return value != null && value.asEnumArray().length > 0 && Arrays.asList(value.asEnumArray()).contains(httpMethod);
        }
        return false;
    }

    private void processRoutes(AnnotationScannerContext context, OpenAPI openApi) {
        Collection routeAnnotations = context.getIndex().getAnnotations(VertxConstants.ROUTE);
        ArrayList<ClassInfo> applications = new ArrayList<ClassInfo>();
        for (AnnotationInstance annotationInstance : routeAnnotations) {
            if (annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                ClassInfo classInfo = annotationInstance.target().asMethod().declaringClass();
                applications.add(classInfo);
                continue;
            }
            VertxLogging.log.ignoringAnnotation(VertxConstants.ROUTE.withoutPackagePrefix());
        }
        this.processScannerExtensions(context, applications);
        for (ClassInfo controller : applications) {
            OpenAPI applicationOpenApi = this.processRouteClass(context, controller);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processRouteClass(AnnotationScannerContext context, ClassInfo routeClass) {
        VertxLogging.log.processingRouteClass(routeClass.simpleName());
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance routeBaseAnnotation = JandexUtil.getClassAnnotation((ClassInfo)routeClass, (DotName)VertxConstants.ROUTE_BASE);
        this.currentAppPath = routeBaseAnnotation != null ? routeBaseAnnotation.value("path").asString() : "/";
        this.processDefinitionAnnotation(context, routeClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(routeClass, (OpenAPI)openApi);
        this.processServerAnnotation(routeClass, (OpenAPI)openApi);
        this.processJavaSecurity(routeClass, (OpenAPI)openApi);
        this.processRouteMethods(context, routeClass, (OpenAPI)openApi, null);
        return openApi;
    }

    private void processRouteMethods(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags((AnnotationTarget)resourceClass, openApi, false);
        for (MethodInfo methodInfo : this.getResourceMethods(context, resourceClass)) {
            PathItem.HttpMethod[] all;
            if (methodInfo.annotations().size() <= 0 || !methodInfo.hasAnnotation(VertxConstants.ROUTE)) continue;
            AnnotationInstance requestMappingAnnotation = methodInfo.annotation(VertxConstants.ROUTE);
            AnnotationValue methodValue = requestMappingAnnotation.value("methods");
            if (methodValue != null) {
                String[] enumArray;
                for (String string : enumArray = methodValue.asEnumArray()) {
                    if (string == null) continue;
                    PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)string.toUpperCase());
                    this.processRouteMethod(context, resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
                }
                continue;
            }
            for (PathItem.HttpMethod httpMethod : all = PathItem.HttpMethod.values()) {
                this.processRouteMethod(context, resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
            }
        }
    }

    private void processRouteMethod(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters) {
        if (VertxAnnotationScanner.shouldScan(method)) {
            VertxLogging.log.processingMethod(method.toString());
            CurrentScannerInfo.setCurrentConsumes((String[])VertxAnnotationScanner.getMediaTypes(method, MediaTypeProperty.consumes).orElse(null));
            CurrentScannerInfo.setCurrentProduces((String[])VertxAnnotationScanner.getMediaTypes(method, MediaTypeProperty.produces).orElse(null));
            Optional maybeOperation = this.processOperation(context, method);
            if (!maybeOperation.isPresent()) {
                return;
            }
            Operation operation = (Operation)maybeOperation.get();
            this.processOperationTags(method, openApi, resourceTags, operation);
            PathItemImpl pathItem = new PathItemImpl();
            Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
            ResourceParameters params = ParameterProcessor.process((IndexView)context.getIndex(), context.getClassLoader(), resourceClass, method, reader, context.getExtensions());
            operation.setParameters(params.getOperationParameters());
            pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
            RequestBody requestBody = this.processRequestBody(context, method, params);
            if (requestBody != null) {
                operation.setRequestBody(requestBody);
            }
            this.processResponse(context, method, operation, null);
            this.processSecurityRequirementAnnotation(resourceClass, method, operation);
            this.processCallback(context, method, operation);
            this.processServerAnnotation(method, operation);
            this.processExtensions(context, method, operation);
            JavaSecurityProcessor.processSecurityRoles((MethodInfo)method, (Operation)operation);
            this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
            String path = super.makePath(params.getOperationPath());
            PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
            if (existingPath == null) {
                ModelUtil.paths((OpenAPI)openApi).addPathItem(path, (PathItem)pathItem);
            } else {
                MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
            }
        }
    }

    static boolean shouldScan(MethodInfo resourceMethod) {
        AnnotationValue annotationValue;
        DotName annotationName = VertxConstants.ROUTE;
        AnnotationInstance annotation = resourceMethod.annotation(annotationName);
        return annotation == null || annotation.value("type") == null || !(annotationValue = annotation.value("type")).asEnum().equals("FAILURE");
    }

    static Optional<String[]> getMediaTypes(MethodInfo resourceMethod, MediaTypeProperty property) {
        DotName annotationName = VertxConstants.ROUTE;
        AnnotationInstance annotation = resourceMethod.annotation(annotationName);
        if (annotation == null || annotation.value(property.name()) == null) {
            annotation = JandexUtil.getClassAnnotation((ClassInfo)resourceMethod.declaringClass(), (DotName)VertxConstants.ROUTE_BASE);
        }
        if (annotation != null) {
            AnnotationValue annotationValue = annotation.value(property.name());
            if (annotationValue != null) {
                return Optional.of(annotationValue.asStringArray());
            }
            return Optional.of(OpenApiConstants.DEFAULT_MEDIA_TYPES.get());
        }
        return Optional.empty();
    }

    static enum MediaTypeProperty {
        consumes,
        produces;

    }
}

