/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CircuitBreakerStateChanged;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import javax.enterprise.event.Event;

public class CircuitBreakerStateObserver<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final InterceptionPoint interceptionPoint;
    private final Event<CircuitBreakerStateChanged> cbStateEvent;

    public CircuitBreakerStateObserver(FaultToleranceStrategy<V> delegate, InterceptionPoint interceptionPoint, Event<CircuitBreakerStateChanged> cbStateEvent) {
        this.delegate = delegate;
        this.interceptionPoint = interceptionPoint;
        this.cbStateEvent = cbStateEvent;
    }

    public V apply(InvocationContext<V> ctx) throws Exception {
        ctx.registerEventHandler(CircuitBreakerEvents.StateTransition.class, event -> this.cbStateEvent.fire((Object)new CircuitBreakerStateChanged(this.interceptionPoint.beanClass(), this.interceptionPoint.method(), CircuitBreakerState.valueOf((String)event.targetState.name()))));
        return (V)this.delegate.apply(ctx);
    }
}

