/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.MultiDemandPausingOp;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.DemandPauser;

public class MultiDemandPausing<T> {
    private final AbstractMulti<T> upstream;
    private boolean paused = false;
    private boolean lateSubscription = false;
    private int bufferSize = Infrastructure.getMultiOverflowDefaultBufferSize();
    private boolean unbounded = false;
    private BackPressureStrategy bufferStrategy = BackPressureStrategy.BUFFER;

    public MultiDemandPausing(AbstractMulti<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public MultiDemandPausing<T> paused(boolean paused) {
        this.paused = paused;
        return this;
    }

    @CheckReturnValue
    public MultiDemandPausing<T> lateSubscription(boolean lateSubscription) {
        this.lateSubscription = lateSubscription;
        return this;
    }

    @CheckReturnValue
    public MultiDemandPausing<T> bufferSize(int bufferSize) {
        this.bufferSize = ParameterValidation.positive(bufferSize, "bufferSize");
        this.unbounded = false;
        return this;
    }

    @CheckReturnValue
    public MultiDemandPausing<T> bufferUnconditionally() {
        this.bufferSize = Infrastructure.getMultiOverflowDefaultBufferSize();
        this.unbounded = true;
        return this;
    }

    @CheckReturnValue
    public MultiDemandPausing<T> bufferStrategy(BackPressureStrategy bufferStrategy) {
        this.bufferStrategy = ParameterValidation.nonNull(bufferStrategy, "bufferStrategy");
        if (bufferStrategy != BackPressureStrategy.BUFFER && bufferStrategy != BackPressureStrategy.DROP && bufferStrategy != BackPressureStrategy.IGNORE) {
            throw new IllegalArgumentException("Demand pauser only supports BUFFER, DROP or IGNORE strategy");
        }
        return this;
    }

    @CheckReturnValue
    public Multi<T> using(DemandPauser pauser) {
        DemandPauser p = ParameterValidation.nonNull(pauser, "pauser");
        MultiDemandPausingOp<T> pausingMulti = new MultiDemandPausingOp<T>(this.upstream, this.paused, this.lateSubscription, this.bufferSize, this.unbounded, this.bufferStrategy);
        p.bind(pausingMulti);
        return Infrastructure.onMultiCreation(pausingMulti);
    }
}

