/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.ClassFileTransform;
import io.smallrye.classfile.CompoundElement;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.impl.TransformImpl;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassFileBuilder<E extends ClassFileElement, B extends ClassFileBuilder<E, B>>
extends Consumer<E> {
    @Override
    default public void accept(E e) {
        this.with(e);
    }

    public B with(E var1);

    public ConstantPoolBuilder constantPool();

    default public B transform(CompoundElement<E> model, ClassFileTransform<?, E, B> transform) {
        ClassFileBuilder builder = this;
        TransformImpl.ResolvedTransform<E> resolved = TransformImpl.resolve(transform, builder);
        resolved.startHandler().run();
        model.forEach(resolved.consumer());
        resolved.endHandler().run();
        return (B)builder;
    }
}

