/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;

public class ProvidersImpl
implements Providers {
    private final RestClientRequestContext context;

    public ProvidersImpl(RestClientRequestContext context) {
        this.context = context;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List readers = this.context.getRestClient().getClientContext().getSerialisers().findReaders(this.context.getConfiguration(), type, mediaType, RuntimeType.CLIENT);
        for (MessageBodyReader reader : readers) {
            if (!reader.isReadable(type, genericType, annotations, mediaType)) continue;
            return reader;
        }
        return null;
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List writers = this.context.getRestClient().getClientContext().getSerialisers().findWriters(this.context.getConfiguration(), type, mediaType, RuntimeType.CLIENT);
        for (MessageBodyWriter writer : writers) {
            if (!writer.isWriteable(type, genericType, annotations, mediaType)) continue;
            return writer;
        }
        return null;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        throw new UnsupportedOperationException("`jakarta.ws.rs.ext.ExceptionMapper` are not supported in REST Client Reactive");
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.context.getConfiguration().getContextResolver(contextType);
    }
}

