/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.runtime.interceptor.SecurityHandler;
import io.quarkus.security.spi.runtime.AuthorizationController;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;

@Interceptor
@PermissionsAllowed(value={""})
@Priority(value=150)
public class PermissionsAllowedInterceptor {
    @Inject
    SecurityHandler handler;
    @Inject
    AuthorizationController controller;

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        if (this.controller.isAuthorizationEnabled()) {
            return this.handler.handle(ic);
        }
        return ic.proceed();
    }
}

