/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.vertx.core.runtime.VertxMDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public final class OpenTelemetryUtil {
    private static final Logger logger = Logger.getLogger(OpenTelemetryUtil.class);
    public static final String TRACE_ID = "traceId";
    public static final String SPAN_ID = "spanId";
    public static final String SAMPLED = "sampled";
    public static final String PARENT_ID = "parentId";

    private OpenTelemetryUtil() {
    }

    public static Map<String, String> convertKeyValueListToMap(List<String> headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String header : headers) {
            if (header.isEmpty()) continue;
            String[] parts = header.split("=", 2);
            String key = parts[0].trim();
            String value = parts[1].trim();
            result.put(key, value);
        }
        return result;
    }

    public static void setMDCData(Context otelContext, io.vertx.core.Context vertxContext) {
        if (otelContext == null) {
            return;
        }
        Span span = Span.fromContextOrNull((Context)otelContext);
        if (span != null) {
            SpanContext parentSpanContext;
            if (logger.isDebugEnabled()) {
                logger.debugv("Setting span in MDC: {0} with otel data in vertx context: {1}", OpenTelemetryUtil.getSpanData(otelContext), OpenTelemetryUtil.getSpanData(QuarkusContextStorage.getOtelContext(vertxContext)));
            }
            VertxMDC.INSTANCE.clearVertxMdcFromContext(vertxContext);
            SpanContext spanContext = span.getSpanContext();
            VertxMDC.INSTANCE.put(SPAN_ID, spanContext.getSpanId(), vertxContext);
            VertxMDC.INSTANCE.put(TRACE_ID, spanContext.getTraceId(), vertxContext);
            VertxMDC.INSTANCE.put(SAMPLED, Boolean.toString(spanContext.isSampled()), vertxContext);
            if (span instanceof ReadableSpan && (parentSpanContext = ((ReadableSpan)span).getParentSpanContext()) != null && parentSpanContext.isValid()) {
                VertxMDC.INSTANCE.put(PARENT_ID, parentSpanContext.getSpanId(), vertxContext);
            }
        }
    }

    public static Map<String, String> getSpanData(Context context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Span span = Span.fromContextOrNull((Context)context);
        HashMap<String, String> spanData = new HashMap<String, String>(4, 1.0f);
        if (span != null) {
            SpanContext parentSpanContext;
            SpanContext spanContext = span.getSpanContext();
            spanData.put(SPAN_ID, spanContext.getSpanId());
            spanData.put(TRACE_ID, spanContext.getTraceId());
            spanData.put(SAMPLED, Boolean.toString(spanContext.isSampled()));
            if (span instanceof ReadableSpan && (parentSpanContext = ((ReadableSpan)span).getParentSpanContext()) != null && parentSpanContext.isValid()) {
                spanData.put(PARENT_ID, parentSpanContext.getSpanId());
            }
        }
        return spanData;
    }

    public static void clearMDCData(io.vertx.core.Context vertxContext) {
        VertxMDC vertxMDC = VertxMDC.INSTANCE;
        if (logger.isDebugEnabled()) {
            logger.debugv("Removing from MDC the span id: {0}, with otel data in vertx context: {1}", (Object)vertxMDC.get(SPAN_ID, vertxContext), OpenTelemetryUtil.getSpanData(QuarkusContextStorage.getOtelContext(vertxContext)));
        }
        vertxMDC.remove(TRACE_ID, vertxContext);
        vertxMDC.remove(SPAN_ID, vertxContext);
        vertxMDC.remove(PARENT_ID, vertxContext);
        vertxMDC.remove(SAMPLED, vertxContext);
    }
}

