/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.tracing.instrumentation;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.opentelemetry.deployment.tracing.TracerEnabled;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.InstrumentationRecorder;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.grpc.GrpcTracingClientInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.grpc.GrpcTracingServerInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.reactivemessaging.ReactiveMessagingTracingIncomingDecorator;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.reactivemessaging.ReactiveMessagingTracingOutgoingDecorator;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.restclient.OpenTelemetryClientFilter;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.resteasy.AttachExceptionHandler;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.resteasy.OpenTelemetryClassicServerFilter;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.resteasy.OpenTelemetryReactiveServerFilter;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.server.spi.PreExceptionMapperHandlerBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

@BuildSteps(onlyIf={TracerEnabled.class})
public class InstrumentationProcessor {
    @BuildStep(onlyIf={GrpcExtensionAvailable.class})
    void grpcTracers(BuildProducer<AdditionalBeanBuildItem> additionalBeans, OTelBuildConfig config) {
        if (config.instrument().grpc()) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingServerInterceptor.class}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcTracingClientInterceptor.class}));
        }
    }

    @BuildStep
    void registerRestClientClassicProvider(Capabilities capabilities, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexed, BuildProducer<AdditionalBeanBuildItem> additionalBeans, OTelBuildConfig config) {
        if (capabilities.isPresent("io.quarkus.rest.client") && capabilities.isMissing("io.quarkus.rest.client.reactive") && config.instrument().resteasyClient()) {
            additionalIndexed.produce((BuildItem)new AdditionalIndexedClassesBuildItem(OpenTelemetryClientFilter.class.getName()));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OpenTelemetryClientFilter.class}));
        }
    }

    @BuildStep
    void registerReactiveMessagingMessageDecorator(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, OTelBuildConfig config) {
        if (capabilities.isPresent("io.quarkus.messaging") && config.instrument().messaging()) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveMessagingTracingOutgoingDecorator.class}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveMessagingTracingIncomingDecorator.class}));
        }
    }

    @BuildStep(onlyIfNot={MetricsExtensionAvailable.class}, onlyIf={VertxHttpAvailable.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxHttpMetricsOptions(InstrumentationRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxHttpMetricsOptions(), 3001);
    }

    @BuildStep(onlyIfNot={MetricsExtensionAvailable.class, VertxHttpAvailable.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem vertxMetricsOptions(InstrumentationRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxMetricsOptions(), 3001);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxOptionsConsumerBuildItem vertxTracingOptions(InstrumentationRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.getVertxTracingOptions(), 3000);
    }

    @BuildStep
    void registerResteasyClassicAndOrResteasyReactiveProvider(OTelBuildConfig config, Capabilities capabilities, BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer) {
        if (capabilities.isPresent("io.quarkus.resteasy") && config.instrument().resteasy()) {
            resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(OpenTelemetryClassicServerFilter.class.getName()));
        }
    }

    @BuildStep
    void resteasyReactiveIntegration(Capabilities capabilities, BuildProducer<CustomContainerRequestFilterBuildItem> containerRequestFilterBuildItemBuildProducer, BuildProducer<PreExceptionMapperHandlerBuildItem> preExceptionMapperHandlerBuildItemBuildProducer, OTelBuildConfig config) {
        if (capabilities.isPresent("io.quarkus.resteasy.reactive") && config.instrument().rest()) {
            containerRequestFilterBuildItemBuildProducer.produce((BuildItem)new CustomContainerRequestFilterBuildItem(OpenTelemetryReactiveServerFilter.class.getName()));
            preExceptionMapperHandlerBuildItemBuildProducer.produce((BuildItem)new PreExceptionMapperHandlerBuildItem((ServerRestHandler)new AttachExceptionHandler()));
        }
    }

    static class VertxHttpAvailable
    implements BooleanSupplier {
        private static final boolean IS_VERTX_HTTP_AVAILABLE = QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.vertx.http.runtime.VertxHttpRecorder");

        VertxHttpAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_VERTX_HTTP_AVAILABLE;
        }
    }

    static class GrpcExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_GRPC_EXTENSION_AVAILABLE = QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.grpc.runtime.GrpcServerRecorder");

        GrpcExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            return IS_GRPC_EXTENSION_AVAILABLE;
        }
    }

    static class MetricsExtensionAvailable
    implements BooleanSupplier {
        private static final boolean IS_MICROMETER_EXTENSION_AVAILABLE = QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics");

        MetricsExtensionAvailable() {
        }

        @Override
        public boolean getAsBoolean() {
            Config config = ConfigProvider.getConfig();
            if (IS_MICROMETER_EXTENSION_AVAILABLE && config.getOptionalValue("quarkus.micrometer.enabled", Boolean.class).orElse(true).booleanValue()) {
                Optional httpServerEnabled = config.getOptionalValue("quarkus.micrometer.binder.http-server.enabled", Boolean.class);
                if (httpServerEnabled.isPresent()) {
                    return (Boolean)httpServerEnabled.get();
                }
                return config.getOptionalValue("quarkus.micrometer.binder-enabled-default", Boolean.class).orElse(true);
            }
            return false;
        }
    }
}

