/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcRedirectFilter;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.Redirect;
import io.quarkus.oidc.runtime.LazyTenantConfigContext;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClientImpl;
import io.quarkus.oidc.runtime.TenantConfigContextImpl;
import io.smallrye.mutiny.Uni;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.crypto.SecretKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TenantConfigContext {
    public OidcTenantConfig oidcConfig();

    public OidcProvider provider();

    public boolean ready();

    public OidcTenantConfig getOidcTenantConfig();

    public OidcConfigurationMetadata getOidcMetadata();

    public OidcProviderClientImpl getOidcProviderClient();

    public SecretKey getStateCookieEncryptionKey();

    public SecretKey getSessionCookieEncryptionKey();

    public SecretKey getInternalIdTokenSigningKey();

    public Key getTokenDecryptionKey();

    public List<OidcRedirectFilter> getOidcRedirectFilters(Redirect.Location var1);

    public Map<Redirect.Location, List<OidcRedirectFilter>> getLocationToRedirectFilters();

    default public Uni<TenantConfigContext> initialize() {
        return Uni.createFrom().item((Object)this);
    }

    public static Uni<TenantConfigContext> createReady(OidcProvider provider, OidcTenantConfig config) {
        return TenantConfigContextImpl.createReady(provider, config);
    }

    public static TenantConfigContext createNotReady(OidcProvider provider, OidcTenantConfig config, Supplier<Uni<TenantConfigContext>> staticTenantCreator) {
        TenantConfigContextImpl notReadyContext = new TenantConfigContextImpl(provider, config, false, null);
        return new LazyTenantConfigContext(notReadyContext, staticTenantCreator);
    }
}

