/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Provider;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public abstract class LifecycleMappingProviderSupport
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    public LifecycleMappingProviderSupport() {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(this.loadMapping());
        this.lifecycleMapping = new LifecycleMapping(){

            public Map<String, Lifecycle> getLifecycles() {
                return Collections.singletonMap(LifecycleMappingProviderSupport.DEFAULT_LIFECYCLE_KEY, LifecycleMappingProviderSupport.this.defaultLifecycle);
            }

            public List<String> getOptionalMojos(String lifecycle) {
                return null;
            }

            public Map<String, String> getPhases(String lifecycle) {
                if (LifecycleMappingProviderSupport.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                    return LifecycleMappingProviderSupport.this.defaultLifecycle.getPhases();
                }
                return null;
            }
        };
    }

    private Map<String, LifecyclePhase> loadMapping() {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.getClass().getSimpleName() + ".properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashMap<String, LifecyclePhase> result = new HashMap<String, LifecyclePhase>();
        for (String phase : properties.stringPropertyNames()) {
            result.put(phase, new LifecyclePhase(properties.getProperty(phase)));
        }
        return result;
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }
}

