/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.registry.ValueRegistry;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class ValueRegistryParameterResolver
implements ParameterResolver {
    static final ValueRegistryParameterResolver INSTANCE = new ValueRegistryParameterResolver();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ValueRegistry valueRegistry = ValueRegistryParameterResolver.getValueRegistry(parameterContext, extensionContext);
        if (parameterContext.getParameter().getType().equals(ValueRegistry.class)) {
            return true;
        }
        return valueRegistry != null && valueRegistry.containsKey(ValueRegistry.RuntimeKey.key(parameterContext.getParameter().getType()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ValueRegistry valueRegistry = ValueRegistryParameterResolver.getValueRegistry(parameterContext, extensionContext);
        if (parameterContext.getParameter().getType().equals(ValueRegistry.class)) {
            return valueRegistry;
        }
        if (valueRegistry == null) {
            throw new ParameterResolutionException("Could not retrieve parameter: " + String.valueOf(parameterContext.getParameter()));
        }
        return valueRegistry.get(ValueRegistry.RuntimeKey.key(parameterContext.getParameter().getType()));
    }

    private static ValueRegistry getValueRegistry(ParameterContext parameterContext, ExtensionContext extensionContext) {
        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
        QuarkusTestExtensionState state = (QuarkusTestExtensionState)store.get((Object)QuarkusTestExtensionState.class.getName(), QuarkusTestExtensionState.class);
        if (state == null || state.getValueRegistry() == null) {
            return null;
        }
        return state.getValueRegistry();
    }
}

