/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.flyway.runtime.graal.JarFileClassPathLocationScannerSubstitutions;
import java.util.HashMap;
import java.util.function.BooleanSupplier;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.scanner.classpath.FileSystemClassPathLocationScanner;

@TargetClass(value=ClassPathScanner.class, onlyWith={IsJBossVFSAbsent.class})
public final class ClassPathScannerSubstitutions {
    @Alias
    private LocationScannerCache locationScannerCache;
    @Alias
    private ResourceNameCache resourceNameCache;

    @Substitute
    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if (this.locationScannerCache.containsKey(protocol)) {
            return this.locationScannerCache.get(protocol);
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, (ClassPathLocationScanner)locationScanner);
            this.resourceNameCache.put((ClassPathLocationScanner)locationScanner, new HashMap());
            return locationScanner;
        }
        if ("jar".equals(protocol)) {
            String separator = "!/";
            ClassPathLocationScanner locationScanner = (ClassPathLocationScanner)new JarFileClassPathLocationScannerSubstitutions(separator);
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        return null;
    }

    static final class IsJBossVFSAbsent
    implements BooleanSupplier {
        IsJBossVFSAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName("org.jboss.vfs.VFS");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
    }
}

