/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.quarkus.cli.plugin.Catalog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class CatalogService<T extends Catalog<T>> {
    protected static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    protected static final Predicate<Path> EXISTS_AND_WRITABLE = p -> p != null && p.toFile().exists() && p.toFile().canRead() && p.toFile().canWrite();
    protected static final Predicate<Path> IS_USER_HOME = p -> USER_HOME.equals(p);
    protected static final Predicate<Path> IS_ELIGIBLE_PROJECT_ROOT = EXISTS_AND_WRITABLE.and(Predicate.not(IS_USER_HOME));
    protected static final Predicate<Path> HAS_POM_XML = p -> p != null && p.resolve("pom.xml").toFile().exists();
    protected static final Predicate<Path> HAS_BUILD_GRADLE = p -> p != null && p.resolve("build.gradle").toFile().exists();
    protected static final Predicate<Path> GIT_ROOT = p -> p != null && p.resolve(".git").toFile().exists();
    protected final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(SerializationFeature.INDENT_OUTPUT).registerModule((Module)new Jdk8Module());
    protected final Class<T> catalogType;
    protected final Predicate<Path> projectRoot;
    protected final Function<Path, Path> relativePath;

    public CatalogService(Class<T> catalogType, Predicate<Path> projectRoot, Function<Path, Path> relativePath) {
        this.catalogType = catalogType;
        this.projectRoot = projectRoot;
        this.relativePath = relativePath;
    }

    public Optional<T> readUserCatalog(Optional<Path> userDir) {
        Path userCatalogPath = this.getUserCatalogPath(userDir);
        return Optional.of(userCatalogPath).map(this::readCatalog);
    }

    public Optional<T> readProjectCatalog(Optional<Path> dir) {
        Optional<Path> projectCatalogPath = this.findProjectCatalogPath(dir);
        return projectCatalogPath.map(this::readCatalog);
    }

    public Optional<Path> findProjectCatalogPath(Path dir) {
        return CatalogService.findProjectRoot(dir).map(this.relativePath);
    }

    public Optional<Path> findProjectCatalogPath(Optional<Path> dir) {
        return dir.flatMap(this::findProjectCatalogPath);
    }

    public Optional<T> readCatalog(Optional<Path> projectDir, Optional<Path> userDir) {
        return this.readProjectCatalog(projectDir).or(() -> this.readUserCatalog(userDir));
    }

    public T readCatalog(Path path) {
        try {
            return (path.toFile().length() == 0L ? (Catalog)this.catalogType.getConstructor(new Class[0]).newInstance(new Object[0]) : (Catalog)this.objectMapper.readValue(path.toFile(), this.catalogType)).withCatalogLocation(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCatalog(T catalog) {
        try {
            File catalogFile = catalog.getCatalogLocation().map(Path::toFile).orElseThrow(() -> new IllegalStateException("Don't know where to save catalog!"));
            if (!(catalogFile.exists() || catalogFile.getParentFile().mkdirs() || catalogFile.createNewFile())) {
                throw new IOException("Failed to create catalog at: " + catalogFile.getAbsolutePath());
            }
            this.objectMapper.writeValue(catalogFile, catalog.refreshLastUpdate());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getUserCatalogPath(Optional<Path> userDir) {
        return this.relativePath.apply(userDir.orElse(USER_HOME));
    }

    public Path getUserCatalogPath() {
        return this.getUserCatalogPath(Optional.empty());
    }

    public Optional<Path> getRelativeCatalogPath(Path dir) {
        return this.getRelativeCatalogPath(Optional.of(dir));
    }

    public Optional<Path> getRelativeCatalogPath(Optional<Path> dir) {
        return dir.or(() -> Optional.ofNullable(Paths.get(System.getProperty("user.dir"), new String[0]))).map(this.relativePath);
    }

    public Optional<Path> getCatalogPath(Optional<Path> projectDir, Optional<Path> userDir) {
        return this.getRelativeCatalogPath(projectDir).filter(EXISTS_AND_WRITABLE).or(() -> Optional.of(this.getUserCatalogPath(userDir)));
    }

    public static Optional<Path> findProjectRoot(Path dir) {
        Optional<Path> lastKnownProjectDirectory = Optional.empty();
        Path current = dir;
        while (IS_ELIGIBLE_PROJECT_ROOT.test(current)) {
            if (GIT_ROOT.test(current)) {
                return Optional.of(current);
            }
            if (HAS_POM_XML.test(current)) {
                lastKnownProjectDirectory = Optional.of(current);
            }
            if (HAS_BUILD_GRADLE.test(current)) {
                lastKnownProjectDirectory = Optional.of(current);
            }
            current = current.getParent();
        }
        return lastKnownProjectDirectory;
    }
}

