/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.codegen;

import io.quarkus.devtools.project.codegen.SourceType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public class CreateProjectHelper {
    public static final SortedSet<Integer> JAVA_VERSIONS_LTS = new TreeSet<Integer>(List.of(Integer.valueOf(11), Integer.valueOf(17)));
    private static final int DEFAULT_JAVA_VERSION = 11;
    public static final String DETECT_JAVA_RUNTIME_VERSION = "<<detect java runtime version>>";
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\..*)?");
    public static final String DEFAULT_GROUP_ID = "org.acme";
    public static final String DEFAULT_ARTIFACT_ID = "code-with-quarkus";
    public static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";

    private CreateProjectHelper() {
    }

    public static String checkClassName(String name) {
        if (!SourceVersion.isName(name)) {
            throw new IllegalArgumentException(name + " is not a valid class name");
        }
        return name;
    }

    public static String checkPackageName(String name) {
        if (!SourceVersion.isName(name)) {
            throw new IllegalArgumentException(name + " is not a valid package name");
        }
        return name;
    }

    public static Path checkProjectRootPath(Path outputPath, String name) {
        Objects.requireNonNull(name, "Must specify project name");
        Objects.requireNonNull(outputPath, "Must specify output path");
        Path projectRootPath = outputPath.resolve(name);
        if (projectRootPath.toFile().exists()) {
            throw new IllegalArgumentException("Target directory already exists: " + projectRootPath.toAbsolutePath().toString());
        }
        return projectRootPath;
    }

    public static Path createOutputDirectory(String targetDirectory) {
        Path origin = new File(System.getProperty("user.dir")).toPath();
        Path outputPath = targetDirectory == null ? origin : origin.resolve(targetDirectory);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create directory " + targetDirectory, e);
        }
        return outputPath;
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }

    public static void setJavaVersion(Map<String, Object> values, String javaTarget) {
        Matcher matcher;
        Objects.requireNonNull(values, "Must provide values");
        Integer javaFeatureVersionTarget = null;
        if (javaTarget != null && !DETECT_JAVA_RUNTIME_VERSION.equals(javaTarget) && (matcher = JAVA_VERSION_PATTERN.matcher(javaTarget)).matches()) {
            javaFeatureVersionTarget = Integer.valueOf(matcher.group(1));
        }
        if (javaFeatureVersionTarget == null) {
            javaFeatureVersionTarget = Runtime.version().feature();
        }
        values.put("java_target", String.valueOf(CreateProjectHelper.determineBestJavaLtsVersion(javaFeatureVersionTarget)));
    }

    public static int determineBestJavaLtsVersion() {
        return CreateProjectHelper.determineBestJavaLtsVersion(Runtime.version().feature());
    }

    public static int determineBestJavaLtsVersion(int runtimeVersion) {
        int ltsVersion;
        int bestLtsVersion = 11;
        Iterator iterator = JAVA_VERSIONS_LTS.iterator();
        while (iterator.hasNext() && (ltsVersion = ((Integer)iterator.next()).intValue()) <= runtimeVersion) {
            bestLtsVersion = ltsVersion;
        }
        return bestLtsVersion;
    }

    public static Set<String> sanitizeExtensions(Set<String> extensions) {
        if (extensions == null) {
            extensions = new HashSet<String>();
            return extensions;
        }
        return extensions.stream().filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
    }

    public static void addSourceTypeExtensions(Set<String> extensions, SourceType sourceType) {
        if (sourceType == SourceType.KOTLIN) {
            extensions.add("quarkus-kotlin");
        } else if (sourceType == SourceType.SCALA) {
            extensions.add("quarkus-scala");
        }
    }

    public static void handleSpringConfiguration(Map<String, Object> values) {
        Set extensions = (Set)values.get("extensions");
        CreateProjectHelper.handleSpringConfiguration(values, extensions);
    }

    public static void handleSpringConfiguration(Map<String, Object> values, Set<String> extensions) {
        Objects.requireNonNull(values, "Must provide values");
        Objects.requireNonNull(extensions, "Must provide extensions");
        if (CreateProjectHelper.containsSpringWeb(extensions)) {
            values.put("is_spring", true);
            if (CreateProjectHelper.containsRESTEasy(extensions)) {
                values.remove("class_name");
                values.remove("path");
            }
        }
    }

    private static boolean containsSpringWeb(Collection<String> extensions) {
        return extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }

    private static boolean containsRESTEasy(Collection<String> extensions) {
        return extensions.isEmpty() || extensions.stream().anyMatch(e -> e.toLowerCase().contains("resteasy"));
    }
}

