/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.jvm.ResolvedJVMRequirements;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveRequestedBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarIgnoredResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.deployment.pkg.jar.FastJarBuilder;
import io.quarkus.deployment.pkg.jar.LegacyThinJarBuilder;
import io.quarkus.deployment.pkg.jar.NativeImageSourceJarBuilder;
import io.quarkus.deployment.pkg.jar.UberJarBuilder;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public class JarResultBuildStep {
    @BuildStep
    OutputTargetBuildItem outputTarget(BuildSystemTargetBuildItem bst, PackageConfig packageConfig) {
        String name = packageConfig.outputName().orElseGet(bst::getBaseName);
        Path path = packageConfig.outputDirectory().map(s -> bst.getOutputDirectory().resolve((Path)s)).orElseGet(bst::getOutputDirectory);
        Optional<Object> includedOptionalDependencies = packageConfig.jar().filterOptionalDependencies() ? Optional.of(packageConfig.jar().includedOptionalDependencies().map(set -> set.stream().map(ArtifactKey.class::cast).collect(Collectors.toSet())).orElse(Collections.emptySet())) : Optional.empty();
        return new OutputTargetBuildItem(path, name, bst.getOriginalBaseName(), bst.isRebuild(), bst.getBuildSystemProps(), includedOptionalDependencies);
    }

    @BuildStep(onlyIf={JarRequired.class})
    ArtifactResultBuildItem jarOutput(JarBuildItem jarBuildItem) {
        return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", jarBuildItem.getLibraryDir() == null ? Map.of() : Map.of("library-dir", jarBuildItem.getLibraryDir().toString()), jarBuildItem.getManifestConfig());
    }

    @BuildStep
    public JarBuildItem buildRunnerJar(CurateOutcomeBuildItem curateOutcomeBuildItem, ResolvedJVMRequirements jvmRequirements, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, ClassLoadingConfig classLoadingConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarMergedResourceBuildItem> uberJarMergedResourceBuildItems, List<UberJarIgnoredResourceBuildItem> uberJarIgnoredResourceBuildItems, QuarkusBuildCloseablesBuildItem closeablesBuildItem, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItems, MainClassBuildItem mainClassBuildItem, Optional<JvmStartupOptimizerArchiveRequestedBuildItem> jvmStartupOptimizerArchiveRequested, ExecutorService buildExecutor) throws Exception {
        if (jvmStartupOptimizerArchiveRequested.isPresent()) {
            this.handleAppCDSSupportFileGeneration(transformedClasses, generatedClasses, jvmStartupOptimizerArchiveRequested.get());
        }
        Set<ArtifactKey> removedArtifactKeys = JarResultBuildStep.getRemovedArtifactKeys(classLoadingConfig);
        Set<ArtifactKey> parentFirstArtifactKeys = JarResultBuildStep.getParentFirstArtifactKeys(curateOutcomeBuildItem, classLoadingConfig);
        return switch (packageConfig.jar().type()) {
            default -> throw new IncompatibleClassChangeError();
            case PackageConfig.JarConfig.JarType.UBER_JAR -> new UberJarBuilder(curateOutcomeBuildItem, outputTargetBuildItem, applicationInfo, packageConfig, mainClassBuildItem, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, uberJarMergedResourceBuildItems, uberJarIgnoredResourceBuildItems, buildExecutor, jvmRequirements).build();
            case PackageConfig.JarConfig.JarType.LEGACY_JAR -> new LegacyThinJarBuilder(curateOutcomeBuildItem, outputTargetBuildItem, applicationInfo, packageConfig, mainClassBuildItem, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, buildExecutor, jvmRequirements).build();
            case PackageConfig.JarConfig.JarType.FAST_JAR, PackageConfig.JarConfig.JarType.MUTABLE_JAR -> new FastJarBuilder(curateOutcomeBuildItem, outputTargetBuildItem, applicationInfo, packageConfig, mainClassBuildItem, applicationArchivesBuildItem, additionalApplicationArchiveBuildItems, transformedClasses, generatedClasses, generatedResources, parentFirstArtifactKeys, removedArtifactKeys, buildExecutor, jvmRequirements).build();
        };
    }

    @BuildStep
    public NativeImageSourceJarBuildItem buildNativeImageJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedNativeImageClassBuildItem> nativeImageResources, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, ClassLoadingConfig classLoadingConfig, ExecutorService buildExecutor, ResolvedJVMRequirements jvmRequirements) throws Exception {
        return new NativeImageSourceJarBuilder(curateOutcomeBuildItem, outputTargetBuildItem, applicationInfo, packageConfig, mainClassBuildItem, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, nativeImageResources, JarResultBuildStep.getRemovedArtifactKeys(classLoadingConfig), buildExecutor, jvmRequirements).build();
    }

    private void handleAppCDSSupportFileGeneration(TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, JvmStartupOptimizerArchiveRequestedBuildItem jvmStartupOptimizerArchiveRequested) throws IOException {
        Path dir = jvmStartupOptimizerArchiveRequested.getDir();
        Path generatedClassesFile = dir.resolve("generatedAndTransformed.lst");
        try (BufferedWriter writer = Files.newBufferedWriter(generatedClassesFile, StandardOpenOption.CREATE);){
            StringBuilder classes = new StringBuilder();
            for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
                classes.append(generatedClassBuildItem.getName().replace('/', '.')).append(System.lineSeparator());
            }
            for (Set set : transformedClasses.getTransformedClassesByJar().values()) {
                for (TransformedClassesBuildItem.TransformedClass transformedClass : set) {
                    if (transformedClass.getData() == null) continue;
                    classes.append(transformedClass.getFileName().replace('/', '.').replace(".class", "")).append(System.lineSeparator());
                }
            }
            if (!classes.isEmpty()) {
                writer.write(classes.toString());
            }
        }
    }

    private static Set<ArtifactKey> getParentFirstArtifactKeys(CurateOutcomeBuildItem curateOutcomeBuildItem, ClassLoadingConfig classLoadingConfig) {
        HashSet<ArtifactKey> parentFirstKeys = new HashSet<ArtifactKey>();
        curateOutcomeBuildItem.getApplicationModel().getDependencies().forEach(d -> {
            if (d.isFlagSet(512)) {
                parentFirstKeys.add(d.getKey());
            }
        });
        classLoadingConfig.parentFirstArtifacts().ifPresent(parentFirstArtifacts -> {
            for (String artifact : parentFirstArtifacts) {
                parentFirstKeys.add((ArtifactKey)new GACT(artifact.split(":")));
            }
        });
        return parentFirstKeys;
    }

    private static Set<ArtifactKey> getRemovedArtifactKeys(ClassLoadingConfig classLoadingConfig) {
        if (classLoadingConfig.removedArtifacts().isEmpty()) {
            return Set.of();
        }
        HashSet<GACT> removedArtifacts = new HashSet<GACT>();
        for (String artifact : classLoadingConfig.removedArtifacts().get()) {
            removedArtifacts.add(GACT.fromString((String)artifact));
        }
        return Collections.unmodifiableSet(removedArtifacts);
    }

    static class JarRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;

        JarRequired(PackageConfig packageConfig) {
            this.packageConfig = packageConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.packageConfig.jar().enabled();
        }
    }
}

