/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildProvider;
import io.quarkus.builder.ChainBuildException;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.StepInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.wildfly.common.Assert;

public final class BuildChain {
    private final Set<ItemId> initialIds;
    private final int initialSingleCount;
    private final int initialMultiCount;
    private final Set<ItemId> finalIds;
    private final List<StepInfo> startSteps;
    private final Set<ItemId> consumed;
    private final List<BuildProvider> providers;
    private final int endStepCount;

    BuildChain(int initialSingleCount, int initialMultiCount, Set<StepInfo> startSteps, Set<ItemId> consumed, BuildChainBuilder builder, int endStepCount) {
        this.providers = builder.getProviders();
        this.initialIds = builder.getInitialIds();
        this.finalIds = builder.getFinalIds();
        this.initialSingleCount = initialSingleCount;
        this.initialMultiCount = initialMultiCount;
        this.startSteps = new ArrayList<StepInfo>(startSteps);
        this.consumed = consumed;
        this.endStepCount = endStepCount;
    }

    public BuildExecutionBuilder createExecutionBuilder(String name) {
        BuildExecutionBuilder builder = new BuildExecutionBuilder(this, name);
        for (BuildProvider provider : this.providers) {
            provider.prepareExecution(builder);
        }
        return builder;
    }

    public static BuildChainBuilder builder() {
        return new BuildChainBuilder();
    }

    static BuildChain fromProviders(ClassLoader classLoader) throws ChainBuildException {
        ArrayList<BuildProvider> list = new ArrayList<BuildProvider>();
        ServiceLoader<BuildProvider> serviceLoader = ServiceLoader.load(BuildProvider.class, classLoader);
        for (BuildProvider provider : serviceLoader) {
            list.add(provider);
        }
        return BuildChain.fromProviders(list);
    }

    static BuildChain fromProviders(Collection<BuildProvider> providers) throws ChainBuildException {
        Assert.checkNotNullParam((String)"providers", providers);
        BuildChainBuilder builder = BuildChain.builder();
        for (BuildProvider provider : providers) {
            builder.addProvider(provider);
        }
        return builder.build();
    }

    boolean hasInitial(ItemId itemId) {
        return this.initialIds.contains(itemId);
    }

    int getInitialSingleCount() {
        return this.initialSingleCount;
    }

    int getInitialMultiCount() {
        return this.initialMultiCount;
    }

    List<StepInfo> getStartSteps() {
        return this.startSteps;
    }

    Set<ItemId> getConsumed() {
        return this.consumed;
    }

    Set<ItemId> getFinalIds() {
        return this.finalIds;
    }

    int getEndStepCount() {
        return this.endStepCount;
    }
}

