/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.forkjoin.QuarkusForkJoinWorkerThread;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.DevModeMediator;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.bootstrap.runner.SerializedApplication;
import io.quarkus.bootstrap.runner.Timing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logmanager.LogManager;

public class QuarkusEntryPoint {
    public static final String QUARKUS_APPLICATION_DAT = "quarkus/quarkus-application.dat";
    public static final String LIB_DEPLOYMENT_APPMODEL_DAT = "lib/deployment/appmodel.dat";
    public static final String LIB_DEPLOYMENT_DEPLOYMENT_CLASS_PATH_DAT = "lib/deployment/deployment-class-path.dat";

    public static void main(String ... args) throws Throwable {
        System.setProperty("java.util.logging.manager", LogManager.class.getName());
        System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "io.quarkus.bootstrap.forkjoin.QuarkusForkJoinWorkerThreadFactory");
        Timing.staticInitStarted(false);
        try {
            QuarkusEntryPoint.doRun(args);
        }
        catch (Error | RuntimeException e) {
            InitialConfigurator.DELAYED_HANDLER.close();
            throw e;
        }
        catch (Throwable t) {
            InitialConfigurator.DELAYED_HANDLER.close();
            throw new UndeclaredThrowableException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRun(String ... args) throws Throwable {
        String path = null;
        URL location = QuarkusEntryPoint.class.getProtectionDomain().getCodeSource().getLocation();
        if (location == null) {
            String fullPath;
            String className = QuarkusEntryPoint.class.getSimpleName() + ".class";
            URL resource = QuarkusEntryPoint.class.getResource(className);
            if (resource != null && (fullPath = resource.toString()).startsWith("jar:")) {
                path = fullPath.substring(9, fullPath.indexOf("!"));
            }
        } else {
            path = location.getPath();
        }
        if (path == null) {
            throw new IllegalStateException("Unable to determine launch jar path");
        }
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
        Path appRoot = new File(decodedPath).toPath().getParent().getParent().getParent();
        if (Boolean.parseBoolean(System.getenv("QUARKUS_LAUNCH_DEVMODE"))) {
            DevModeMediator.doDevMode(appRoot);
        } else if (Boolean.getBoolean("quarkus.launch.rebuild")) {
            QuarkusEntryPoint.doReaugment(appRoot);
        } else {
            SerializedApplication app;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(appRoot.resolve(QUARKUS_APPLICATION_DAT), new OpenOption[0]), 24576);){
                app = SerializedApplication.read(in, appRoot);
            }
            RunnerClassLoader appRunnerClassLoader = app.getRunnerClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(appRunnerClassLoader);
                QuarkusForkJoinWorkerThread.setQuarkusAppClassloader(appRunnerClassLoader);
                Class<?> mainClass = appRunnerClassLoader.loadClass(app.getMainClass());
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                lookup.findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class)).invokeExact(args);
            }
            finally {
                QuarkusForkJoinWorkerThread.setQuarkusAppClassloader(null);
                appRunnerClassLoader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReaugment(Path appRoot) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!Files.exists(appRoot.resolve(LIB_DEPLOYMENT_DEPLOYMENT_CLASS_PATH_DAT), new LinkOption[0])) {
            System.out.println("[ERROR] Re-augmentation was requested, but the application wasn't built with 'quarkus.package.jar.type=mutable-jar'");
            return;
        }
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(appRoot.resolve(LIB_DEPLOYMENT_DEPLOYMENT_CLASS_PATH_DAT), new OpenOption[0]));){
            List paths = (List)in.readObject();
            try (URLClassLoader loader = new URLClassLoader((URL[])paths.stream().map(s -> {
                try {
                    return appRoot.resolve((String)s).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new));){
                loader.loadClass("io.quarkus.deployment.mutability.ReaugmentTask").getDeclaredMethod("main", Path.class).invoke(null, appRoot);
            }
        }
    }
}

