/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.maven.dependency.AbstractDependencyBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACTV;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArtifactDependency
extends GACTV
implements Dependency,
Serializable {
    private static final long serialVersionUID = 5669341172899612719L;
    private final String scope;
    private final int flags;
    private final Collection<ArtifactKey> exclusions;

    @Deprecated(forRemoval=true)
    public static Dependency of(String groupId, String artifactId, String version) {
        return new ArtifactDependency(groupId, artifactId, null, "jar", version);
    }

    static void putInMap(Dependency dependency, Map<String, Object> map, MappableCollectionFactory factory) {
        map.put("maven-artifact", dependency.toGACTVString());
        map.put("scope", dependency.getScope());
        map.put("flags", dependency.getFlags());
        if (!dependency.getExclusions().isEmpty()) {
            map.put("exclusions", Mappable.toStringCollection(dependency.getExclusions(), factory));
        }
    }

    public ArtifactDependency(String groupId, String artifactId, String classifier, String type, String version) {
        super(groupId, artifactId, classifier, type, version);
        this.scope = "compile";
        this.flags = 0;
        this.exclusions = List.of();
    }

    public ArtifactDependency(String groupId, String artifactId, String classifier, String type, String version, String scope, boolean optional) {
        super(groupId, artifactId, classifier, type, version);
        this.scope = scope;
        this.flags = optional ? 1 : 0;
        this.exclusions = List.of();
    }

    public ArtifactDependency(ArtifactCoords coords, int ... flags) {
        this(coords, "compile", flags);
    }

    public ArtifactDependency(ArtifactCoords coords, String scope, int ... flags) {
        super(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
        this.scope = scope;
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        this.flags = allFlags;
        this.exclusions = List.of();
    }

    public ArtifactDependency(Dependency d) {
        super(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion());
        this.scope = d.getScope();
        this.flags = d.getFlags();
        this.exclusions = d.getExclusions();
    }

    public ArtifactDependency(AbstractDependencyBuilder<?, ?> builder) {
        super(builder.getGroupId(), builder.getArtifactId(), builder.getClassifier(), builder.getType(), builder.getVersion());
        this.scope = builder.getScope();
        this.flags = builder.getFlags();
        this.exclusions = builder.exclusions.isEmpty() ? builder.exclusions : List.copyOf(builder.exclusions);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Collection<ArtifactKey> getExclusions() {
        return this.exclusions;
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(4);
        ArtifactDependency.putInMap(this, map, factory);
        return map;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.exclusions, this.flags, this.scope);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ArtifactDependency)) {
            return false;
        }
        ArtifactDependency other = (ArtifactDependency)obj;
        return this.flags == other.flags && Objects.equals(this.scope, other.scope) && this.exclusions.equals(other.exclusions);
    }

    @Override
    public String toString() {
        return "[" + this.toGACTVString() + " " + this.scope + " " + this.flags + "]";
    }
}

