/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.dev.ui;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.InactiveBeanException;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.DevMCPEnableByDefault;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class DatabaseInspector {
    private static final Logger LOG = Logger.getLogger(DatabaseInspector.class);
    @Inject
    Instance<AgroalDataSourceSupport> agroalDataSourceSupports;
    @Inject
    Optional<Assistant> assistant;
    private final Map<String, AgroalDataSource> checkedDataSources = new HashMap<String, AgroalDataSource>();
    private boolean isDev = false;
    private boolean allowSql = false;
    private String allowedHost = null;

    public DatabaseInspector() {
        LaunchMode currentMode = LaunchMode.current();
        this.isDev = currentMode.isDev() && !currentMode.isRemoteDev();
        Config config = ConfigProvider.getConfig();
        this.allowSql = config.getOptionalValue("quarkus.datasource.dev-ui.allow-sql", Boolean.class).orElse(false);
        this.allowedHost = config.getOptionalValue("quarkus.datasource.dev-ui.allowed-db-host", String.class).orElse(null);
    }

    @PostConstruct
    protected void init() {
        if (!this.agroalDataSourceSupports.isResolvable()) {
            return;
        }
        if (this.isDev) {
            AgroalDataSourceSupport agroalSupport = (AgroalDataSourceSupport)this.agroalDataSourceSupports.get();
            for (String name : agroalSupport.entries.keySet()) {
                AgroalDataSource ads;
                InjectableInstance dataSourceInstance;
                AgroalDataSourceSupport.Entry entry = (AgroalDataSourceSupport.Entry)agroalSupport.entries.get(name);
                if (entry == null || !(dataSourceInstance = AgroalDataSourceUtil.dataSourceInstance((String)name)).isResolvable() || !this.isAllowedDatabase(ads = (AgroalDataSource)dataSourceInstance.get())) continue;
                this.checkedDataSources.put(name, ads);
            }
        }
    }

    @JsonRpcDescription(value="Get all available datasources for the Database")
    @DevMCPEnableByDefault
    public List<Datasource> getDataSources() {
        if (this.isDev) {
            ArrayList<Datasource> datasources = new ArrayList<Datasource>();
            for (String ds : this.checkedDataSources.keySet()) {
                datasources.add(this.getDatasource(ds));
            }
            return datasources;
        }
        return List.of();
    }

    @JsonRpcDescription(value="Get a spesific datasource for the Database by name")
    @DevMCPEnableByDefault
    private Datasource getDatasource(@JsonRpcDescription(value="Datasource name") String datasource) {
        AgroalDataSource ads;
        if (this.isDev && this.isAllowedDatabase(ads = this.checkedDataSources.get(datasource))) {
            AgroalDataSourceConfiguration configuration = ads.getConfiguration();
            String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
            boolean isDefault = DataSourceUtil.isDefault((String)datasource);
            return new Datasource(datasource, jdbcUrl, isDefault);
        }
        return null;
    }

    @JsonRpcDescription(value="Get all the tables for a certain datasource")
    @DevMCPEnableByDefault
    public List<Table> getTables(@JsonRpcDescription(value="Datasource name") String datasource) {
        if (this.isDev) {
            ArrayList<Table> tableList;
            block31: {
                tableList = new ArrayList<Table>();
                try {
                    AgroalDataSource ads = this.checkedDataSources.get(datasource);
                    if (!this.isAllowedDatabase(ads)) break block31;
                    try (Connection connection = ads.getConnection();){
                        DatabaseMetaData metaData = connection.getMetaData();
                        try (ResultSet tables = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                String tableSchema = tables.getString("TABLE_SCHEM");
                                if (tableSchema == null) {
                                    tableSchema = tables.getString("TABLE_CAT");
                                }
                                List<String> primaryKeyList = this.getPrimaryKeys(metaData, tableSchema, tableName);
                                ArrayList<Column> columnList = new ArrayList<Column>();
                                try (ResultSet columns = metaData.getColumns(null, tableSchema, tableName, "%");){
                                    while (columns.next()) {
                                        String columnName = columns.getString("COLUMN_NAME");
                                        String columnType = columns.getString("TYPE_NAME");
                                        int columnSize = columns.getInt("COLUMN_SIZE");
                                        String nullable = columns.getString("IS_NULLABLE");
                                        int dataType = columns.getInt("DATA_TYPE");
                                        columnList.add(new Column(columnName, columnType, columnSize, nullable, this.isBinary(dataType)));
                                    }
                                }
                                ArrayList<ForeignKey> foreignKeyList = new ArrayList<ForeignKey>();
                                try (ResultSet fks = metaData.getImportedKeys(null, tableSchema, tableName);){
                                    while (fks.next()) {
                                        String fkColumn = fks.getString("FKCOLUMN_NAME");
                                        String pkTable = fks.getString("PKTABLE_NAME");
                                        String pkColumn = fks.getString("PKCOLUMN_NAME");
                                        foreignKeyList.add(new ForeignKey(fkColumn, pkTable, pkColumn));
                                    }
                                }
                                tableList.add(new Table(tableSchema, tableName, primaryKeyList, columnList, foreignKeyList));
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return tableList;
        }
        return null;
    }

    @JsonRpcDescription(value="Generate an ER Diagram in dot (graphviz) format for a certain datasource")
    public String generateDot(@JsonRpcDescription(value="Datasource name") String datasource) {
        if (this.isDev) {
            List<Table> tables = this.getTables(datasource);
            StringBuilder dot = new StringBuilder();
            dot.append("digraph ER {\n");
            dot.append("  graph [splines=ortho, nodesep=1, ranksep=2];\n");
            dot.append("  node [shape=record, fontname=Helvetica];\n\n");
            for (Table table : tables) {
                StringBuilder fields = new StringBuilder();
                for (Column col : table.columns()) {
                    boolean isPK = table.primaryKeys().contains(col.columnName());
                    fields.append(col.columnName()).append(": ").append(col.columnType()).append(" (").append(col.columnSize()).append(")").append(isPK ? " (PK)" : "").append("\\l");
                }
                dot.append("  ").append(this.escape(table.tableName())).append(" [label=\"{").append(table.tableName()).append("|").append((CharSequence)fields).append("}\"];\n");
                for (ForeignKey fk : table.foreignKeys()) {
                    dot.append("  ").append(this.escape(table.tableName())).append(" -> ").append(this.escape(fk.referencedTable())).append(" [label=\"").append(fk.columnName()).append(" \u2192 ").append(fk.referencedColumn()).append("\"];\n");
                }
            }
            dot.append("}\n");
            return dot.toString();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @JsonRpcDescription(value="Execute SQL against a certain datasource")
    @DevMCPEnableByDefault
    public DataSet executeSQL(@JsonRpcDescription(value="Datasource name") String datasource, @JsonRpcDescription(value="Valid SQL to execute") String sql, @JsonRpcDescription(value="Page number for pagable rusults, starting at 1") Integer pageNumber, @JsonRpcDescription(value="Number of rows in a page, example 10") Integer pageSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @JsonRpcDescription(value="Get the import.sql script for a certain datasource")
    public String getInsertScript(@JsonRpcDescription(value="Datasource name") String datasource) {
        block23: {
            if (this.isDev) {
                try {
                    AgroalDataSource ads = this.checkedDataSources.get(datasource);
                    if (!this.isAllowedDatabase(ads)) break block23;
                    try (Connection connection = ads.getConnection();){
                        String string;
                        try (StringWriter writer = new StringWriter();){
                            DatabaseMetaData metaData = connection.getMetaData();
                            try (ResultSet tables = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                                while (tables.next()) {
                                    String tableName = tables.getString("TABLE_NAME");
                                    this.exportTable(connection, writer, tableName);
                                }
                            }
                            string = writer.toString();
                        }
                        return string;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    public CompletionStage<Map<String, String>> generateTableData(String datasource, String schema, String name, int rowCount) {
        List<Table> tables;
        Optional<Table> matchingTable;
        if (this.isDev && this.assistant.isPresent() && (matchingTable = (tables = this.getTables(datasource)).stream().filter(t -> t.tableSchema().equals(schema) && t.tableName().equals(name)).findFirst()).isPresent()) {
            return this.assistant.get().assistBuilder().userMessage(this.generateInsertPrompt(matchingTable.get(), rowCount)).responseType(InsertStatementResponse.class).assist();
        }
        return CompletableFuture.failedStage(new RuntimeException("Assistant is not available"));
    }

    public CompletionStage<Map<String, String>> englishToSQL(String datasource, String schema, String name, String english) {
        if (this.isDev && this.assistant.isPresent()) {
            List<Table> tables = this.getTables(datasource);
            return this.assistant.get().assistBuilder().userMessage(this.englishToSqlPrompt(tables, schema, name, english)).responseType(EnglishToSQLResponse.class).assist();
        }
        return CompletableFuture.failedStage(new RuntimeException("Assistant is not available"));
    }

    private void exportTable(Connection conn, StringWriter writer, String tableName) throws SQLException, IOException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                int i;
                StringBuilder insertQuery = new StringBuilder("INSERT INTO " + tableName + " (");
                for (i = 1; i <= columnCount; ++i) {
                    insertQuery.append(metaData.getColumnName(i));
                    if (i >= columnCount) continue;
                    insertQuery.append(", ");
                }
                insertQuery.append(") VALUES (");
                for (i = 1; i <= columnCount; ++i) {
                    Object value = rs.getObject(i);
                    if (value == null) {
                        insertQuery.append("NULL");
                    } else if (value instanceof String || value instanceof Date || value instanceof Timestamp) {
                        insertQuery.append("'").append(value.toString().replace("'", "''")).append("'");
                    } else {
                        insertQuery.append(value.toString());
                    }
                    if (i >= columnCount) continue;
                    insertQuery.append(", ");
                }
                insertQuery.append(");\n");
                writer.write(insertQuery.toString());
            }
        }
    }

    private String escape(String value) {
        return "\"" + value.replace("\"", "\\\"") + "\"";
    }

    private boolean sqlIsValid(String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (this.allowSql) {
            return true;
        }
        String lsql = sql.toLowerCase().trim();
        return lsql.startsWith("select") && !lsql.contains("update ") && !lsql.contains("delete ") && !lsql.contains("insert ") && !lsql.contains("create ") && !lsql.contains("drop ");
    }

    private List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableSchema, String tableName) throws SQLException {
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        try (ResultSet primaryKeys = metaData.getPrimaryKeys(null, tableSchema, tableName);){
            while (primaryKeys.next()) {
                String primaryKeyColumn = primaryKeys.getString("COLUMN_NAME");
                primaryKeyList.add(primaryKeyColumn);
            }
        }
        return primaryKeyList;
    }

    private boolean isAllowedDatabase(AgroalDataSource ads) {
        String allowedHost;
        String string = allowedHost = this.allowedHost == null ? null : this.allowedHost.trim();
        if (allowedHost != null && allowedHost.equals("*")) {
            return true;
        }
        if (ads == null) {
            return false;
        }
        try {
            AgroalDataSourceConfiguration configuration = ads.getConfiguration();
            String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
            if (jdbcUrl.startsWith("jdbc:h2:mem:") || jdbcUrl.startsWith("jdbc:h2:file:") || jdbcUrl.startsWith("jdbc:h2:tcp://localhost") || allowedHost != null && !allowedHost.isBlank() && jdbcUrl.startsWith("jdbc:h2:tcp://" + allowedHost)) {
                return true;
            }
            String cleanUrl = jdbcUrl.replace("jdbc:", "").replaceFirst(";", "?").replace(";", "&");
            URI uri = new URI(cleanUrl);
            String host = uri.getHost();
            return host != null && (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || allowedHost != null && !allowedHost.isBlank() && host.equalsIgnoreCase(allowedHost));
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (InactiveBeanException inactiveBeanException) {
            // empty catch block
        }
        return false;
    }

    private boolean isBinary(int dataType, String javaClassName) {
        if (UUID.class.getName().equals(javaClassName)) {
            return false;
        }
        return this.isBinary(dataType);
    }

    private boolean isBinary(int dataType) {
        return dataType == 2004 || dataType == -3 || dataType == -4 || dataType == -2 || dataType == 2000 || dataType == 1111;
    }

    private String englishToSqlPrompt(List<Table> tables, String schema, String name, String english) {
        StringBuilder sb = new StringBuilder();
        sb.append("Generate valid SQL given the following english statement: \n").append(english).append("\n\nAnd this is the known tables in the database:\n");
        for (Table table : tables) {
            sb.append(this.getTableDefinitionAsString(table));
            sb.append("\n\n");
        }
        sb.append("\nIf you can not defer the schema name from the english statement, use ").append(schema).append(" as the schema name");
        sb.append("\nIf you can not defer the table name from the english statement, use ").append(name).append(" as the table name");
        sb.append("\nReturn the output in a field called `sql` with the contents being valid SQL");
        sb.append("\nIf you can not reliably create this sql, rather create an output with a field called error containing the reason");
        return sb.toString();
    }

    private String generateInsertPrompt(Table table, int rowCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("Generate a valid SQL script with ").append(rowCount).append(" INSERT statements for the following table:\n\n");
        sb.append(this.getTableDefinitionAsString(table));
        sb.append("\nReturn the output in a field called `script` with the contents being a SQL script with valid INSERT INTO statements for ").append(table.tableSchema()).append(".").append(table.tableName()).append(".\n");
        return sb.toString();
    }

    private String getTableDefinitionAsString(Table table) {
        StringBuilder sb = new StringBuilder();
        sb.append("Table name: ").append(table.tableSchema()).append(".").append(table.tableName()).append("\n\n");
        sb.append("Columns:\n");
        for (Column column : table.columns()) {
            sb.append("- ").append(column.columnName()).append(" (").append(column.columnType());
            if (column.columnType().equalsIgnoreCase("varchar")) {
                sb.append("(").append(column.columnSize()).append(")");
            }
            sb.append(", nullable: ").append(column.nullable());
            sb.append(")\n");
        }
        if (!table.primaryKeys().isEmpty()) {
            sb.append("\nPrimary key(s): ").append(String.join((CharSequence)", ", table.primaryKeys())).append("\n");
        }
        if (!table.foreignKeys().isEmpty()) {
            sb.append("\nForeign keys:\n");
            for (ForeignKey fk : table.foreignKeys()) {
                sb.append("- ").append(fk.columnName()).append(" references ").append(fk.referencedTable()).append("(").append(fk.referencedColumn()).append(")\n");
            }
        }
        return sb.toString();
    }

    private record Datasource(String name, String jdbcUrl, boolean isDefault) {
    }

    private record Column(String columnName, String columnType, int columnSize, String nullable, boolean binary) {
    }

    private record ForeignKey(String columnName, String referencedTable, String referencedColumn) {
    }

    private record Table(String tableSchema, String tableName, List<String> primaryKeys, List<Column> columns, List<ForeignKey> foreignKeys) {
    }

    private record DataSet(List<String> cols, List<Map<String, String>> data, String error, String message, int totalNumberOfElements) {
    }

    record InsertStatementResponse(String script) {
    }

    record EnglishToSQLResponse(String sql, String error) {
    }
}

