/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.AggregatedDataSourceBuildTimeConfigBuildItem;
import io.quarkus.agroal.deployment.JdbcDataSourceBuildItem;
import io.quarkus.agroal.deployment.JdbcDriverBuildItem;
import io.quarkus.agroal.runtime.AgroalRecorder;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourceSupport;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.LegacyDataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.LegacyDataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.runtime.metrics.AgroalCounter;
import io.quarkus.agroal.runtime.metrics.AgroalGauge;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import javax.sql.XADataSource;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final DotName DATA_SOURCE = DotName.createSimple((String)javax.sql.DataSource.class.getName());
    private static final String QUARKUS_DATASOURCE_CONFIG_PREFIX = "quarkus.datasource.";
    private static final String QUARKUS_DATASOURCE_DB_KIND_CONFIG_NAME = "db-kind";
    private static final String QUARKUS_DATASOURCE_DRIVER_CONFIG_NAME = "driver";

    AgroalProcessor() {
    }

    @BuildStep
    void agroal(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.AGROAL));
        capability.produce((BuildItem)new CapabilityBuildItem(Capability.AGROAL));
    }

    @BuildStep
    void build(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, LegacyDataSourcesJdbcBuildTimeConfig legacyDataSourcesJdbcBuildTimeConfig, List<JdbcDriverBuildItem> jdbcDriverBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedConfig) throws Exception {
        List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedDataSourceBuildTimeConfigs = this.getAggregatedConfigBuildItems(dataSourcesBuildTimeConfig, dataSourcesJdbcBuildTimeConfig, legacyDataSourcesJdbcBuildTimeConfig, jdbcDriverBuildItems);
        if (aggregatedDataSourceBuildTimeConfigs.isEmpty()) {
            log.warn((Object)"The Agroal dependency is present but no JDBC datasources have been defined.");
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedDataSourceBuildTimeConfigs) {
            AgroalProcessor.validateBuildTimeConfig(aggregatedDataSourceBuildTimeConfig);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass()}));
            aggregatedConfig.produce((BuildItem)aggregatedDataSourceBuildTimeConfig);
        }
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.AGROAL.getName()));
    }

    private static void validateBuildTimeConfig(AggregatedDataSourceBuildTimeConfigBuildItem aggregatedConfig) {
        Class<?> driver;
        DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig = aggregatedConfig.getJdbcConfig();
        String fullDataSourceName = aggregatedConfig.isDefault() ? "default datasource" : "datasource named '" + aggregatedConfig.getName() + "'";
        String driverName = aggregatedConfig.getResolvedDriverClass();
        try {
            driver = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to load the datasource driver " + driverName + " for the " + fullDataSourceName, (Throwable)e);
        }
        if (jdbcBuildTimeConfig.transactions == TransactionIntegration.XA) {
            if (!XADataSource.class.isAssignableFrom(driver)) {
                throw new ConfigurationException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the " + fullDataSourceName + ": either disable XA or switch the driver to an XADataSource");
            }
        } else if (driver != null && !javax.sql.DataSource.class.isAssignableFrom(driver) && !Driver.class.isAssignableFrom(driver)) {
            if (aggregatedConfig.isDefault()) {
                throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the default datasource; please either set 'quarkus.datasource.jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
            }
            throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the datasource named '" + fullDataSourceName + "'; please either set 'quarkus.datasource." + fullDataSourceName + ".jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
        }
    }

    private DataSourceSupport getDataSourceSupport(List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities) {
        HashMap<String, DataSourceSupport.Entry> dataSourceSupportEntries = new HashMap<String, DataSourceSupport.Entry>();
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedBuildTimeConfigBuildItems) {
            String dataSourceName = aggregatedDataSourceBuildTimeConfig.getName();
            dataSourceSupportEntries.put(dataSourceName, new DataSourceSupport.Entry(dataSourceName, aggregatedDataSourceBuildTimeConfig.getResolvedDbKind(), aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass(), aggregatedDataSourceBuildTimeConfig.isLegacy(), aggregatedDataSourceBuildTimeConfig.isDefault()));
        }
        return new DataSourceSupport(sslNativeConfig.isExplicitlyDisabled(), capabilities.isPresent(Capability.METRICS), dataSourceSupportEntries);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateDataSourceSupportBean(AgroalRecorder recorder, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DataSources.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DataSource.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AgroalPoolInterceptor.class));
        DataSourceSupport dataSourceSupport = this.getDataSourceSupport(aggregatedBuildTimeConfigBuildItems, sslNativeConfig, capabilities);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DataSourceSupport.class).supplier(recorder.dataSourceSupportSupplier(dataSourceSupport)).unremovable()).done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateDataSourceBeans(AgroalRecorder recorder, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<JdbcDataSourceBuildItem> jdbcDataSource) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.getDataSourceSupport(aggregatedBuildTimeConfigBuildItems, (SslNativeConfigBuildItem)sslNativeConfig, (Capabilities)capabilities).entries.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(AgroalDataSource.class).addType(DATA_SOURCE)).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(recorder.agroalDataSourceSupplier(dataSourceName, dataSourcesRuntimeConfig));
            if (((DataSourceSupport.Entry)entry.getValue()).isDefault) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.name(dataSourceName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
                configurator.addQualifier().annotation(DataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
            jdbcDataSource.produce((BuildItem)new JdbcDataSourceBuildItem(dataSourceName, ((DataSourceSupport.Entry)entry.getValue()).resolvedDbKind, ((DataSourceSupport.Entry)entry.getValue()).isDefault));
        }
    }

    @BuildStep
    void configureDataSources(BuildProducer<JdbcDataSourceBuildItem> jdbcDataSource, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedBuildTimeConfigBuildItem : aggregatedBuildTimeConfigBuildItems) {
            jdbcDataSource.produce((BuildItem)new JdbcDataSourceBuildItem(aggregatedBuildTimeConfigBuildItem.getName(), aggregatedBuildTimeConfigBuildItem.getResolvedDbKind(), DataSourceUtil.isDefault((String)aggregatedBuildTimeConfigBuildItem.getName())));
        }
    }

    private List<AggregatedDataSourceBuildTimeConfigBuildItem> getAggregatedConfigBuildItems(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, LegacyDataSourcesJdbcBuildTimeConfig legacyDataSourcesJdbcBuildTimeConfig, List<JdbcDriverBuildItem> jdbcDriverBuildItems) {
        String resolvedDbKind;
        boolean alreadyConfigured;
        ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem> dataSources = new ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem>();
        if (dataSourcesBuildTimeConfig.defaultDataSource.dbKind.isPresent() && dataSourcesJdbcBuildTimeConfig.jdbc.enabled) {
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem("<default>", dataSourcesBuildTimeConfig.defaultDataSource, dataSourcesJdbcBuildTimeConfig.jdbc, null, (String)dataSourcesBuildTimeConfig.defaultDataSource.dbKind.get(), this.resolveDriver(null, dataSourcesBuildTimeConfig.defaultDataSource, dataSourcesJdbcBuildTimeConfig.jdbc, jdbcDriverBuildItems), false));
        }
        for (Map.Entry entry : dataSourcesBuildTimeConfig.namedDataSources.entrySet()) {
            DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig;
            DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig = jdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig.namedDataSources.containsKey(entry.getKey()) ? ((DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig)dataSourcesJdbcBuildTimeConfig.namedDataSources.get(entry.getKey())).jdbc : new DataSourceJdbcBuildTimeConfig();
            if (!jdbcBuildTimeConfig.enabled) continue;
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem((String)entry.getKey(), (DataSourceBuildTimeConfig)entry.getValue(), jdbcBuildTimeConfig, null, (String)((DataSourceBuildTimeConfig)entry.getValue()).dbKind.get(), this.resolveDriver((String)entry.getKey(), (DataSourceBuildTimeConfig)entry.getValue(), jdbcBuildTimeConfig, jdbcDriverBuildItems), false));
        }
        if (legacyDataSourcesJdbcBuildTimeConfig.defaultDataSource.driver.isPresent() && !(alreadyConfigured = this.ensureNoConfigurationClash(dataSources, "<default>", resolvedDbKind = this.resolveLegacyKind((String)legacyDataSourcesJdbcBuildTimeConfig.defaultDataSource.driver.get())))) {
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem("<default>", dataSourcesBuildTimeConfig.defaultDataSource, dataSourcesJdbcBuildTimeConfig.jdbc, legacyDataSourcesJdbcBuildTimeConfig.defaultDataSource, resolvedDbKind, (String)legacyDataSourcesJdbcBuildTimeConfig.defaultDataSource.driver.get(), true));
        }
        for (Map.Entry entry : legacyDataSourcesJdbcBuildTimeConfig.namedDataSources.entrySet()) {
            DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig;
            String datasourceName = (String)entry.getKey();
            DataSourceBuildTimeConfig dataSourceBuildTimeConfig = dataSourcesBuildTimeConfig.namedDataSources.containsKey(datasourceName) ? (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.namedDataSources.get(datasourceName) : new DataSourceBuildTimeConfig();
            DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig = jdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig.namedDataSources.containsKey(datasourceName) ? ((DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig)dataSourcesJdbcBuildTimeConfig.namedDataSources.get((Object)datasourceName)).jdbc : new DataSourceJdbcBuildTimeConfig();
            String resolvedDbKind2 = this.resolveLegacyKind((String)((LegacyDataSourceJdbcBuildTimeConfig)entry.getValue()).driver.get());
            boolean alreadyConfigured2 = this.ensureNoConfigurationClash(dataSources, datasourceName, resolvedDbKind2);
            if (alreadyConfigured2) continue;
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem(datasourceName, dataSourceBuildTimeConfig, jdbcBuildTimeConfig, (LegacyDataSourceJdbcBuildTimeConfig)entry.getValue(), resolvedDbKind2, (String)((LegacyDataSourceJdbcBuildTimeConfig)entry.getValue()).driver.get(), true));
        }
        return dataSources;
    }

    private boolean ensureNoConfigurationClash(List<AggregatedDataSourceBuildTimeConfigBuildItem> dataSources, String datasourceName, String resolvedDbKind) {
        boolean alreadyConfigured = false;
        for (AggregatedDataSourceBuildTimeConfigBuildItem alreadyConfiguredDataSource : dataSources) {
            if (!alreadyConfiguredDataSource.getName().equals(datasourceName)) continue;
            if (!alreadyConfiguredDataSource.getResolvedDbKind().equals(resolvedDbKind)) {
                throw new RuntimeException("Incompatible values detected between " + this.quotedDataSourcePropertyName(datasourceName, QUARKUS_DATASOURCE_DB_KIND_CONFIG_NAME) + " and " + this.quotedDataSourcePropertyName(datasourceName, QUARKUS_DATASOURCE_DRIVER_CONFIG_NAME) + ". Consider removing the latter.");
            }
            alreadyConfigured = true;
        }
        if (alreadyConfigured) {
            log.warn((Object)("Configuring " + this.quotedDataSourcePropertyName(datasourceName, QUARKUS_DATASOURCE_DRIVER_CONFIG_NAME) + " is redundant when " + this.quotedDataSourcePropertyName(datasourceName, QUARKUS_DATASOURCE_DB_KIND_CONFIG_NAME) + " is also configured"));
        }
        return alreadyConfigured;
    }

    private String quotedDataSourcePropertyName(String datasourceName, String propertyName) {
        return "\"" + this.dataSourcePropertyName(datasourceName, propertyName) + "\"";
    }

    private String dataSourcePropertyName(String datasourceName, String propertyName) {
        if ("<default>".equals(datasourceName)) {
            return QUARKUS_DATASOURCE_CONFIG_PREFIX + propertyName;
        }
        return QUARKUS_DATASOURCE_CONFIG_PREFIX + datasourceName + "." + propertyName;
    }

    private String resolveDriver(String dataSourceName, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, List<JdbcDriverBuildItem> jdbcDriverBuildItems) {
        if (dataSourceJdbcBuildTimeConfig.driver.isPresent()) {
            return (String)dataSourceJdbcBuildTimeConfig.driver.get();
        }
        Optional<JdbcDriverBuildItem> matchingJdbcDriver = jdbcDriverBuildItems.stream().filter(i -> ((String)dataSourceBuildTimeConfig.dbKind.get()).equals(i.getDbKind())).findFirst();
        if (matchingJdbcDriver.isPresent()) {
            if (TransactionIntegration.XA == dataSourceJdbcBuildTimeConfig.transactions) {
                if (matchingJdbcDriver.get().getDriverXAClass().isPresent()) {
                    return (String)matchingJdbcDriver.get().getDriverXAClass().get();
                }
            } else {
                return matchingJdbcDriver.get().getDriverClass();
            }
        }
        throw new ConfigurationException("Unable to determine the driver for " + (dataSourceName == null ? "default datasource" : "datasource named " + dataSourceName));
    }

    private String resolveLegacyKind(String driver) {
        switch (driver) {
            case "org.apache.derby.jdbc.ClientDriver": 
            case "org.apache.derby.jdbc.ClientXADataSource": {
                return "derby";
            }
            case "org.h2.Driver": 
            case "org.h2.jdbcx.JdbcDataSource": {
                return "h2";
            }
            case "org.mariadb.jdbc.Driver": 
            case "org.mariadb.jdbc.MySQLDataSource": {
                return "mariadb";
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": 
            case "com.microsoft.sqlserver.jdbc.SQLServerXADataSource": {
                return "mssql";
            }
            case "com.mysql.cj.jdbc.Driver": 
            case "com.mysql.cj.jdbc.MysqlXADataSource": {
                return "mysql";
            }
            case "org.postgresql.Driver": 
            case "org.postgresql.xa.PGXADataSource": {
                return "postgresql";
            }
        }
        return "other-legacy";
    }

    @BuildStep
    HealthBuildItem addHealthCheck(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        return new HealthBuildItem("io.quarkus.agroal.runtime.health.DataSourceHealthCheck", dataSourcesBuildTimeConfig.healthEnabled);
    }

    @BuildStep
    void registerMetrics(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedDataSourceBuildTimeConfigs, BuildProducer<MetricBuildItem> metrics) {
        Metadata activeCountMetadata = Metadata.builder().withName("agroal.active.count").withDescription("Number of active connections. These connections are in use and not available to be acquired.").withType(MetricType.GAUGE).build();
        Metadata availableCountMetadata = Metadata.builder().withName("agroal.available.count").withDescription("Number of idle connections in the pool, available to be acquired.").withType(MetricType.GAUGE).build();
        Metadata maxUsedCountMetadata = Metadata.builder().withName("agroal.max.used.count").withDescription("Maximum number of connections active simultaneously.").withType(MetricType.GAUGE).build();
        Metadata awaitingCountMetadata = Metadata.builder().withName("agroal.awaiting.count").withDescription("Approximate number of threads blocked, waiting to acquire a connection.").withType(MetricType.GAUGE).build();
        Metadata blockingTimeAverageMetadata = Metadata.builder().withName("agroal.blocking.time.average").withDescription("Average time an application waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata blockingTimeMaxMetadata = Metadata.builder().withName("agroal.blocking.time.max").withDescription("Maximum time an application waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata blockingTimeTotalMetadata = Metadata.builder().withName("agroal.blocking.time.total").withDescription("Total time applications waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeAverageMetadata = Metadata.builder().withName("agroal.creation.time.average").withDescription("Average time for a connection to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeMaxMetadata = Metadata.builder().withName("agroal.creation.time.max").withDescription("Maximum time for a connection to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeTotalMetadata = Metadata.builder().withName("agroal.creation.time.total").withDescription("Total time waiting for connections to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata acquireCountMetadata = Metadata.builder().withName("agroal.acquire.count").withDescription("Number of times an acquire operation succeeded.").withType(MetricType.COUNTER).build();
        Metadata creationCountMetadata = Metadata.builder().withName("agroal.creation.count").withDescription("Number of created connections.").withType(MetricType.COUNTER).build();
        Metadata leakDetectionCountMetadata = Metadata.builder().withName("agroal.leak.detection.count").withDescription("Number of times a leak was detected. A single connection can be detected multiple times.").withType(MetricType.COUNTER).build();
        Metadata destroyCountMetadata = Metadata.builder().withName("agroal.destroy.count").withDescription("Number of destroyed connections.").withType(MetricType.COUNTER).build();
        Metadata flushCountMetadata = Metadata.builder().withName("agroal.flush.count").withDescription("Number of connections removed from the pool, not counting invalid / idle.").withType(MetricType.COUNTER).build();
        Metadata invalidCountMetadata = Metadata.builder().withName("agroal.invalid.count").withDescription("Number of connections removed from the pool for being invalid.").withType(MetricType.COUNTER).build();
        Metadata reapCountMetadata = Metadata.builder().withName("agroal.reap.count").withDescription("Number of connections removed from the pool for being idle.").withType(MetricType.COUNTER).build();
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedDataSourceBuildTimeConfigs) {
            String dataSourceName = aggregatedDataSourceBuildTimeConfig.getName();
            boolean metricsEnabledForThisDatasource = dataSourcesBuildTimeConfig.metricsEnabled && aggregatedDataSourceBuildTimeConfig.getJdbcConfig().enableMetrics.orElse(true) != false;
            Tag tag = new Tag("datasource", DataSourceUtil.isDefault((String)dataSourceName) ? "default" : dataSourceName);
            String configRootName = "datasource";
            metrics.produce((BuildItem)new MetricBuildItem(activeCountMetadata, (Object)new AgroalGauge(dataSourceName, "activeCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(maxUsedCountMetadata, (Object)new AgroalGauge(dataSourceName, "maxUsedCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(awaitingCountMetadata, (Object)new AgroalGauge(dataSourceName, "awaitingCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(availableCountMetadata, (Object)new AgroalGauge(dataSourceName, "availableCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeAverageMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeAverage"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeMaxMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeMax"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeTotalMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeTotal"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeAverageMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeAverage"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeMaxMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeMax"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeTotalMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeTotal"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(acquireCountMetadata, (Object)new AgroalCounter(dataSourceName, "acquireCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationCountMetadata, (Object)new AgroalCounter(dataSourceName, "creationCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(leakDetectionCountMetadata, (Object)new AgroalCounter(dataSourceName, "leakDetectionCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(destroyCountMetadata, (Object)new AgroalCounter(dataSourceName, "destroyCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(flushCountMetadata, (Object)new AgroalCounter(dataSourceName, "flushCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(invalidCountMetadata, (Object)new AgroalCounter(dataSourceName, "invalidCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(reapCountMetadata, (Object)new AgroalCounter(dataSourceName, "reapCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
        }
    }
}

