/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.InvokeKind;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ArrayVarHandleConst;
import io.quarkus.gizmo2.impl.constant.BooleanConst;
import io.quarkus.gizmo2.impl.constant.ByteConst;
import io.quarkus.gizmo2.impl.constant.CharConst;
import io.quarkus.gizmo2.impl.constant.ClassConst;
import io.quarkus.gizmo2.impl.constant.DoubleConst;
import io.quarkus.gizmo2.impl.constant.DynamicConst;
import io.quarkus.gizmo2.impl.constant.EnumConst;
import io.quarkus.gizmo2.impl.constant.FieldVarHandleConst;
import io.quarkus.gizmo2.impl.constant.FloatConst;
import io.quarkus.gizmo2.impl.constant.IntConst;
import io.quarkus.gizmo2.impl.constant.InvokeConst;
import io.quarkus.gizmo2.impl.constant.LongConst;
import io.quarkus.gizmo2.impl.constant.MethodHandleConst;
import io.quarkus.gizmo2.impl.constant.MethodTypeConst;
import io.quarkus.gizmo2.impl.constant.NullConst;
import io.quarkus.gizmo2.impl.constant.ShortConst;
import io.quarkus.gizmo2.impl.constant.StaticFieldVarHandleConst;
import io.quarkus.gizmo2.impl.constant.StaticFinalFieldConst;
import io.quarkus.gizmo2.impl.constant.StringConst;
import io.quarkus.gizmo2.impl.constant.VoidConst;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.VarHandle;
import java.util.List;

public abstract class ConstImpl
extends Item
implements Const {
    ConstImpl(ClassDesc type) {
        super(type);
    }

    public static StringConst of(String value) {
        return new StringConst(value);
    }

    public static ConstImpl of(Constable constable) {
        Assert.checkNotNullParam((String)"constable", (Object)constable);
        if (constable instanceof ConstImpl) {
            ConstImpl con = (ConstImpl)constable;
            return con;
        }
        if (constable instanceof Boolean) {
            Boolean val = (Boolean)constable;
            return ConstImpl.of(val);
        }
        if (constable instanceof Byte) {
            Byte val = (Byte)constable;
            return ConstImpl.of(val);
        }
        if (constable instanceof Short) {
            Short val = (Short)constable;
            return ConstImpl.of(val);
        }
        if (constable instanceof Character) {
            Character val = (Character)constable;
            return ConstImpl.of(val);
        }
        return ConstImpl.of(constable.describeConstable().orElseThrow(IllegalArgumentException::new));
    }

    public static ConstImpl of(ConstantDesc constantDesc) {
        Assert.checkNotNullParam((String)"constantDesc", (Object)constantDesc);
        if (constantDesc instanceof Integer) {
            Integer val = (Integer)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof Long) {
            Long val = (Long)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof Float) {
            Float val = (Float)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof Double) {
            Double val = (Double)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof String) {
            String val = (String)((Object)constantDesc);
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof ClassDesc) {
            ClassDesc val = (ClassDesc)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof MethodTypeDesc) {
            MethodTypeDesc val = (MethodTypeDesc)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof MethodHandleDesc) {
            MethodHandleDesc val = (MethodHandleDesc)constantDesc;
            return ConstImpl.of(val);
        }
        if (constantDesc instanceof DynamicConstantDesc) {
            DynamicConstantDesc dcd = (DynamicConstantDesc)constantDesc;
            return ConstImpl.of(dcd);
        }
        throw new IllegalStateException("Unknown constant desc " + String.valueOf(constantDesc));
    }

    public static ConstImpl of(DynamicConstantDesc<?> dcd) {
        if (dcd instanceof Enum.EnumDesc) {
            Enum.EnumDesc desc = (Enum.EnumDesc)dcd;
            return ConstImpl.of(desc);
        }
        if (dcd instanceof VarHandle.VarHandleDesc) {
            VarHandle.VarHandleDesc desc = (VarHandle.VarHandleDesc)dcd;
            return ConstImpl.of(desc);
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_ENUM_CONSTANT)) {
            return ConstImpl.of(Enum.EnumDesc.of(dcd.constantType(), dcd.constantName()));
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_NULL_CONSTANT)) {
            return ConstImpl.ofNull(dcd.constantType());
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_PRIMITIVE_CLASS)) {
            return ConstImpl.of(switch (dcd.constantName()) {
                case "byte" -> Byte.TYPE;
                case "char" -> Character.TYPE;
                case "short" -> Short.TYPE;
                case "int" -> Integer.TYPE;
                case "long" -> Long.TYPE;
                case "float" -> Float.TYPE;
                case "double" -> Double.TYPE;
                case "boolean" -> Boolean.TYPE;
                default -> throw new IllegalArgumentException("Invalid primitive type name \"" + dcd.constantName() + "\"");
            });
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_VARHANDLE_FIELD)) {
            List<ConstantDesc> args = dcd.bootstrapArgsList();
            return ConstImpl.ofFieldVarHandle(FieldDesc.of((ClassDesc)args.get(0), dcd.constantName(), (ClassDesc)args.get(1)));
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_INVOKE)) {
            return ConstImpl.ofInvoke((Const)ConstImpl.of(dcd.bootstrapMethod()), dcd.bootstrapArgsList().stream().map(Const::of).toList());
        }
        if (dcd.bootstrapMethod().equals(ConstantDescs.BSM_EXPLICIT_CAST) && dcd.constantName().equals("_")) {
            if (dcd.constantType().equals(ConstantDescs.CD_byte)) {
                return ConstImpl.of(((Integer)dcd.bootstrapArgs()[0]).byteValue());
            }
            if (dcd.constantType().equals(ConstantDescs.CD_short)) {
                return ConstImpl.of(((Integer)dcd.bootstrapArgs()[0]).shortValue());
            }
            if (dcd.constantType().equals(ConstantDescs.CD_char)) {
                return ConstImpl.of((char)((Integer)dcd.bootstrapArgs()[0]).intValue());
            }
            return new DynamicConst(dcd);
        }
        return new DynamicConst(dcd);
    }

    public static NullConst ofNull(ClassDesc type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Type is not a reference type: " + String.valueOf(type));
        }
        return new NullConst(type);
    }

    public static NullConst ofNull(Class<?> type) {
        return ConstImpl.ofNull(Util.classDesc(type));
    }

    public static ClassConst of(ClassDesc value) {
        return new ClassConst(value);
    }

    public static ClassConst of(Class<?> value) {
        return ConstImpl.of(Util.classDesc(value));
    }

    public static FieldVarHandleConst ofFieldVarHandle(FieldDesc desc) {
        return new FieldVarHandleConst(desc);
    }

    public static StaticFieldVarHandleConst ofStaticFieldVarHandle(FieldDesc desc) {
        return new StaticFieldVarHandleConst(desc);
    }

    public static StaticFinalFieldConst ofStaticFinalField(FieldDesc desc) {
        return new StaticFinalFieldConst(desc);
    }

    public static ArrayVarHandleConst ofArrayVarHandle(ClassDesc arrayType) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Array var handles can only be created for array types");
        }
        return new ArrayVarHandleConst(arrayType);
    }

    public static ConstImpl of(VarHandle.VarHandleDesc value) {
        List<ConstantDesc> args = value.bootstrapArgsList();
        return switch (value.bootstrapMethod().methodName()) {
            case "fieldVarHandle" -> ConstImpl.ofFieldVarHandle(FieldDesc.of((ClassDesc)args.get(0), value.constantName(), value.varType()));
            case "staticFieldVarHandle" -> ConstImpl.ofStaticFieldVarHandle(FieldDesc.of((ClassDesc)args.get(0), value.constantName(), value.varType()));
            case "getStaticFinal" -> {
                switch (args.size()) {
                    case 0: {
                        yield ConstImpl.ofStaticFinalField(FieldDesc.of(value.varType(), value.constantName(), value.varType()));
                    }
                    case 1: {
                        yield ConstImpl.ofStaticFinalField(FieldDesc.of((ClassDesc)args.get(0), value.constantName(), value.varType()));
                    }
                }
                throw new IllegalArgumentException("Unknown var handle type");
            }
            default -> throw new IllegalArgumentException("Unknown var handle type");
        };
    }

    public static EnumConst of(Enum.EnumDesc<?> value) {
        return new EnumConst(value);
    }

    public static ByteConst of(Byte value) {
        return new ByteConst(value);
    }

    public static ByteConst of(byte value) {
        return ConstImpl.of((Byte)value);
    }

    public static ShortConst of(Short value) {
        return new ShortConst(value);
    }

    public static ShortConst of(short value) {
        return ConstImpl.of((Short)value);
    }

    public static CharConst of(Character value) {
        return new CharConst(value);
    }

    public static CharConst of(char value) {
        return ConstImpl.of(Character.valueOf(value));
    }

    public static IntConst of(Integer value) {
        return new IntConst(value);
    }

    public static IntConst of(int value) {
        return ConstImpl.of((Integer)value);
    }

    public static LongConst of(Long value) {
        return new LongConst(value);
    }

    public static LongConst of(long value) {
        return ConstImpl.of((Long)value);
    }

    public static FloatConst of(Float value) {
        return ConstImpl.of(value.floatValue());
    }

    public static FloatConst of(float value) {
        return new FloatConst(value);
    }

    public static DoubleConst of(Double value) {
        return ConstImpl.of((double)value);
    }

    public static DoubleConst of(double value) {
        return new DoubleConst(value);
    }

    public static BooleanConst of(Boolean value) {
        return value != false ? BooleanConst.TRUE : BooleanConst.FALSE;
    }

    public static BooleanConst of(boolean value) {
        return value ? BooleanConst.TRUE : BooleanConst.FALSE;
    }

    public static VoidConst ofVoid() {
        return VoidConst.INSTANCE;
    }

    public static ConstImpl of(int value, TypeKind typeKind) {
        return switch (typeKind.asLoadable()) {
            case TypeKind.INT -> ConstImpl.of(value);
            case TypeKind.LONG -> ConstImpl.of((long)value);
            case TypeKind.FLOAT -> ConstImpl.of((float)value);
            case TypeKind.DOUBLE -> ConstImpl.of((double)value);
            default -> throw new IllegalArgumentException("Cannot cast integer constant to " + String.valueOf((Object)typeKind));
        };
    }

    public static ConstImpl of(long value, TypeKind typeKind) {
        return switch (typeKind.asLoadable()) {
            case TypeKind.INT -> ConstImpl.of((int)value);
            case TypeKind.LONG -> ConstImpl.of(value);
            case TypeKind.FLOAT -> ConstImpl.of((float)value);
            case TypeKind.DOUBLE -> ConstImpl.of((double)value);
            default -> throw new IllegalArgumentException("Cannot cast long constant to " + String.valueOf((Object)typeKind));
        };
    }

    public static ConstImpl of(float value, TypeKind typeKind) {
        return switch (typeKind.asLoadable()) {
            case TypeKind.INT -> ConstImpl.of((int)value);
            case TypeKind.LONG -> ConstImpl.of((long)value);
            case TypeKind.FLOAT -> ConstImpl.of(value);
            case TypeKind.DOUBLE -> ConstImpl.of((double)value);
            default -> throw new IllegalArgumentException("Cannot cast float constant to " + String.valueOf((Object)typeKind));
        };
    }

    public static ConstImpl of(double value, TypeKind typeKind) {
        return switch (typeKind.asLoadable()) {
            case TypeKind.INT -> ConstImpl.of((int)value);
            case TypeKind.LONG -> ConstImpl.of((long)value);
            case TypeKind.FLOAT -> ConstImpl.of((float)value);
            case TypeKind.DOUBLE -> ConstImpl.of(value);
            default -> throw new IllegalArgumentException("Cannot cast double constant to " + String.valueOf((Object)typeKind));
        };
    }

    public static InvokeConst ofInvoke(Const handle, List<Const> args) {
        return new InvokeConst((MethodHandleConst)handle, Util.reinterpretCast(args));
    }

    public static MethodHandleConst of(MethodHandleDesc desc) {
        return new MethodHandleConst(desc, null);
    }

    public static MethodHandleConst ofMethodHandle(InvokeKind kind, MethodDesc desc) {
        return new MethodHandleConst(kind, desc);
    }

    public static MethodHandleConst ofConstructorMethodHandle(ConstructorDesc desc) {
        return new MethodHandleConst(desc);
    }

    public static MethodHandleConst ofFieldSetterMethodHandle(FieldDesc desc) {
        return new MethodHandleConst(desc, false, false);
    }

    public static MethodHandleConst ofFieldGetterMethodHandle(FieldDesc desc) {
        return new MethodHandleConst(desc, false, true);
    }

    public static MethodHandleConst ofStaticFieldSetterMethodHandle(FieldDesc desc) {
        return new MethodHandleConst(desc, true, false);
    }

    public static MethodHandleConst ofStaticFieldGetterMethodHandle(FieldDesc desc) {
        return new MethodHandleConst(desc, true, true);
    }

    public static MethodTypeConst of(MethodTypeDesc desc) {
        return new MethodTypeConst(desc);
    }

    @Override
    public boolean bound() {
        return false;
    }

    public boolean isZero() {
        return false;
    }

    public boolean isNonZero() {
        return false;
    }

    public final boolean equals(Object obj) {
        ConstImpl other;
        return obj instanceof ConstImpl && this.equals(other = (ConstImpl)obj);
    }

    public abstract boolean equals(ConstImpl var1);

    public abstract int hashCode();

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.ldc(this.desc());
        smb.push(this.type());
        smb.wroteCode();
    }
}

