/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.StaticFieldCompareAndExchange;
import io.quarkus.gizmo2.impl.StaticFieldCompareAndSet;
import io.quarkus.gizmo2.impl.StaticFieldGetViaHandle;
import io.quarkus.gizmo2.impl.StaticFieldReadModifyWrite;
import io.quarkus.gizmo2.impl.StaticFieldSet;
import io.quarkus.gizmo2.impl.StaticFieldSetViaHandle;
import io.smallrye.classfile.CodeBuilder;

public final class StaticFieldVarImpl
extends AssignableImpl
implements StaticFieldVar {
    private final FieldDesc desc;

    public StaticFieldVarImpl(FieldDesc desc, GenericType genericType) {
        super(desc.type(), genericType);
        this.desc = desc;
    }

    @Override
    public FieldDesc desc() {
        return this.desc;
    }

    @Override
    public boolean bound() {
        return false;
    }

    @Override
    Item emitCompareAndExchange(BlockCreatorImpl block, Item expect, Item update, MemoryOrder order) {
        return new StaticFieldCompareAndExchange(this, expect, update, order);
    }

    @Override
    Item emitCompareAndSet(BlockCreatorImpl block, Item expect, Item update, boolean weak, MemoryOrder order) {
        return new StaticFieldCompareAndSet(this, expect, update, weak, order);
    }

    @Override
    Item emitReadModifyWrite(BlockCreatorImpl block, String op, Item newVal, MemoryOrder order) {
        return new StaticFieldReadModifyWrite(this, op, newVal, order);
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> this.asBound();
            default -> new StaticFieldGetViaHandle(this, mode);
        };
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> new StaticFieldSet(this, value);
            default -> new StaticFieldSetViaHandle(this, mode, value);
        };
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.getstatic(this.owner(), this.name(), this.type());
        smb.push(this.type());
        smb.wroteCode();
    }
}

