/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.PerfectHashSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.quarkus.gizmo2.impl.constant.EnumConst;
import io.smallrye.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public final class EnumOrdinalSwitchCreatorImpl
extends PerfectHashSwitchCreatorImpl<EnumConst> {
    final List<EnumConst> constants;

    EnumOrdinalSwitchCreatorImpl(BlockCreatorImpl enclosing, Expr switchVal, ClassDesc type, Class<? extends Enum<?>> enumClass) {
        super(enclosing, switchVal, type, EnumConst.class);
        this.constants = Stream.of(enumClass.getEnumConstants()).map(ConstImpl::of).map(EnumConst.class::cast).toList();
    }

    @Override
    int staticHash(EnumConst val) {
        int idx = this.constants.indexOf(val);
        if (idx == -1) {
            throw new NoSuchElementException("No known enum constant " + String.valueOf(val));
        }
        return idx;
    }

    @Override
    void hash(CodeBuilder cb) {
        cb.invokevirtual(ConstantDescs.CD_Enum, "ordinal", MethodTypeDesc.of(ConstantDescs.CD_int, new ClassDesc[0]));
    }
}

