/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.impl.TypeAnnotatableCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class GenericType {
    final List<Annotation> visible;
    final List<Annotation> invisible;
    OfArray arrayType;

    GenericType(List<Annotation> visible, List<Annotation> invisible) {
        this.visible = visible;
        this.invisible = invisible;
    }

    public static GenericType of(Class<?> type) {
        Class<?> enclosingClass = type.getEnclosingClass();
        if (enclosingClass != null) {
            if (Modifier.isStatic(type.getModifiers())) {
                return GenericType.of(Util.classDesc(type));
            }
            return GenericType.ofInnerClass(GenericType.ofClass(enclosingClass), type.getSimpleName());
        }
        return GenericType.of(Util.classDesc(type));
    }

    public static GenericType of(Class<?> type, List<TypeArgument> typeArguments) {
        int taSize;
        int tpCount = type.getTypeParameters().length;
        if (tpCount != (taSize = typeArguments.size()) && taSize != 0) {
            throw new IllegalArgumentException("Invalid number of type arguments (expected %d but got %d)".formatted(tpCount, taSize));
        }
        GenericType base = GenericType.of(type);
        if (base instanceof OfClass) {
            OfClass oc = (OfClass)base;
            return oc.withArguments(typeArguments);
        }
        if (typeArguments.isEmpty()) {
            return base;
        }
        throw new IllegalArgumentException("Invalid number of type arguments (expected 0 but got %d)".formatted(taSize));
    }

    public static OfClass ofClass(Class<?> type) {
        if (type.isPrimitive() || type.isArray()) {
            throw new IllegalArgumentException("Type %s does not represent a class or interface".formatted(type));
        }
        return (OfClass)GenericType.of(type);
    }

    public static OfClass ofClass(ClassDesc desc) {
        if (!desc.isClassOrInterface()) {
            throw new IllegalArgumentException("Type %s does not represent a class or interface".formatted(desc.displayName()));
        }
        return (OfClass)GenericType.of(desc);
    }

    public static OfClass ofClass(Class<?> type, List<TypeArgument> typeArguments) {
        return GenericType.ofClass(type).withArguments(typeArguments);
    }

    public static OfClass ofClass(Class<?> type, TypeArgument ... typeArguments) {
        return GenericType.ofClass(type, List.of(typeArguments));
    }

    public static OfClass ofClass(ClassDesc desc, List<TypeArgument> typeArguments) {
        return GenericType.ofClass(desc).withArguments(typeArguments);
    }

    public static OfClass ofClass(ClassDesc desc, TypeArgument ... typeArguments) {
        return GenericType.ofClass(desc, List.of(typeArguments));
    }

    public static OfArray ofArray(Class<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("Type %s does not represent an array type".formatted(type));
        }
        return (OfArray)GenericType.of(type);
    }

    public static OfArray ofArray(ClassDesc type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("Type %s does not represent an array type".formatted(type));
        }
        return (OfArray)GenericType.of(type);
    }

    public static OfPrimitive ofPrimitive(Class<?> type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Type %s does not represent a primitive type".formatted(type));
        }
        return (OfPrimitive)GenericType.of(type);
    }

    public static OfPrimitive ofPrimitive(ClassDesc type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Type %s does not represent a primitive type".formatted(type));
        }
        return (OfPrimitive)GenericType.of(type);
    }

    public static GenericType of(ClassDesc desc) {
        String descStr = desc.descriptorString();
        char ch = descStr.charAt(0);
        return switch (ch) {
            case 'L' -> {
                switch (descStr) {
                    case "Ljava/lang/Class;": {
                        yield OfRootClass.GT_Class;
                    }
                    case "Ljava/lang/Exception;": {
                        yield OfRootClass.GT_Exception;
                    }
                    case "Ljava/lang/Object;": {
                        yield OfRootClass.GT_Object;
                    }
                    case "Ljava/lang/String;": {
                        yield OfRootClass.GT_String;
                    }
                    case "Ljava/lang/Throwable;": {
                        yield OfRootClass.GT_Throwable;
                    }
                    case "Ljava/util/List;": {
                        yield OfRootClass.GT_List;
                    }
                    case "Ljava/util/Map;": {
                        yield OfRootClass.GT_Map;
                    }
                    case "Ljava/util/Set;": {
                        yield OfRootClass.GT_Set;
                    }
                    case "Ljava/lang/RuntimeException;": {
                        yield OfRootClass.GT_RuntimeException;
                    }
                    case "Ljava/lang/Thread;": {
                        yield OfRootClass.GT_Thread;
                    }
                    case "Ljava/lang/reflect/Type;": {
                        yield OfRootClass.GT_Type;
                    }
                    case "Ljava/util/ArrayList;": {
                        yield OfRootClass.GT_ArrayList;
                    }
                    case "Ljava/util/HashMap;": {
                        yield OfRootClass.GT_HashMap;
                    }
                    case "Ljava/util/HashSet;": {
                        yield OfRootClass.GT_HashSet;
                    }
                    case "Ljava/util/function/Supplier;": {
                        yield OfRootClass.GT_Supplier;
                    }
                }
                yield new OfRootClass(desc);
            }
            case 'Z' -> OfPrimitive.GT_boolean;
            case 'B' -> OfPrimitive.GT_byte;
            case 'C' -> OfPrimitive.GT_char;
            case 'D' -> OfPrimitive.GT_double;
            case 'F' -> OfPrimitive.GT_float;
            case 'I' -> OfPrimitive.GT_int;
            case 'J' -> OfPrimitive.GT_long;
            case 'S' -> OfPrimitive.GT_short;
            case 'V' -> OfPrimitive.GT_void;
            case '[' -> GenericType.of(desc.componentType()).arrayType();
            default -> throw Assert.impossibleSwitchCase((char)ch);
        };
    }

    public static GenericType of(ClassDesc desc, List<TypeArgument> typeArguments) {
        GenericType genericType = GenericType.of(desc);
        if (typeArguments.isEmpty()) {
            return genericType;
        }
        if (genericType instanceof OfClass) {
            OfClass oc = (OfClass)genericType;
            return oc.withArguments(typeArguments);
        }
        throw new IllegalArgumentException("Type %s cannot have type arguments".formatted(desc.displayName()));
    }

    public static OfTypeVariable ofTypeVariable(String name, Class<?> bound) {
        return GenericType.ofTypeVariable(name, Util.classDesc(bound));
    }

    public static OfTypeVariable ofTypeVariable(String name, ClassDesc bound) {
        return OfTypeVariable.getOrMake(name, bound);
    }

    public static OfTypeVariable ofTypeVariable(String name) {
        return GenericType.ofTypeVariable(name, ConstantDescs.CD_Object);
    }

    public static OfInnerClass ofInnerClass(OfClass outerClass, String name) {
        return new OfInnerClass(List.of(), List.of(), (OfClass)Assert.checkNotNullParam((String)"outerClass", (Object)outerClass), (String)Assert.checkNotNullParam((String)"name", (Object)name), List.of());
    }

    public GenericType withAnnotations(Consumer<AnnotatableCreator> builder) {
        TypeAnnotatableCreatorImpl tac = new TypeAnnotatableCreatorImpl(this.visible, this.invisible);
        builder.accept(tac);
        if (this.visible.equals(tac.visible()) && this.invisible.equals(tac.invisible())) {
            return this;
        }
        return this.copy(tac.visible(), tac.invisible());
    }

    public <A extends java.lang.annotation.Annotation> GenericType withAnnotation(Class<A> annotationType) {
        return this.withAnnotation(annotationType, ac -> {});
    }

    public <A extends java.lang.annotation.Annotation> GenericType withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
        return this.withAnnotations(ac -> ac.addAnnotation(annotationType, builder));
    }

    public abstract boolean isRaw();

    public boolean signatureNeeded() {
        return !this.isRaw();
    }

    public final boolean hasAnnotations(RetentionPolicy retention) {
        return switch (retention) {
            default -> throw new IncompatibleClassChangeError();
            case RetentionPolicy.RUNTIME -> this.hasVisibleAnnotations();
            case RetentionPolicy.CLASS -> this.hasInvisibleAnnotations();
            case RetentionPolicy.SOURCE -> false;
        };
    }

    public boolean hasVisibleAnnotations() {
        return !this.visible.isEmpty();
    }

    public boolean hasInvisibleAnnotations() {
        return !this.invisible.isEmpty();
    }

    public final boolean hasAnnotations() {
        return this.hasVisibleAnnotations() || this.hasInvisibleAnnotations();
    }

    public OfArray arrayType() {
        OfArray arrayType = this.arrayType;
        if (arrayType == null) {
            arrayType = this.arrayType = new OfArray(List.of(), List.of(), this);
        }
        return arrayType;
    }

    public abstract ClassDesc desc();

    public StringBuilder toString(StringBuilder b) {
        for (Annotation annotation : this.visible) {
            Util.appendAnnotation(b, annotation).append(' ');
        }
        for (Annotation annotation : this.invisible) {
            Util.appendAnnotation(b, annotation).append(' ');
        }
        return b;
    }

    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public final boolean equals(Object obj) {
        GenericType gt;
        return obj instanceof GenericType && this.equals(gt = (GenericType)obj);
    }

    public boolean equals(GenericType gt) {
        return this == gt || this.visible.equals(gt.visible) && this.invisible.equals(gt.invisible);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.visible, this.invisible);
    }

    abstract GenericType copy(List<Annotation> var1, List<Annotation> var2);

    List<TypeAnnotation> computeAnnotations(RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
        List<Annotation> annotations = switch (retention) {
            case RetentionPolicy.RUNTIME -> this.visible;
            case RetentionPolicy.CLASS -> this.invisible;
            default -> throw Assert.impossibleSwitchCase((Object)((Object)retention));
        };
        if (!annotations.isEmpty()) {
            List<TypeAnnotation.TypePathComponent> pathSnapshot = List.copyOf(path);
            for (Annotation annotation : annotations) {
                list.add(TypeAnnotation.of((TypeAnnotation.TargetInfo)targetInfo, pathSnapshot, (Annotation)annotation));
            }
        }
        return list;
    }

    public static abstract class OfClass
    extends OfThrows {
        final List<TypeArgument> typeArguments;

        OfClass(List<Annotation> visible, List<Annotation> invisible, List<TypeArgument> typeArguments) {
            super(visible, invisible);
            this.typeArguments = typeArguments;
        }

        public List<TypeArgument> typeArguments() {
            return this.typeArguments;
        }

        @Override
        public OfClass withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfClass)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfClass withAnnotation(Class<A> annotationType) {
            return (OfClass)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfClass withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfClass)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public boolean isRaw() {
            return this.typeArguments.isEmpty();
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return super.hasVisibleAnnotations() || this.typeArguments.stream().anyMatch(TypeArgument::hasVisibleAnnotations);
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return super.hasInvisibleAnnotations() || this.typeArguments.stream().anyMatch(TypeArgument::hasInvisibleAnnotations);
        }

        public OfClass withArguments(List<TypeArgument> newArguments) {
            if (this.typeArguments.equals(newArguments)) {
                return this;
            }
            int taSize = this.typeArguments.size();
            int naSize = newArguments.size();
            if (taSize == 0 || naSize == 0 || taSize == naSize) {
                return this.copy(this.visible, this.invisible, newArguments);
            }
            throw new IllegalArgumentException("Invalid number of type arguments (expected %d but got %d)".formatted(naSize, taSize));
        }

        @Override
        public final boolean equals(OfThrows other) {
            OfClass oc;
            return other instanceof OfClass && this.equals(oc = (OfClass)other);
        }

        public boolean equals(OfClass other) {
            return super.equals(other) && this.typeArguments.equals(other.typeArguments);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.typeArguments.hashCode();
        }

        abstract OfClass copy(List<Annotation> var1, List<Annotation> var2, List<TypeArgument> var3);

        @Override
        List<TypeAnnotation> computeAnnotations(RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
            super.computeAnnotations(retention, targetInfo, list, path);
            List<TypeArgument> typeArguments = this.typeArguments;
            int size = typeArguments.size();
            for (int i = 0; i < size; ++i) {
                path.addLast(TypeAnnotation.TypePathComponent.of((TypeAnnotation.TypePathComponent.Kind)TypeAnnotation.TypePathComponent.Kind.TYPE_ARGUMENT, (int)i));
                TypeArgument arg = typeArguments.get(i);
                if (arg instanceof TypeArgument.OfWildcard) {
                    TypeArgument.OfWildcard wld = (TypeArgument.OfWildcard)arg;
                    List<Annotation> argAnnotations = switch (retention) {
                        case RetentionPolicy.RUNTIME -> wld.visible();
                        case RetentionPolicy.CLASS -> wld.invisible();
                        default -> throw Assert.impossibleSwitchCase((Object)((Object)retention));
                    };
                    List<TypeAnnotation.TypePathComponent> pathSnapshot = List.copyOf(path);
                    for (Annotation annotation : argAnnotations) {
                        list.add(TypeAnnotation.of((TypeAnnotation.TargetInfo)targetInfo, pathSnapshot, (Annotation)annotation));
                    }
                    if (wld instanceof TypeArgument.OfBounded) {
                        TypeArgument.OfBounded bnd = (TypeArgument.OfBounded)((Object)wld);
                        path.addLast(TypeAnnotation.TypePathComponent.WILDCARD);
                        bnd.bound().computeAnnotations(retention, targetInfo, list, path);
                        path.removeLast();
                    }
                } else if (arg instanceof TypeArgument.OfExact) {
                    TypeArgument.OfExact exact = (TypeArgument.OfExact)arg;
                    exact.type().computeAnnotations(retention, targetInfo, list, path);
                } else {
                    throw Assert.unreachableCode();
                }
                path.removeLast();
            }
            return list;
        }

        StringBuilder typeArgumentsToString(StringBuilder b) {
            Iterator<TypeArgument> iter = this.typeArguments.iterator();
            if (iter.hasNext()) {
                b.append('<');
                iter.next().toString(b);
                while (iter.hasNext()) {
                    b.append(", ");
                    iter.next().toString(b);
                }
                b.append('>');
            }
            return b;
        }
    }

    public static final class OfInnerClass
    extends OfClass {
        private final OfClass outerType;
        private final String name;
        private ClassDesc desc;

        OfInnerClass(List<Annotation> visible, List<Annotation> invisible, OfClass outerType, String name, List<TypeArgument> typeArguments) {
            super(visible, invisible, typeArguments);
            this.outerType = outerType;
            this.name = name;
        }

        @Override
        public ClassDesc desc() {
            ClassDesc desc = this.desc;
            if (desc == null) {
                desc = this.desc = this.outerType.desc().nested(this.name);
            }
            return desc;
        }

        public OfClass outerType() {
            return this.outerType;
        }

        public String name() {
            return this.name;
        }

        @Override
        OfInnerClass copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfInnerClass(visible, invisible, this.outerType, this.name, this.typeArguments);
        }

        @Override
        OfInnerClass copy(List<Annotation> visible, List<Annotation> invisible, List<TypeArgument> typeArguments) {
            return new OfInnerClass(visible, invisible, this.outerType, this.name, typeArguments);
        }

        public OfInnerClass withOuterType(OfClass outerType) {
            return new OfInnerClass(this.visible, this.invisible, (OfClass)Assert.checkNotNullParam((String)"outerType", (Object)outerType), this.name, this.typeArguments);
        }

        @Override
        public OfInnerClass withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfInnerClass)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfInnerClass withAnnotation(Class<A> annotationType) {
            return (OfInnerClass)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfInnerClass withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfInnerClass)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public boolean isRaw() {
            return super.isRaw() && this.outerType.isRaw();
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return super.hasVisibleAnnotations() || this.outerType.hasVisibleAnnotations();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return super.hasInvisibleAnnotations() || this.outerType.hasInvisibleAnnotations();
        }

        @Override
        public boolean equals(OfClass other) {
            OfInnerClass oic;
            return other instanceof OfInnerClass && this.equals(oic = (OfInnerClass)other);
        }

        public boolean equals(OfInnerClass other) {
            return this == other || super.equals(other) && this.outerType.equals(other.outerType);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.outerType.hashCode();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return this.typeArgumentsToString(super.toString(this.outerType.toString(b).append('.')).append(this.name));
        }

        @Override
        List<TypeAnnotation> computeAnnotations(RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
            this.outerType.computeAnnotations(retention, targetInfo, list, path);
            path.addLast(TypeAnnotation.TypePathComponent.INNER_TYPE);
            super.computeAnnotations(retention, targetInfo, list, path);
            path.removeLast();
            return list;
        }
    }

    public static final class OfArray
    extends OfReference {
        private final GenericType componentType;
        private ClassDesc desc;

        OfArray(List<Annotation> visible, List<Annotation> invisible, GenericType componentType) {
            super(visible, invisible);
            this.componentType = componentType;
        }

        public GenericType componentType() {
            return this.componentType;
        }

        @Override
        List<TypeAnnotation> computeAnnotations(RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
            this.componentType.computeAnnotations(retention, targetInfo, list, path);
            path.addLast(TypeAnnotation.TypePathComponent.ARRAY);
            super.computeAnnotations(retention, targetInfo, list, path);
            path.removeLast();
            return list;
        }

        @Override
        OfArray copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfArray(visible, invisible, this.componentType);
        }

        @Override
        public OfArray withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfArray)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfArray withAnnotation(Class<A> annotationType) {
            return (OfArray)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfArray withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfArray)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public boolean isRaw() {
            return this.componentType.isRaw();
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return super.hasVisibleAnnotations() || this.componentType.hasVisibleAnnotations();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return super.hasInvisibleAnnotations() || this.componentType.hasInvisibleAnnotations();
        }

        @Override
        public ClassDesc desc() {
            ClassDesc desc = this.desc;
            if (desc == null) {
                desc = this.desc = this.componentType.desc().arrayType();
            }
            return desc;
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            GenericType element = this;
            while (element instanceof OfArray) {
                OfArray arr = element;
                element = arr.componentType;
            }
            ((GenericType)element).toString(b);
            this.appendComponent(b);
            return b;
        }

        private void appendComponent(StringBuilder b) {
            if (super.hasVisibleAnnotations() || super.hasInvisibleAnnotations()) {
                b.append(' ');
            }
            super.toString(b).append("[]");
            GenericType genericType = this.componentType;
            if (genericType instanceof OfArray) {
                OfArray arr = (OfArray)genericType;
                arr.appendComponent(b);
            }
        }

        @Override
        public boolean equals(OfReference other) {
            OfArray oa;
            return other instanceof OfArray && this.equals(oa = (OfArray)other);
        }

        public boolean equals(OfArray oa) {
            return this == oa || super.equals(oa) && this.componentType.equals(oa.componentType);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.componentType.hashCode();
        }
    }

    public static final class OfPrimitive
    extends GenericType {
        private static final OfPrimitive GT_boolean = new OfPrimitive(ConstantDescs.CD_boolean);
        private static final OfPrimitive GT_byte = new OfPrimitive(ConstantDescs.CD_byte);
        private static final OfPrimitive GT_char = new OfPrimitive(ConstantDescs.CD_char);
        private static final OfPrimitive GT_double = new OfPrimitive(ConstantDescs.CD_double);
        private static final OfPrimitive GT_float = new OfPrimitive(ConstantDescs.CD_float);
        private static final OfPrimitive GT_int = new OfPrimitive(ConstantDescs.CD_int);
        private static final OfPrimitive GT_long = new OfPrimitive(ConstantDescs.CD_long);
        private static final OfPrimitive GT_short = new OfPrimitive(ConstantDescs.CD_short);
        private static final OfPrimitive GT_void = new OfPrimitive(ConstantDescs.CD_void);
        private final ClassDesc type;

        private OfPrimitive(ClassDesc type) {
            super(List.of(), List.of());
            this.type = type;
        }

        private OfPrimitive(OfPrimitive orig, List<Annotation> visible, List<Annotation> invisible) {
            super(visible, invisible);
            this.type = orig.type;
        }

        @Override
        OfPrimitive copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfPrimitive(this, visible, invisible);
        }

        @Override
        public OfPrimitive withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfPrimitive)super.withAnnotations(builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfPrimitive withAnnotation(Class<A> annotationType) {
            return (OfPrimitive)super.withAnnotation(annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfPrimitive withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfPrimitive)super.withAnnotation(annotationType, builder);
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean equals(GenericType other) {
            OfPrimitive op;
            return other instanceof OfPrimitive && this.equals(op = (OfPrimitive)other);
        }

        public boolean equals(OfPrimitive other) {
            return this == other || super.equals(other) && this.type.equals(other.type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.type.hashCode();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.type.displayName());
        }

        @Override
        public ClassDesc desc() {
            return this.type;
        }
    }

    public static final class OfRootClass
    extends OfClass {
        private static final OfRootClass GT_Class = new OfRootClass(ConstantDescs.CD_Class);
        private static final OfRootClass GT_Exception = new OfRootClass(ConstantDescs.CD_Exception);
        private static final OfRootClass GT_List = new OfRootClass(ConstantDescs.CD_List);
        private static final OfRootClass GT_Map = new OfRootClass(ConstantDescs.CD_Map);
        private static final OfRootClass GT_Object = new OfRootClass(ConstantDescs.CD_Object);
        private static final OfRootClass GT_Set = new OfRootClass(ConstantDescs.CD_Set);
        private static final OfRootClass GT_String = new OfRootClass(ConstantDescs.CD_String);
        private static final OfRootClass GT_Throwable = new OfRootClass(ConstantDescs.CD_Throwable);
        private static final OfRootClass GT_ArrayList = new OfRootClass(Util.classDesc(ArrayList.class));
        private static final OfRootClass GT_HashMap = new OfRootClass(Util.classDesc(HashMap.class));
        private static final OfRootClass GT_HashSet = new OfRootClass(Util.classDesc(HashSet.class));
        private static final OfRootClass GT_RuntimeException = new OfRootClass(Util.classDesc(RuntimeException.class));
        private static final OfRootClass GT_Supplier = new OfRootClass(Util.classDesc(Supplier.class));
        private static final OfRootClass GT_Thread = new OfRootClass(Util.classDesc(Thread.class));
        private static final OfRootClass GT_Type = new OfRootClass(Util.classDesc(Type.class));
        private final ClassDesc desc;

        OfRootClass(ClassDesc desc) {
            this(List.of(), List.of(), desc, List.of());
        }

        OfRootClass(List<Annotation> visible, List<Annotation> invisible, ClassDesc desc, List<TypeArgument> typeArguments) {
            super(visible, invisible, typeArguments);
            this.desc = desc;
        }

        @Override
        public OfRootClass withArguments(List<TypeArgument> newArguments) {
            if (this.typeArguments.equals(newArguments)) {
                return this;
            }
            return (OfRootClass)super.withArguments(newArguments);
        }

        @Override
        public ClassDesc desc() {
            return this.desc;
        }

        @Override
        OfRootClass copy(List<Annotation> visible, List<Annotation> invisible, List<TypeArgument> typeArguments) {
            return new OfRootClass(visible, invisible, this.desc, typeArguments);
        }

        @Override
        OfRootClass copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfRootClass(visible, invisible, this.desc, this.typeArguments);
        }

        @Override
        public OfRootClass withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfRootClass)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfRootClass withAnnotation(Class<A> annotationType) {
            return (OfRootClass)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfRootClass withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfRootClass)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public boolean equals(OfClass other) {
            OfRootClass orc;
            return other instanceof OfRootClass && this.equals(orc = (OfRootClass)other);
        }

        public boolean equals(OfRootClass other) {
            return this == other || super.equals(other) && this.desc.descriptorString().equals(other.desc.descriptorString());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.desc.descriptorString().hashCode();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            String pkgName = this.desc.packageName();
            if (!pkgName.isEmpty()) {
                b.append(pkgName).append('.');
            }
            return this.typeArgumentsToString(super.toString(b).append(this.desc.displayName()));
        }
    }

    public static final class OfTypeVariable
    extends OfThrows {
        private static final VarHandle cacheHandle = ConstantBootstraps.arrayVarHandle(MethodHandles.lookup(), "_", VarHandle.class, OfTypeVariable[].class);
        private static final OfTypeVariable[] cache = new OfTypeVariable[26];
        private final String name;
        private final ClassDesc desc;

        OfTypeVariable(List<Annotation> visible, List<Annotation> invisible, String name, ClassDesc desc) {
            super(visible, invisible);
            this.name = name;
            this.desc = desc;
        }

        static OfTypeVariable getOrMake(String name, ClassDesc desc) {
            char c;
            if (name.length() == 1 && desc.equals(ConstantDescs.CD_Object) && 'A' <= (c = name.charAt(0)) && c <= 'Z') {
                OfTypeVariable witness;
                OfTypeVariable type = cacheHandle.getVolatile(cache, c - 65);
                if (type == null && (witness = cacheHandle.compareAndExchange(cache, c - 65, null, type = new OfTypeVariable(List.of(), List.of(), name, ConstantDescs.CD_Object))) != null) {
                    type = witness;
                }
                return type;
            }
            return new OfTypeVariable(List.of(), List.of(), name, desc);
        }

        @Override
        public ClassDesc desc() {
            return this.desc;
        }

        public String name() {
            return this.name;
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.name);
        }

        @Override
        public OfTypeVariable withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfTypeVariable)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfTypeVariable withAnnotation(Class<A> annotationType) {
            return (OfTypeVariable)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfTypeVariable withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfTypeVariable)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public boolean isRaw() {
            return false;
        }

        @Override
        OfTypeVariable copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfTypeVariable(visible, invisible, this.name, this.desc);
        }

        @Override
        public boolean equals(OfThrows other) {
            OfTypeVariable tv;
            return other instanceof OfTypeVariable && this.equals(tv = (OfTypeVariable)other);
        }

        public boolean equals(OfTypeVariable tvt) {
            return this == tvt || super.equals(tvt) && this.name.equals(tvt.name) && this.desc.equals(tvt.desc);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + Objects.hash(this.name, this.desc);
        }
    }

    public static abstract class OfThrows
    extends OfReference {
        OfThrows(List<Annotation> visible, List<Annotation> invisible) {
            super(visible, invisible);
        }

        @Override
        public OfThrows withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfThrows)super.withAnnotations((Consumer)builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfThrows withAnnotation(Class<A> annotationType) {
            return (OfThrows)super.withAnnotation((Class)annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfThrows withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfThrows)super.withAnnotation((Class)annotationType, (Consumer)builder);
        }

        @Override
        public final boolean equals(OfReference other) {
            OfThrows ot;
            return other instanceof OfThrows && this.equals(ot = (OfThrows)other);
        }

        public boolean equals(OfThrows other) {
            return super.equals(other);
        }
    }

    public static abstract class OfReference
    extends GenericType {
        TypeArgument.OfExact exactArg;
        TypeArgument.OfExtends extendsArg;
        TypeArgument.OfSuper superArg;

        OfReference(List<Annotation> visible, List<Annotation> invisible) {
            super(visible, invisible);
        }

        @Override
        public OfReference withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfReference)super.withAnnotations(builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfReference withAnnotation(Class<A> annotationType) {
            return (OfReference)super.withAnnotation(annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfReference withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfReference)super.withAnnotation(annotationType, builder);
        }

        @Override
        public final boolean equals(GenericType gt) {
            OfReference or;
            return gt instanceof OfReference && this.equals(or = (OfReference)gt);
        }

        public boolean equals(OfReference other) {
            return super.equals(other);
        }
    }
}

