/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.StaticFieldVarImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class StaticFieldSetViaHandle
extends Item {
    private final StaticFieldVarImpl staticFieldVar;
    private final MemoryOrder mode;
    private final Item value;

    StaticFieldSetViaHandle(StaticFieldVarImpl staticFieldVar, MemoryOrder mode, Item value) {
        this.staticFieldVar = staticFieldVar;
        this.mode = mode;
        this.value = value;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.value.process(itr, op);
        ConstImpl.ofStaticFieldVarHandle(this.staticFieldVar.desc()).process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "set";
            case MemoryOrder.Opaque -> "setOpaque";
            case MemoryOrder.Release -> "setRelease";
            case MemoryOrder.Volatile -> "setVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(ConstantDescs.CD_void, this.staticFieldVar.desc().type()));
        smb.pop();
        smb.pop();
        smb.wroteCode();
    }
}

