/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MethodDescImpl
implements MethodDesc {
    private final ClassDesc owner;
    private final String name;
    private final MethodTypeDesc type;
    private final int hashCode;

    MethodDescImpl(ClassDesc owner, String name, MethodTypeDesc type) {
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.hashCode = this.buildHashCode();
    }

    @Override
    public ClassDesc owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MethodTypeDesc type() {
        return this.type;
    }

    @Override
    public ClassDesc returnType() {
        return this.type.returnType();
    }

    @Override
    public GenericType genericReturnType() {
        return GenericType.of(this.type().returnType());
    }

    @Override
    public boolean hasGenericReturnType() {
        return false;
    }

    public boolean equals(Object obj) {
        MethodDescImpl other;
        return obj instanceof MethodDescImpl && this.equals(other = (MethodDescImpl)obj);
    }

    public boolean equals(MethodDescImpl other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.name.equals(other.name) && Util.equals(this.owner, other.owner) && this.type.equals(other.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private int buildHashCode() {
        int result = Objects.hashCode(this.owner.descriptorString());
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + this.typeHash();
        return result;
    }

    private int typeHash() {
        int result = this.type.returnType().descriptorString().hashCode();
        int pc = this.type.parameterCount();
        for (int i = 0; i < pc; ++i) {
            result = 31 * result + this.type.parameterType(i).descriptorString().hashCode();
        }
        return result;
    }
}

