/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.FieldDeref;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class FieldGetViaHandle
extends Item {
    private final FieldDeref fieldDeref;
    private final MemoryOrder mode;

    FieldGetViaHandle(FieldDeref fieldDeref, MemoryOrder mode) {
        this.fieldDeref = fieldDeref;
        this.mode = mode;
    }

    @Override
    protected void computeType() {
        this.initType(this.fieldDeref.type());
        if (this.fieldDeref.hasGenericType()) {
            this.initGenericType(this.fieldDeref.genericType());
        }
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.fieldDeref.instance().process(itr, op);
        ConstImpl.ofFieldVarHandle(this.fieldDeref.desc()).process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Plain -> "get";
            case MemoryOrder.Opaque -> "getOpaque";
            case MemoryOrder.Acquire -> "getAcquire";
            case MemoryOrder.Volatile -> "getVolatile";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, MethodTypeDesc.of(this.type(), this.fieldDeref.instance().type()));
        smb.pop();
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }
}

