/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Objects;

public final class FieldDescImpl
implements FieldDesc {
    private final ClassDesc owner;
    private final String name;
    private final ClassDesc type;
    private final int hashCode;

    public FieldDescImpl(ClassDesc owner, String name, ClassDesc type) {
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.hashCode = Objects.hash(owner.descriptorString(), name, type.descriptorString());
    }

    @Override
    public ClassDesc owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ClassDesc type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        FieldDescImpl other;
        return obj instanceof FieldDescImpl && this.equals(other = (FieldDescImpl)obj);
    }

    public boolean equals(FieldDescImpl other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.name.equals(other.name) && Util.equals(this.owner, other.owner) && Util.equals(this.type, other.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return Util.descName(Util.descName(b, this.owner).append('#').append(this.name).append(':'), this.type);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

