/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodSignature;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.attribute.ExceptionsAttribute;
import io.github.dmlloyd.classfile.attribute.MethodParameterInfo;
import io.github.dmlloyd.classfile.attribute.MethodParametersAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.SignatureAttribute;
import io.github.dmlloyd.classfile.attribute.StackMapFrameInfo;
import io.github.dmlloyd.classfile.attribute.StackMapTableAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.instruction.LocalVariable;
import io.github.dmlloyd.classfile.instruction.LocalVariableType;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.GenericTypes;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.ExecutableCreator;
import io.quarkus.gizmo2.creator.ParamCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.ConstructorCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.ModifiableCreatorImpl;
import io.quarkus.gizmo2.impl.ParamCreatorImpl;
import io.quarkus.gizmo2.impl.ParamVarImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ExecutableCreatorImpl
extends ModifiableCreatorImpl
implements ExecutableCreator {
    private static final MethodParameterInfo EMPTY_PI = MethodParameterInfo.of(Optional.empty(), (int)0);
    static final int ST_INITIAL = 0;
    static final int ST_BODY = 1;
    static final int ST_POST_BODY = 2;
    static final int ST_DONE = 3;
    final BitSet locals = new BitSet();
    final TypeCreatorImpl typeCreator;
    private List<TypeParameter> typeParameters = List.of();
    ClassDesc returnType;
    GenericType genericReturnType;
    boolean typeEstablished;
    MethodTypeDesc type = null;
    List<ParamVarImpl> params = List.of();
    int state = 0;
    List<GenericType.OfThrows> throws_ = List.of();

    ExecutableCreatorImpl(TypeCreatorImpl typeCreator) {
        super(typeCreator.gizmo);
        this.typeCreator = typeCreator;
    }

    @Override
    public MethodTypeDesc type() {
        MethodTypeDesc type = this.type;
        if (type == null) {
            type = this.type = this.computeType();
        }
        return type;
    }

    @Override
    public void setType(MethodTypeDesc desc) {
        if (this.state >= 1) {
            throw new IllegalStateException("Type may no longer be changed");
        }
        if (this.typeEstablished) {
            MethodTypeDesc type = this.type();
            if (!desc.equals(type)) {
                throw new IllegalArgumentException("Type " + String.valueOf(desc) + " does not match established type " + String.valueOf(type));
            }
        } else {
            int descParamCnt;
            MethodTypeDesc existing = this.type;
            if (desc.equals(existing)) {
                return;
            }
            GenericType genericReturnType = this.genericReturnType;
            ClassDesc returnType = this.returnType;
            if (!(genericReturnType == null && returnType == null || Util.equals(this.returnType(), desc.returnType()))) {
                throw new IllegalArgumentException("Type " + String.valueOf(desc) + " has a return type that does not match established return type " + String.valueOf(this.returnType()));
            }
            int paramCnt = this.params.size();
            if (paramCnt > (descParamCnt = desc.parameterCount())) {
                throw new IllegalArgumentException("Existing parameter count (" + paramCnt + ") is greater than the number of parameters in " + String.valueOf(desc));
            }
            List<ParamVarImpl> params = this.params;
            for (int i = 0; i < paramCnt; ++i) {
                ParamVarImpl param = params.get(i);
                if (param == null || Util.equals(param.type(), desc.parameterType(i))) continue;
                throw new IllegalArgumentException("Defined parameter " + i + " has a type of " + String.valueOf(param.type()) + " which conflicts with " + String.valueOf(desc));
            }
            this.clearType();
            this.type = desc;
            if (params.size() != descParamCnt) {
                if (params instanceof ArrayList) {
                    ArrayList al = (ArrayList)params;
                    al.ensureCapacity(descParamCnt);
                } else {
                    this.params = new ArrayList<ParamVarImpl>(descParamCnt);
                    this.params.addAll(params);
                }
            }
            this.typeEstablished = true;
        }
    }

    MethodTypeDesc computeType() {
        assert (this.type == null);
        return MethodTypeDesc.of(this.returnType(), (ClassDesc[])this.params.stream().map(Item::type).toArray(ClassDesc[]::new));
    }

    @Override
    public GenericType genericReturnType() {
        GenericType genericReturnType = this.genericReturnType;
        if (genericReturnType != null) {
            return genericReturnType;
        }
        ClassDesc returnType = this.returnType;
        if (returnType != null) {
            this.genericReturnType = GenericType.of(returnType);
            return this.genericReturnType;
        }
        MethodTypeDesc type = this.type;
        if (type != null) {
            this.genericReturnType = GenericType.of(type.returnType());
            return this.genericReturnType;
        }
        return GenericTypes.GT_void;
    }

    @Override
    public boolean hasGenericReturnType() {
        return this.genericReturnType != null;
    }

    @Override
    public ClassDesc returnType() {
        ClassDesc returnType = this.returnType;
        if (returnType != null) {
            return returnType;
        }
        MethodTypeDesc type = this.type;
        if (type != null) {
            this.returnType = type.returnType();
            return this.returnType;
        }
        GenericType genericReturnType = this.genericReturnType;
        if (genericReturnType != null) {
            this.returnType = genericReturnType.desc();
            return this.returnType;
        }
        return ConstantDescs.CD_void;
    }

    void returning(GenericType type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        if (this.state >= 1) {
            throw new IllegalStateException("Return type may no longer be changed");
        }
        GenericType genericReturnType = this.genericReturnType;
        if (genericReturnType != null && !genericReturnType.equals(type)) {
            throw new IllegalArgumentException("Generic return type " + String.valueOf(type) + " does not match previously set generic return type " + String.valueOf(genericReturnType));
        }
        if (this.typeEstablished) {
            if (!Util.equals(type.desc(), this.type.returnType())) {
                throw new IllegalArgumentException("Return type " + String.valueOf(type) + " does not match established return type " + String.valueOf(this.type.returnType()));
            }
        } else {
            this.genericReturnType = type;
        }
    }

    void returning(ClassDesc type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        if (this.state >= 1) {
            throw new IllegalStateException("Return type may no longer be changed");
        }
        GenericType genericReturnType = this.genericReturnType;
        ClassDesc returnType = this.returnType;
        if (returnType == null && genericReturnType != null) {
            assert (!this.typeEstablished);
            if (!Util.equals(type, genericReturnType.desc())) {
                throw new IllegalArgumentException("Return type " + String.valueOf(type) + " does not match established return type " + String.valueOf(genericReturnType));
            }
        } else if (returnType != null && !Util.equals(returnType, type) || genericReturnType != null && !genericReturnType.desc().equals(type)) {
            throw new IllegalArgumentException("Return type " + String.valueOf(type) + " does not match established return type " + String.valueOf(returnType));
        }
        this.returnType = type;
    }

    void doBody(Consumer<BlockCreator> builder, MethodBuilder mb) {
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        if (this.signatureNeeded()) {
            mb.with((ClassFileElement)SignatureAttribute.of((MethodSignature)this.computeSignature()));
        }
        mb.withFlags(this.modifiers);
        this.addVisible((Consumer<? super RuntimeVisibleAnnotationsAttribute>)mb);
        this.addInvisible((Consumer<? super RuntimeInvisibleAnnotationsAttribute>)mb);
        List<GenericType.OfThrows> throws_ = this.throws_;
        ArrayDeque<TypeAnnotation.TypePathComponent> pathStack = new ArrayDeque<TypeAnnotation.TypePathComponent>();
        if (!throws_.isEmpty()) {
            int i;
            ArrayList<ClassEntry> exceptions = new ArrayList<ClassEntry>(throws_.size());
            for (i = 0; i < throws_.size(); ++i) {
                exceptions.add(this.typeCreator.zb.constantPool().classEntry(throws_.get(i).desc()));
            }
            mb.with((ClassFileElement)ExceptionsAttribute.of(exceptions));
            for (i = 0; i < throws_.size(); ++i) {
                GenericType.OfThrows genericType = throws_.get(i);
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofThrows((int)i), visible, pathStack);
                assert (pathStack.isEmpty());
                Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofThrows((int)i), invisible, pathStack);
                assert (pathStack.isEmpty());
            }
        }
        if (!this.params.isEmpty()) {
            ArrayList<MethodParameterInfo> parameters = new ArrayList<MethodParameterInfo>(this.params.size());
            ArrayList parametersVisibleAnnotations = new ArrayList(this.params.size());
            ArrayList parametersInvisibleAnnotations = new ArrayList(this.params.size());
            boolean hasVisibleAnnotations = false;
            boolean hasInvisibleAnnotations = false;
            for (int i = 0; i < this.params.size(); ++i) {
                ParamVarImpl currentParam = this.params.get(i);
                if (currentParam != null) {
                    parameters.add(i, MethodParameterInfo.ofParameter(Optional.of(currentParam.name()), (int)currentParam.flags()));
                    parametersVisibleAnnotations.add(i, currentParam.visible);
                    hasVisibleAnnotations = hasVisibleAnnotations || !currentParam.visible.isEmpty();
                    parametersInvisibleAnnotations.add(i, currentParam.invisible);
                    boolean bl = hasInvisibleAnnotations = hasInvisibleAnnotations || !currentParam.invisible.isEmpty();
                    if (!currentParam.hasGenericType()) continue;
                    GenericType genericType = currentParam.genericType();
                    Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodFormalParameter((int)i), visible, pathStack);
                    assert (pathStack.isEmpty());
                    Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodFormalParameter((int)i), invisible, pathStack);
                    assert (pathStack.isEmpty());
                    continue;
                }
                parameters.add(i, EMPTY_PI);
                parametersVisibleAnnotations.add(i, List.of());
                parametersInvisibleAnnotations.add(i, List.of());
            }
            if (this.typeCreator.gizmo.parameters()) {
                mb.with((ClassFileElement)MethodParametersAttribute.of(parameters));
            }
            if (hasVisibleAnnotations) {
                mb.with((ClassFileElement)RuntimeVisibleParameterAnnotationsAttribute.of(parametersVisibleAnnotations));
            }
            if (hasInvisibleAnnotations) {
                mb.with((ClassFileElement)RuntimeInvisibleParameterAnnotationsAttribute.of(parametersInvisibleAnnotations));
            }
        }
        if (this.hasGenericReturnType()) {
            Util.computeAnnotations(this.genericReturnType(), RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReturn(), visible, pathStack);
            Util.computeAnnotations(this.genericReturnType(), RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReturn(), invisible, pathStack);
        }
        for (int i = 0; i < this.typeParameters.size(); ++i) {
            TypeParameter tv = this.typeParameters.get(i);
            Util.computeAnnotations(tv, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.METHOD_TYPE_PARAMETER, (int)i), visible, pathStack);
            assert (pathStack.isEmpty());
            Util.computeAnnotations(tv, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.METHOD_TYPE_PARAMETER, (int)i), invisible, pathStack);
            assert (pathStack.isEmpty());
        }
        if (builder != null) {
            mb.withCode(cb -> {
                StackMapBuilder smb = new StackMapBuilder();
                if ((this.modifiers & 8) == 0) {
                    if (this instanceof ConstructorCreatorImpl) {
                        smb.store(0, (StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.UNINITIALIZED_THIS);
                    } else {
                        smb.store(0, this.typeCreator.type());
                    }
                }
                for (ParamVarImpl param : this.params) {
                    smb.store(param.slot(), param.type());
                }
                this.doCode(builder, (CodeBuilder)cb, smb);
                List<StackMapFrameInfo> infos = smb.frameInfos();
                if (!infos.isEmpty()) {
                    cb.with((ClassFileElement)StackMapTableAttribute.of(infos));
                }
            });
        }
        if (!visible.isEmpty()) {
            mb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            mb.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(invisible));
        }
    }

    boolean signatureNeeded() {
        return !this.typeParameters.isEmpty() || this.throws_.stream().anyMatch(GenericType::signatureNeeded) || this.hasGenericReturnType() && this.genericReturnType().signatureNeeded() || this.params.stream().filter(Item::hasGenericType).map(Item::genericType).anyMatch(GenericType::signatureNeeded);
    }

    MethodSignature computeSignature() {
        return MethodSignature.of(this.typeParameters.stream().map(Util::typeParamOf).toList(), this.throws_.stream().map(Util::signatureOf).map(Signature.ThrowableSig.class::cast).toList(), (Signature)Util.signatureOf(this.genericReturnType()), (Signature[])((Signature[])this.params.stream().map(Item::genericType).map(Util::signatureOf).toArray(Signature[]::new)));
    }

    void doCode(Consumer<BlockCreator> builder, CodeBuilder cb, StackMapBuilder smb) {
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        BlockCreatorImpl bc = new BlockCreatorImpl(this.typeCreator, cb, this.returnType(), this instanceof ConstructorCreator ? "new" : this.name());
        ArrayDeque<TypeAnnotation.TypePathComponent> pathStack = new ArrayDeque<TypeAnnotation.TypePathComponent>();
        if ((this.modifiers & 8) == 0) {
            cb.with((ClassFileElement)LocalVariable.of((int)0, (String)"this", (ClassDesc)this.typeCreator.type(), (Label)bc.startLabel(), (Label)bc.endLabel()));
            if (this.typeCreator.hasGenericType()) {
                GenericType.OfClass genericType = this.typeCreator.genericType();
                if (!genericType.isRaw()) {
                    cb.with((ClassFileElement)LocalVariableType.of((int)0, (String)"this", (Signature)Util.signatureOf(genericType), (Label)bc.startLabel(), (Label)bc.endLabel()));
                }
                if (genericType.hasVisibleAnnotations()) {
                    Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)0))), visible, pathStack);
                    assert (pathStack.isEmpty());
                    Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReceiver(), visible, pathStack);
                    assert (pathStack.isEmpty());
                }
                if (genericType.hasInvisibleAnnotations()) {
                    Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)0))), invisible, pathStack);
                    assert (pathStack.isEmpty());
                    Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReceiver(), invisible, pathStack);
                    assert (pathStack.isEmpty());
                }
            }
        }
        for (ParamVarImpl param : this.params) {
            if (param == null) continue;
            cb.with((ClassFileElement)LocalVariable.of((int)param.slot(), (String)param.name(), (ClassDesc)param.type(), (Label)bc.startLabel(), (Label)bc.endLabel()));
            if (!param.hasGenericType()) continue;
            GenericType genericType = param.genericType();
            if (!genericType.isRaw()) {
                cb.with((ClassFileElement)LocalVariableType.of((int)param.slot(), (String)param.name(), (Signature)Util.signatureOf(genericType), (Label)bc.startLabel(), (Label)bc.endLabel()));
            }
            if (genericType.hasVisibleAnnotations()) {
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)param.slot()))), visible, pathStack);
                assert (pathStack.isEmpty());
            }
            if (!genericType.hasInvisibleAnnotations()) continue;
            Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)param.slot()))), invisible, pathStack);
            assert (pathStack.isEmpty());
        }
        bc.accept(builder);
        bc.writeCode(cb, bc, smb);
        if (bc.mayFallThrough()) {
            if (this.creationSite == null) {
                throw new IllegalStateException("Outermost block of an executable member must not fall out (return or throw instead)\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("Outermost block of an executable member created at " + this.creationSite + " must not fall out (return or throw instead)");
        }
        bc.writeAnnotations(RetentionPolicy.RUNTIME, visible);
        bc.writeAnnotations(RetentionPolicy.CLASS, invisible);
        if (!visible.isEmpty()) {
            cb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            cb.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(invisible));
        }
    }

    abstract String name();

    void body(Consumer<BlockCreator> builder) {
        if (this.state >= 1) {
            throw new IllegalStateException("Body established twice");
        }
        this.state = 1;
        try {
            this.typeCreator.zb.withMethod(this.name(), this.type(), this.modifiers, mb -> this.doBody(builder, (MethodBuilder)mb));
        }
        finally {
            this.state = 2;
        }
    }

    @Override
    public ParamVar parameter(String name, Consumer<ParamCreator> builder) {
        return this.parameter(name, this.params.size(), builder);
    }

    @Override
    public ParamVar parameter(String name, int position, Consumer<ParamCreator> builder) {
        ParamCreatorImpl pc;
        int slot;
        if (this.state >= 1) {
            throw new IllegalStateException("Parameters may no longer be established");
        }
        MethodTypeDesc type = this.type;
        if (type != null && !this.typeEstablished) {
            this.clearType();
            type = null;
        }
        if (type == null) {
            int size = this.params.size();
            if (position != size) {
                throw new IllegalStateException("The method type was not established upfront and so parameters must be declared in order: expected parameter " + size + ", but got " + position);
            }
            if (size == 0) {
                slot = this.firstSlot();
            } else {
                ParamVarImpl last = this.params.get(size - 1);
                slot = last.slot() + last.slotSize();
            }
            pc = new ParamCreatorImpl(this.typeCreator.gizmo);
        } else {
            if (position < 0 || position >= type.parameterCount()) {
                throw new IndexOutOfBoundsException("Parameter position " + position + " is out of bounds for type " + String.valueOf(type));
            }
            if (position < this.params.size()) {
                throw new IllegalStateException("Parameter already defined at position " + position);
            }
            pc = new ParamCreatorImpl(this.typeCreator.gizmo, type.parameterType(position));
            slot = this.firstSlot() + IntStream.range(0, position).mapToObj(type::parameterType).map(TypeKind::from).mapToInt(TypeKind::slotSize).sum();
        }
        ParamVarImpl pv = pc.apply(builder, name, position, slot);
        List<ParamVarImpl> list = this.params;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(pv);
        } else {
            this.params = Util.listWith(this.params, pv);
        }
        this.locals.set(slot);
        if (TypeKind.from((TypeDescriptor.OfField)pv.type()).slotSize() == 2) {
            this.locals.set(slot + 1);
        }
        return pv;
    }

    @Override
    public void throws_(GenericType.OfThrows throwableType) {
        Assert.checkNotNullParam((String)"throwableType", (Object)throwableType);
        if (this.state >= 1) {
            throw new IllegalStateException("Exception throws may no longer be established");
        }
        List<GenericType.OfThrows> list = this.throws_;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(throwableType);
        } else {
            this.throws_ = Util.listWith(this.throws_, throwableType);
        }
    }

    void clearType() {
        this.type = null;
    }

    int firstSlot() {
        return 1;
    }

    public ClassDesc owner() {
        return this.typeCreator.type();
    }

    <T extends TypeParameter> T addTypeParameter(T var) {
        List<TypeParameter> list = this.typeParameters;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(var);
        } else {
            this.typeParameters = Util.listWith(this.typeParameters, var);
        }
        return var;
    }

    public This this_() {
        return this.typeCreator.this_();
    }
}

