/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.Subclass;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescs;
import io.quarkus.arc.processor.Grouping;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.FieldVar;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.LambdaCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class SubclassGenerator
extends AbstractGenerator {
    private static final DotName JAVA_LANG_THROWABLE = DotNames.create(Throwable.class);
    private static final DotName JAVA_LANG_EXCEPTION = DotNames.create(Exception.class);
    private static final DotName JAVA_LANG_RUNTIME_EXCEPTION = DotNames.create(RuntimeException.class);
    static final String SUBCLASS_SUFFIX = "_Subclass";
    static final String MARK_CONSTRUCTED_METHOD_NAME = "arc$markConstructed";
    static final String DESTROY_METHOD_NAME = "arc$destroy";
    protected static final String FIELD_NAME_PREDESTROYS = "arc$preDestroys";
    protected static final String FIELD_NAME_CONSTRUCTED = "arc$constructed";
    private final Predicate<DotName> applicationClassPredicate;
    private final Set<String> existingClasses;
    private final BeanProcessor.PrivateMembersCollector privateMembers;
    private final AnnotationLiteralProcessor annotationLiterals;

    static String generatedName(DotName providerTypeName, String baseName) {
        return SubclassGenerator.generatedNameFromTarget(DotNames.packagePrefix(providerTypeName), baseName, SUBCLASS_SUFFIX);
    }

    SubclassGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, BeanProcessor.PrivateMembersCollector privateMembers) {
        super(generateSources, reflectionRegistration);
        this.applicationClassPredicate = applicationClassPredicate;
        this.annotationLiterals = annotationLiterals;
        this.existingClasses = existingClasses;
        this.privateMembers = privateMembers;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName) {
        Type providerType = bean.getProviderType();
        String baseName = this.getBeanBaseName(beanClassName);
        String generatedName = SubclassGenerator.generatedName(providerType.name(), baseName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(bean.getBeanClass()) || bean.hasBoundDecoratorMatching(this.applicationClassPredicate);
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.SUBCLASS : null, this.generateSources);
        Gizmo gizmo = SubclassGenerator.gizmo(classOutput);
        this.createSubclass(gizmo, bean, generatedName, providerType);
        return classOutput.getResources();
    }

    private void createSubclass(Gizmo gizmo, BeanInfo bean, String generatedName, Type providerType) {
        CodeGenInfo codeGenInfo = this.preprocess(bean);
        BeanInfo.InterceptionInfo preDestroyInterception = bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY);
        gizmo.class_(generatedName, cc -> {
            cc.extends_(Jandex2Gizmo.classDescOf((Type)providerType));
            cc.implements_(Subclass.class);
            for (InterceptedDecoratedMethod interceptedDecoratedMethod : codeGenInfo.interceptedDecoratedMethods) {
                if (interceptedDecoratedMethod.interception() == null) continue;
                cc.field("arc$" + interceptedDecoratedMethod.index, fc -> {
                    fc.private_();
                    fc.setType(InterceptedMethodMetadata.class);
                });
            }
            FieldDesc aroundInvokesField = bean.hasAroundInvokes() ? cc.field("aroundInvokes", fc -> {
                fc.private_();
                fc.setType(List.class);
            }) : null;
            FieldDesc preDestroys = !preDestroyInterception.isEmpty() ? cc.field(FIELD_NAME_PREDESTROYS, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(ArrayList.class);
            }) : null;
            FieldDesc constructedField = cc.field(FIELD_NAME_CONSTRUCTED, fc -> {
                fc.private_();
                fc.volatile_();
                fc.setType(Boolean.TYPE);
            });
            HashMap<List<InterceptorInfo>, String> interceptorChainKeys = new HashMap<List<InterceptorInfo>, String>();
            HashMap<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys = new HashMap<Set<AnnotationInstanceEquivalenceProxy>, String>();
            HashMap<MethodDesc, MethodDesc> forwardingMethods = new HashMap<MethodDesc, MethodDesc>();
            for (InterceptedDecoratedMethod interceptedDecoratedMethod : codeGenInfo.interceptedDecoratedMethods()) {
                MethodInfo method = interceptedDecoratedMethod.method();
                MethodDesc forwardDesc = SubclassGenerator.createForwardingMethod(cc, Jandex2Gizmo.classDescOf((Type)providerType), method, false);
                forwardingMethods.put(Jandex2Gizmo.methodDescOf((MethodInfo)method), forwardDesc);
            }
            cc.constructor(mc -> {
                Optional<Injection> constructorInjection = bean.getConstructorInjection();
                ArrayList<ClassDesc> ipTypes = new ArrayList<ClassDesc>();
                ArrayList<ParamVar> ipParams = new ArrayList<ParamVar>();
                if (constructorInjection.isPresent()) {
                    int idx = 0;
                    for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                        ClassDesc ipType = Jandex2Gizmo.classDescOf((Type)injectionPoint.getType());
                        ipTypes.add(ipType);
                        ipParams.add(mc.parameter("ip" + idx, ipType));
                        ++idx;
                    }
                }
                ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
                ArrayList<ParamVar> interceptorParams = new ArrayList<ParamVar>();
                for (int i = 0; i < codeGenInfo.boundInterceptors().size(); ++i) {
                    interceptorParams.add(mc.parameter("interceptor" + i, InjectableInterceptor.class));
                }
                ArrayList<ParamVar> decoratorParams = new ArrayList<ParamVar>();
                for (int i = 0; i < codeGenInfo.boundDecorators().size(); ++i) {
                    decoratorParams.add(mc.parameter("decorator" + i, InjectableDecorator.class));
                }
                mc.body(bc -> {
                    bc.invokeSpecial(ConstructorDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)providerType), (List)ipTypes), (Expr)cc.this_(), ipParams);
                    HashMap<String, ParamVar> interceptorBeanToParamVar = new HashMap<String, ParamVar>();
                    HashMap<String, LocalVar> interceptorInstanceToLocalVar = new HashMap<String, LocalVar>();
                    for (int i = 0; i < codeGenInfo.boundInterceptors().size(); ++i) {
                        InterceptorInfo interceptorInfo = codeGenInfo.boundInterceptors().get(i);
                        String id = interceptorInfo.getIdentifier();
                        ParamVar interceptorBean = (ParamVar)interceptorParams.get(i);
                        interceptorBeanToParamVar.put(id, interceptorBean);
                        Expr ccChild = bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD, (Expr)ccParam);
                        LocalVar interceptorInstance = bc.localVar("interceptorInstance_" + id, bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)interceptorBean, ccChild));
                        interceptorInstanceToLocalVar.put(id, interceptorInstance);
                    }
                    if (!codeGenInfo.boundDecorators().isEmpty()) {
                        HashMap<String, LocalVar> decoratorToLocalVar = new HashMap<String, LocalVar>();
                        for (int j = 0; j < codeGenInfo.boundDecorators().size(); ++j) {
                            this.processDecorator(gizmo, (ClassCreator)cc, codeGenInfo.boundDecorators().get(j), bean, providerType, (BlockCreator)bc, (ParamVar)decoratorParams.get(j), (Map<String, LocalVar>)decoratorToLocalVar, ccParam, (Map<MethodDesc, MethodDesc>)forwardingMethods);
                        }
                    }
                    if (preDestroys != null) {
                        LocalVar list = bc.localVar("preDestroysList", bc.new_(ArrayList.class));
                        for (InterceptorInfo interceptor : preDestroyInterception.interceptors) {
                            LocalVar interceptorInstance = (LocalVar)interceptorInstanceToLocalVar.get(interceptor.getIdentifier());
                            bc.withList((Expr)list).add(bc.invokeStatic(MethodDescs.INTERCEPTOR_INVOCATION_PRE_DESTROY, (Expr)interceptorBeanToParamVar.get(interceptor.getIdentifier()), (Expr)interceptorInstance));
                        }
                        bc.set((Assignable)cc.this_().field(preDestroys), (Expr)list);
                    }
                    LocalVar interceptorChainMap = bc.localVar("interceptorChainMap", bc.new_(HashMap.class));
                    LocalVar bindingsMap = bc.localVar("bindingsMap", bc.new_(HashMap.class));
                    IntegerHolder chainIdx = new IntegerHolder();
                    IntegerHolder bindingIdx = new IntegerHolder();
                    HashMap<AnnotationInstanceEquivalenceProxy, Expr> bindingsLiterals = new HashMap<AnnotationInstanceEquivalenceProxy, Expr>();
                    Function<Set<AnnotationInstanceEquivalenceProxy>, String> bindingsFun = SubclassGenerator.createBindingsFun(bindingIdx, bc, (Expr)bindingsMap, bindingsLiterals, bean, this.annotationLiterals);
                    Function<List<InterceptorInfo>, String> interceptorChainKeysFun = SubclassGenerator.createInterceptorChainKeysFun(chainIdx, bc, (Expr)interceptorChainMap, interceptorInstanceToLocalVar, interceptorBeanToParamVar);
                    for (InterceptedDecoratedMethod interceptedDecoratedMethod : codeGenInfo.interceptedDecoratedMethods) {
                        BeanInfo.InterceptionInfo interception = interceptedDecoratedMethod.interception();
                        if (interception == null) continue;
                        interceptorChainKeys.computeIfAbsent(interception.interceptors, interceptorChainKeysFun);
                        bindingKeys.computeIfAbsent(interception.bindingsEquivalenceProxies(), bindingsFun);
                    }
                    if (bean.hasAroundInvokes()) {
                        LocalVar aroundInvokes = bc.localVar("aroundInvokes", bc.new_(ArrayList.class));
                        for (MethodInfo method : bean.getAroundInvokes()) {
                            Expr lambda = bc.lambda(BiFunction.class, lc -> {
                                ParamVar target = lc.parameter("target", 0);
                                ParamVar ctx = lc.parameter("ctx", 1);
                                lc.body(lbc -> {
                                    boolean isApplicationClass = this.applicationClassPredicate.test(bean.getBeanClass());
                                    Class invocationContextClass = method.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) ? InvocationContext.class : ArcInvocationContext.class;
                                    if (Modifier.isPrivate(method.flags())) {
                                        this.privateMembers.add(isApplicationClass, String.format("Interceptor method %s#%s()", method.declaringClass().name(), method.name()));
                                        this.reflectionRegistration.registerMethod(method);
                                        Expr paramTypes = lbc.newArray(Class.class, new Expr[]{Const.of(invocationContextClass)});
                                        Expr argValues = lbc.newArray(Object.class, new Expr[]{ctx});
                                        lbc.return_(lbc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass())), Const.of((String)method.name()), paramTypes, target, argValues}));
                                    } else {
                                        lbc.return_(lbc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)method), lbc.cast((Expr)target, Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass())), (Expr)ctx));
                                    }
                                });
                            });
                            bc.withList((Expr)aroundInvokes).add(lambda);
                        }
                        bc.set((Assignable)cc.this_().field(aroundInvokesField), (Expr)aroundInvokes);
                    }
                    for (MethodGroup methodGroup : codeGenInfo.methodGroups()) {
                        ClassMethodDesc desc = ClassMethodDesc.of((ClassDesc)cc.type(), (String)("arc$initMetadata" + methodGroup.id()), Void.TYPE, (Class[])new Class[]{Map.class, Map.class});
                        bc.invokeVirtual((MethodDesc)desc, (Expr)cc.this_(), (Expr)interceptorChainMap, (Expr)bindingsMap);
                    }
                    bc.return_();
                });
            });
            for (MethodGroup group : codeGenInfo.methodGroups()) {
                this.generateInitMetadata((ClassCreator)cc, bean, providerType, aroundInvokesField, constructedField, group, (Map<MethodDesc, MethodDesc>)forwardingMethods, (Map<List<InterceptorInfo>, String>)interceptorChainKeys, (Map<Set<AnnotationInstanceEquivalenceProxy>, String>)bindingKeys);
            }
            cc.method(MARK_CONSTRUCTED_METHOD_NAME, mc -> mc.body(bc -> {
                bc.set((Assignable)cc.this_().field(constructedField), Const.of((boolean)true));
                bc.return_();
            }));
            if (preDestroys != null) {
                cc.method(DESTROY_METHOD_NAME, mc -> {
                    ParamVar forward = mc.parameter("forward", Runnable.class);
                    mc.body(b0 -> b0.try_(tc -> {
                        tc.body(b1 -> {
                            Expr bindings = b1.setOf(preDestroyInterception.bindings.stream().map(binding -> {
                                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                                return this.annotationLiterals.create((BlockCreator)b1, bindingClass, (AnnotationInstance)binding);
                            }).toList());
                            Expr invocationContext = b1.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_PRE_DESTROY, new Expr[]{cc.this_(), cc.this_().field(preDestroys), bindings, forward});
                            b1.invokeInterface(MethodDescs.INVOCATION_CONTEXT_PROCEED, invocationContext);
                            b1.return_();
                        });
                        tc.catch_(Exception.class, "e", (b1, e) -> b1.throw_(b1.new_(RuntimeException.class, (Expr)Const.of((String)"Error destroying subclass"), (Expr)e)));
                    }));
                });
            }
        });
    }

    private void generateInitMetadata(ClassCreator cc, BeanInfo bean, Type providerType, FieldDesc aroundInvokesField, FieldDesc constructedField, MethodGroup group, Map<MethodDesc, MethodDesc> forwardingMethods, Map<List<InterceptorInfo>, String> interceptorChainKeys, Map<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys) {
        cc.method("arc$initMetadata" + group.id(), mc -> {
            mc.private_();
            mc.returning(Void.TYPE);
            ParamVar interceptorChainMapParam = mc.parameter("interceptorChainMap", Map.class);
            ParamVar bindingsMapParam = mc.parameter("bindingsMap", Map.class);
            mc.body(bc -> {
                HashMap<String, LocalVar> chains = new HashMap<String, LocalVar>();
                HashMap<String, LocalVar> bindings = new HashMap<String, LocalVar>();
                for (InterceptedDecoratedMethod interceptedDecoratedMethod : group.interceptedDecoratedMethods()) {
                    MethodInfo method = interceptedDecoratedMethod.method();
                    MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                    BeanInfo.InterceptionInfo interception = interceptedDecoratedMethod.interception();
                    BeanInfo.DecorationInfo decoration = interceptedDecoratedMethod.decoration();
                    MethodDesc forwardDesc = (MethodDesc)forwardingMethods.get(methodDesc);
                    List parameters = method.parameterTypes();
                    if (interception != null) {
                        String interceptorChainKey = (String)interceptorChainKeys.get(interception.interceptors);
                        LocalVar chainArg = chains.computeIfAbsent(interceptorChainKey, ignored -> bc.localVar("interceptorChain", bc.withMap((Expr)interceptorChainMapParam).get((Expr)Const.of((String)interceptorChainKey))));
                        Expr[] args = new Expr[3];
                        args[0] = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)providerType));
                        args[1] = Const.of((String)method.name());
                        if (!parameters.isEmpty()) {
                            LocalVar paramTypes = bc.localVar("paramTypes", bc.newEmptyArray(Class.class, parameters.size()));
                            for (int i = 0; i < parameters.size(); ++i) {
                                bc.set(paramTypes.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)((Type)parameters.get(i)))));
                            }
                            args[2] = paramTypes;
                        } else {
                            args[2] = Expr.staticField((FieldDesc)FieldDescs.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                        }
                        Expr methodArg = bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_METHOD, args);
                        String bindingKey = (String)bindingKeys.get(interception.bindingsEquivalenceProxies());
                        LocalVar bindingsArg = bindings.computeIfAbsent(bindingKey, ignored -> bc.localVar("bindings", bc.withMap((Expr)bindingsMapParam).get((Expr)Const.of((String)bindingKey))));
                        BeanInfo.DecoratorMethod decoratorMethod = decoration != null ? decoration.firstDecoratorMethod() : null;
                        InstanceFieldVar decorator = decoratorMethod != null ? cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)decoratorMethod.decorator.getIdentifier(), Object.class)) : null;
                        LocalVar forwardFun = bc.localVar("forwardFun", bc.lambda(BiFunction.class, arg_0 -> SubclassGenerator.lambda$generateInitMetadata$21((FieldVar)decorator, decoratorMethod, forwardDesc, parameters, arg_0)));
                        if (bean.hasAroundInvokes()) {
                            LocalVar finalForwardFun = forwardFun;
                            forwardFun = bc.localVar("forwardFun2", bc.lambda(BiFunction.class, lc -> {
                                Var capturedAroundInvokes = lc.capture((Var)cc.this_().field(aroundInvokesField));
                                Var capturedForwardFun = lc.capture((Var)finalForwardFun);
                                ParamVar target = lc.parameter("target", 0);
                                ParamVar ctx = lc.parameter("ctx", 1);
                                lc.body(lbc -> lbc.return_(lbc.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_PERFORM_TARGET_AROUND_INVOKE, new Expr[]{ctx, capturedAroundInvokes, capturedForwardFun})));
                            }));
                        }
                        Expr methodMetadata = bc.new_(MethodDescs.INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new Expr[]{chainArg, methodArg, bindingsArg, forwardFun});
                        FieldDesc metadataField = FieldDesc.of((ClassDesc)cc.type(), (String)("arc$" + interceptedDecoratedMethod.index), InterceptedMethodMetadata.class);
                        bc.set((Assignable)cc.this_().field(metadataField), methodMetadata);
                        this.reflectionRegistration.registerMethod(method);
                        MethodDesc forwardDescriptor = (MethodDesc)forwardingMethods.get(methodDesc);
                        SubclassGenerator.createInterceptedMethod(method, cc, metadataField, constructedField, forwardDescriptor, () -> ((ClassCreator)cc).this_());
                        continue;
                    }
                    cc.method(methodDesc, dmc -> {
                        ArrayList<ParamVar> params = new ArrayList<ParamVar>(method.parametersCount());
                        for (MethodParameterInfo param : method.parameters()) {
                            params.add(dmc.parameter(param.nameOrDefault()));
                        }
                        dmc.body(db0 -> {
                            db0.ifNot((Expr)cc.this_().field(constructedField), db1 -> {
                                if (method.isAbstract()) {
                                    db1.throw_(IllegalStateException.class, "Cannot invoke abstract method");
                                } else {
                                    db1.return_(db1.invokeVirtual(forwardDesc, (Expr)cc.this_(), params));
                                }
                            });
                            BeanInfo.DecoratorMethod decoratorMethod = decoration.firstDecoratorMethod();
                            DecoratorInfo firstDecorator = decoratorMethod.decorator;
                            InstanceFieldVar decoratorInstance = cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)firstDecorator.getIdentifier(), Object.class));
                            MethodDesc decoratorMethodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)decoratorMethod.method);
                            db0.return_(db0.cast(db0.invokeInterface(decoratorMethodDesc, (Expr)decoratorInstance, params), methodDesc.returnType()));
                        });
                    });
                }
                bc.return_();
            });
        });
    }

    static Function<Set<AnnotationInstanceEquivalenceProxy>, String> createBindingsFun(IntegerHolder bindingIdx, BlockCreator bc, Expr bindingsMap, Map<AnnotationInstanceEquivalenceProxy, Expr> bindingsLiterals, BeanInfo bean, AnnotationLiteralProcessor annotationLiterals) {
        Function<AnnotationInstanceEquivalenceProxy, Expr> bindingsLiteralFun = binding -> {
            ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.get().name());
            return bc.localVar("literal", annotationLiterals.create(bc, bindingClass, binding.get()));
        };
        return bindings -> {
            Expr value;
            String key = "b" + bindingIdx.i++;
            if (bindings.size() == 1) {
                value = bc.invokeStatic(MethodDescs.COLLECTIONS_SINGLETON, (Expr)bindingsLiterals.computeIfAbsent((AnnotationInstanceEquivalenceProxy)bindings.iterator().next(), bindingsLiteralFun));
            } else {
                LocalVar bindingsArray = bc.localVar("bindings", bc.newEmptyArray(Object.class, bindings.size()));
                int bindingsIndex = 0;
                for (AnnotationInstanceEquivalenceProxy binding : bindings) {
                    bc.set(bindingsArray.elem(bindingsIndex), (Expr)bindingsLiterals.computeIfAbsent(binding, bindingsLiteralFun));
                    ++bindingsIndex;
                }
                value = bc.invokeStatic(MethodDescs.SETS_OF, (Expr)bindingsArray);
            }
            bc.withMap(bindingsMap).put((Expr)Const.of((String)key), value);
            return key;
        };
    }

    static Function<List<InterceptorInfo>, String> createInterceptorChainKeysFun(IntegerHolder chainIdx, BlockCreator bc, Expr interceptorChainMap, Map<String, LocalVar> interceptorInstanceToLocalVar, Map<String, ? extends Var> interceptorBeanToVar) {
        return interceptors -> {
            String key = "i" + chainIdx.i++;
            if (interceptors.size() == 1) {
                InterceptorInfo interceptor = (InterceptorInfo)interceptors.get(0);
                LocalVar interceptorInstance = (LocalVar)interceptorInstanceToLocalVar.get(interceptor.getIdentifier());
                Expr interceptionInvocation = bc.invokeStatic(MethodDescs.INTERCEPTOR_INVOCATION_AROUND_INVOKE, (Expr)interceptorBeanToVar.get(interceptor.getIdentifier()), (Expr)interceptorInstance);
                bc.withMap(interceptorChainMap).put((Expr)Const.of((String)key), bc.listOf(new Expr[]{interceptionInvocation}));
            } else {
                LocalVar chain = bc.localVar("chain", bc.new_(ConstructorDesc.of(ArrayList.class, (Class[])new Class[0])));
                for (InterceptorInfo interceptor : interceptors) {
                    LocalVar interceptorInstance = (LocalVar)interceptorInstanceToLocalVar.get(interceptor.getIdentifier());
                    Expr interceptionInvocation = bc.invokeStatic(MethodDescs.INTERCEPTOR_INVOCATION_AROUND_INVOKE, (Expr)interceptorBeanToVar.get(interceptor.getIdentifier()), (Expr)interceptorInstance);
                    bc.withList((Expr)chain).add(interceptionInvocation);
                }
                bc.withMap(interceptorChainMap).put((Expr)Const.of((String)key), (Expr)chain);
            }
            return key;
        };
    }

    private void processDecorator(Gizmo gizmo, ClassCreator subclass, DecoratorInfo decorator, BeanInfo bean, Type providerType, BlockCreator subclassCtor, ParamVar decoratorParam, Map<String, LocalVar> decoratorToLocalVar, ParamVar ccParam, Map<MethodDesc, MethodDesc> forwardingMethods) {
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        String generatedName = SubclassGenerator.generatedName(providerType.name(), decoratorClass.name().withoutPackagePrefix() + "_" + bean.getIdentifier() + "_Delegate");
        Set<MethodInfo> decoratedMethods = bean.getDecoratedMethods(decorator);
        HashSet<MethodDesc> decoratedMethodDescriptors = new HashSet<MethodDesc>(decoratedMethods.size());
        for (MethodInfo m : decoratedMethods) {
            decoratedMethodDescriptors.add(Jandex2Gizmo.methodDescOf((MethodInfo)m));
        }
        Map<MethodDesc, BeanInfo.DecoratorMethod> nextDecorators = bean.getNextDecorators(decorator);
        HashSet<DecoratorInfo> decoratorParametersSet = new HashSet<DecoratorInfo>();
        for (BeanInfo.DecoratorMethod decoratorMethod : nextDecorators.values()) {
            decoratorParametersSet.add(decoratorMethod.decorator);
        }
        ArrayList decoratorParameters = new ArrayList(decoratorParametersSet);
        Collections.sort(decoratorParameters);
        ArrayList delegateSubclassCtorParams = new ArrayList();
        ClassDesc delegateSubclass = gizmo.class_(generatedName, cc -> {
            Map<String, Type> resolvedTypeParameters;
            ClassInfo delegateTypeClass = decorator.getDelegateTypeClass();
            boolean delegateTypeIsInterface = delegateTypeClass.isInterface();
            if (delegateTypeIsInterface) {
                cc.implements_(Jandex2Gizmo.classDescOf((ClassInfo)delegateTypeClass));
            } else {
                cc.extends_(Jandex2Gizmo.classDescOf((ClassInfo)delegateTypeClass));
            }
            FieldDesc subclassField = cc.field("subclass", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(subclass.type());
            });
            ArrayList<ClassDesc> nextDecoratorTypes = new ArrayList<ClassDesc>();
            HashMap<DecoratorInfo, FieldDesc> nextDecoratorToField = new HashMap<DecoratorInfo, FieldDesc>();
            for (DecoratorInfo nextDecorator : decoratorParameters) {
                FieldDesc desc = cc.field(nextDecorator.getIdentifier(), fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Object.class);
                });
                nextDecoratorTypes.add(desc.type());
                nextDecoratorToField.put(nextDecorator, desc);
            }
            cc.constructor(mc -> {
                ParamVar subclassParam = mc.parameter("subclass", subclass.type());
                delegateSubclassCtorParams.add(subclass.type());
                ArrayList<ParamVar> nextDecoratorParams = new ArrayList<ParamVar>();
                for (int i = 0; i < nextDecoratorTypes.size(); ++i) {
                    nextDecoratorParams.add(mc.parameter("nextDecorator" + i, (ClassDesc)nextDecoratorTypes.get(i)));
                    delegateSubclassCtorParams.add((ClassDesc)nextDecoratorTypes.get(i));
                }
                mc.body(bc -> {
                    if (delegateTypeIsInterface) {
                        bc.invokeSpecial(MethodDescs.OBJECT_CONSTRUCTOR, (Expr)cc.this_());
                    } else {
                        bc.invokeSpecial(ConstructorDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)delegateTypeClass)), (Expr)cc.this_());
                    }
                    bc.set((Assignable)cc.this_().field(subclassField), (Expr)subclassParam);
                    for (int i = 0; i < decoratorParameters.size(); ++i) {
                        DecoratorInfo nextDecorator = (DecoratorInfo)decoratorParameters.get(i);
                        bc.set((Assignable)cc.this_().field((FieldDesc)nextDecoratorToField.get(nextDecorator)), (Expr)nextDecoratorParams.get(i));
                    }
                    bc.return_();
                });
            });
            IndexView index = bean.getDeployment().getBeanArchiveIndex();
            HashSet<Methods.MethodKey> methods = new HashSet<Methods.MethodKey>();
            Methods.addDelegateTypeMethods(index, delegateTypeClass, methods);
            List typeParameters = delegateTypeClass.typeParameters();
            if (!typeParameters.isEmpty()) {
                resolvedTypeParameters = new HashMap();
                Type delegateType = decorator.getDelegateType();
                if (delegateType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    List typeArguments = delegateType.asParameterizedType().arguments();
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        resolvedTypeParameters.put(((TypeVariable)typeParameters.get(i)).identifier(), (Type)typeArguments.get(i));
                    }
                }
            } else {
                resolvedTypeParameters = Map.of();
            }
            for (Methods.MethodKey m : methods) {
                MethodInfo method = m.method;
                MethodDesc methodDescriptor = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                cc.method(method.name(), mc -> {
                    mc.public_();
                    mc.returning(Jandex2Gizmo.classDescOf((Type)method.returnType()));
                    ArrayList<ParamVar> params = new ArrayList<ParamVar>();
                    for (int i = 0; i < method.parametersCount(); ++i) {
                        Object paramName = method.parameterName(i);
                        if (paramName == null || ((String)paramName).isBlank()) {
                            paramName = "param" + i;
                        }
                        params.add(mc.parameter((String)paramName, Jandex2Gizmo.classDescOf((Type)method.parameterType(i))));
                    }
                    for (Type exception : method.exceptions()) {
                        mc.throws_(Jandex2Gizmo.classDescOf((Type)exception));
                    }
                    mc.body(bc -> {
                        ClassMethodDesc resolvedMethodDesc;
                        if (typeParameters.isEmpty() || !Methods.containsTypeVariableParameter(method) && !Types.containsTypeVariable(method.returnType())) {
                            resolvedMethodDesc = null;
                        } else {
                            Type returnType = Types.resolveTypeParam(method.returnType(), resolvedTypeParameters, index);
                            List<Type> paramTypes = Types.getResolvedParameters(delegateTypeClass, resolvedTypeParameters, method, index);
                            ClassDesc[] paramTypesArray = new ClassDesc[paramTypes.size()];
                            for (int i = 0; i < paramTypesArray.length; ++i) {
                                paramTypesArray[i] = Jandex2Gizmo.classDescOf((Type)paramTypes.get(i));
                            }
                            resolvedMethodDesc = ClassMethodDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass()), (String)method.name(), (MethodTypeDesc)MethodTypeDesc.of(Jandex2Gizmo.classDescOf((Type)returnType), paramTypesArray));
                        }
                        BeanInfo.DecoratorMethod nextDecorator = null;
                        MethodDesc nextDecoratorDecorated = null;
                        for (Map.Entry e : nextDecorators.entrySet()) {
                            if (!Methods.descriptorMatches((MethodDesc)e.getKey(), methodDescriptor) && (resolvedMethodDesc == null || !Methods.descriptorMatches((MethodDesc)e.getKey(), resolvedMethodDesc)) && !Methods.descriptorMatches(Jandex2Gizmo.methodDescOf((MethodInfo)((BeanInfo.DecoratorMethod)e.getValue()).method), methodDescriptor)) continue;
                            nextDecorator = (BeanInfo.DecoratorMethod)e.getValue();
                            nextDecoratorDecorated = (MethodDesc)e.getKey();
                            break;
                        }
                        if (nextDecorator != null && this.isDecorated(decoratedMethodDescriptors, methodDescriptor, (MethodDesc)resolvedMethodDesc, nextDecoratorDecorated)) {
                            InstanceFieldVar delegateTo = cc.this_().field((FieldDesc)nextDecoratorToField.get(nextDecorator.decorator));
                            bc.return_(bc.invokeInterface(Jandex2Gizmo.methodDescOf((MethodInfo)nextDecorator.method), (Expr)delegateTo, params));
                        } else {
                            MethodDesc forwardingMethod = null;
                            MethodInfo decoratedMethod = bean.getDecoratedMethod(method, decorator);
                            MethodDesc decoratedMethodDesc = decoratedMethod != null ? Jandex2Gizmo.methodDescOf((MethodInfo)decoratedMethod) : null;
                            for (Map.Entry entry : forwardingMethods.entrySet()) {
                                if (!Methods.descriptorMatches((MethodDesc)entry.getKey(), methodDescriptor) && (resolvedMethodDesc == null || !Methods.descriptorMatches((MethodDesc)entry.getKey(), (MethodDesc)resolvedMethodDesc)) && (decoratedMethodDesc == null || !Methods.descriptorMatches((MethodDesc)entry.getKey(), decoratedMethodDesc))) continue;
                                forwardingMethod = (MethodDesc)entry.getValue();
                                break;
                            }
                            InstanceFieldVar delegateTo = cc.this_().field(subclassField);
                            if (forwardingMethod != null) {
                                ArrayList<Expr> args = new ArrayList<Expr>();
                                for (int i = 0; i < params.size(); ++i) {
                                    args.add(bc.cast((Expr)params.get(i), forwardingMethod.parameterType(i)));
                                }
                                bc.return_(bc.invokeVirtual(forwardingMethod, (Expr)delegateTo, args));
                            } else if (method.declaringClass().isInterface()) {
                                bc.return_(bc.invokeInterface(methodDescriptor, (Expr)delegateTo, params));
                            } else {
                                bc.return_(bc.invokeVirtual(methodDescriptor, (Expr)delegateTo, params));
                            }
                        }
                    });
                });
            }
        });
        LocalVar cc2 = subclassCtor.localVar("cc", subclassCtor.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD, (Expr)ccParam));
        Expr[] args = new Expr[1 + decoratorParameters.size()];
        args[0] = subclass.this_();
        int argIndex = 1;
        for (DecoratorInfo decoratorParameter : decoratorParameters) {
            LocalVar decoratorVar = decoratorToLocalVar.get(decoratorParameter.getIdentifier());
            if (decoratorVar == null) {
                throw new IllegalStateException("Unknown next " + String.valueOf(decoratorParameter) + " when generating " + generatedName);
            }
            args[argIndex] = decoratorVar;
            ++argIndex;
        }
        Expr delegateSubclassInstance = subclassCtor.new_(ConstructorDesc.of((ClassDesc)delegateSubclass, delegateSubclassCtorParams), args);
        LocalVar prev = subclassCtor.localVar("prev", subclassCtor.invokeStatic(MethodDescs.DECORATOR_DELEGATE_PROVIDER_SET, (Expr)cc2, delegateSubclassInstance));
        LocalVar decoratorInstance = subclassCtor.localVar("decoratorInstance", subclassCtor.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)decoratorParam, (Expr)cc2));
        subclassCtor.invokeStatic(MethodDescs.DECORATOR_DELEGATE_PROVIDER_SET, (Expr)cc2, (Expr)prev);
        decoratorToLocalVar.put(decorator.getIdentifier(), decoratorInstance);
        FieldDesc decoratorField = subclass.field(decorator.getIdentifier(), fc -> {
            fc.private_();
            fc.final_();
            fc.setType(Object.class);
        });
        subclassCtor.set((Assignable)subclass.this_().field(decoratorField), (Expr)decoratorInstance);
    }

    private boolean isDecorated(Set<MethodDesc> decoratedMethodDescriptors, MethodDesc original, MethodDesc resolved, MethodDesc nextDecoratorDecorated) {
        for (MethodDesc decorated : decoratedMethodDescriptors) {
            if (!Methods.descriptorMatches(decorated, original) && (resolved == null || !Methods.descriptorMatches(decorated, resolved)) && !Methods.descriptorMatches(decorated, nextDecoratorDecorated)) continue;
            return true;
        }
        return false;
    }

    static MethodDesc createForwardingMethod(ClassCreator subclass, ClassDesc providerType, MethodInfo method, boolean implementingInterface) {
        return subclass.method(method.name() + "$$superforward", mc -> {
            mc.returning(Jandex2Gizmo.classDescOf((Type)method.returnType()));
            ArrayList<ParamVar> params = new ArrayList<ParamVar>(method.parametersCount());
            for (MethodParameterInfo param : method.parameters()) {
                params.add(mc.parameter(param.nameOrDefault(), Jandex2Gizmo.classDescOf((Type)param.type())));
            }
            mc.body(bc -> {
                MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                InterfaceMethodDesc superMethod = implementingInterface ? InterfaceMethodDesc.of((ClassDesc)providerType, (String)methodDesc.name(), (MethodTypeDesc)methodDesc.type()) : ClassMethodDesc.of((ClassDesc)providerType, (String)methodDesc.name(), (MethodTypeDesc)methodDesc.type());
                Expr result = bc.invokeSpecial((MethodDesc)superMethod, (Expr)subclass.this_(), params);
                bc.return_(bc.cast(result, Jandex2Gizmo.classDescOf((Type)method.returnType())));
            });
        });
    }

    static void createInterceptedMethod(MethodInfo method, ClassCreator subclass, FieldDesc metadataField, FieldDesc constructedField, MethodDesc forwardMethod, Supplier<Expr> getTarget) {
        subclass.method(Jandex2Gizmo.methodDescOf((MethodInfo)method), mc -> {
            mc.public_();
            List<ParamVar> params = IntStream.range(0, method.parametersCount()).mapToObj(i -> mc.parameter("param" + i, i)).toList();
            for (Type exception : method.exceptions()) {
                mc.throws_(Jandex2Gizmo.classDescOf((Type)exception));
            }
            mc.body(arg_0 -> SubclassGenerator.lambda$createInterceptedMethod$47(subclass, constructedField, method, forwardMethod, params, metadataField, (Supplier)getTarget, arg_0));
        });
    }

    private CodeGenInfo preprocess(BeanInfo bean) {
        List<InterceptorInfo> boundInterceptors = bean.getBoundInterceptors();
        List<DecoratorInfo> boundDecorators = bean.getBoundDecorators();
        ArrayList<InterceptedDecoratedMethod> interceptedDecoratedMethods = new ArrayList<InterceptedDecoratedMethod>();
        List<MethodInfo> interestingMethods = bean.getInterceptedOrDecoratedMethods();
        for (int i = 0; i < interestingMethods.size(); ++i) {
            MethodInfo method = interestingMethods.get(i);
            BeanInfo.InterceptionInfo interception = bean.getInterceptedMethods().get(method);
            BeanInfo.DecorationInfo decoration = bean.getDecoratedMethods().get(method);
            interceptedDecoratedMethods.add(new InterceptedDecoratedMethod(i, method, interception, decoration));
        }
        List<MethodGroup> methodGroups = Grouping.of(interceptedDecoratedMethods, 30, MethodGroup::new);
        return new CodeGenInfo(List.copyOf(boundInterceptors), List.copyOf(boundDecorators), List.copyOf(interceptedDecoratedMethods), List.copyOf(methodGroups));
    }

    private static /* synthetic */ void lambda$createInterceptedMethod$47(ClassCreator subclass, FieldDesc constructedField, MethodInfo method, MethodDesc forwardMethod, List params, FieldDesc metadataField, Supplier getTarget, BlockCreator b0) {
        b0.ifNot((Expr)subclass.this_().field(constructedField), b1 -> {
            if (Modifier.isAbstract(method.flags())) {
                b1.throw_(IllegalStateException.class, "Cannot invoke abstract method");
            } else {
                b1.return_(b1.invokeVirtual(forwardMethod, (Expr)subclass.this_(), params));
            }
        });
        LocalVar args = b0.localVar("args", (Expr)(method.parametersCount() > 0 ? b0.newArray(Object.class, params) : Const.ofNull(Object[].class)));
        b0.try_(arg_0 -> SubclassGenerator.lambda$createInterceptedMethod$46(subclass, metadataField, (Supplier)getTarget, args, method, arg_0));
    }

    private static /* synthetic */ void lambda$createInterceptedMethod$46(ClassCreator subclass, FieldDesc metadataField, Supplier getTarget, LocalVar args, MethodInfo method, TryCreator tc) {
        tc.body(arg_0 -> SubclassGenerator.lambda$createInterceptedMethod$44(subclass, metadataField, (Supplier)getTarget, args, method, arg_0));
        boolean addCatchRuntimeException = true;
        boolean addCatchException = true;
        for (Type declaredException : method.exceptions()) {
            tc.catch_(Jandex2Gizmo.classDescOf((Type)declaredException), "e", BlockCreator::throw_);
            DotName exName = declaredException.name();
            if (JAVA_LANG_RUNTIME_EXCEPTION.equals((Object)exName) || JAVA_LANG_THROWABLE.equals((Object)exName)) {
                addCatchRuntimeException = false;
            }
            if (!JAVA_LANG_EXCEPTION.equals((Object)exName) && !JAVA_LANG_THROWABLE.equals((Object)exName)) continue;
            addCatchException = false;
        }
        if (addCatchRuntimeException) {
            tc.catch_(RuntimeException.class, "e", BlockCreator::throw_);
        }
        if (addCatchException && !KotlinUtils.isKotlinMethod(method)) {
            tc.catch_(Exception.class, "e", (b1, e) -> b1.throw_(b1.new_(ConstructorDesc.of(ArcUndeclaredThrowableException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)"Error invoking subclass method"), (Expr)e)));
        }
    }

    private static /* synthetic */ void lambda$createInterceptedMethod$44(ClassCreator subclass, FieldDesc metadataField, Supplier getTarget, LocalVar args, MethodInfo method, BlockCreator b1) {
        InstanceFieldVar methodMetadata = subclass.this_().field(metadataField);
        Expr result = b1.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_PERFORM_AROUND_INVOKE, new Expr[]{(Expr)getTarget.get(), args, methodMetadata});
        if (method.returnType().kind() == Type.Kind.VOID) {
            result = Const.ofVoid();
        }
        b1.return_(result);
    }

    private static /* synthetic */ void lambda$generateInitMetadata$21(FieldVar decorator, BeanInfo.DecoratorMethod decoratorMethod, MethodDesc forwardDesc, List parameters, LambdaCreator lc) {
        Var capturedDecorator = decorator != null ? lc.capture((Var)decorator) : null;
        ParamVar target = lc.parameter("target", 0);
        ParamVar ctx = lc.parameter("ctx", 1);
        lc.body(lbc -> {
            Expr[] superArgs;
            ParamVar instance;
            MethodDesc desc;
            if (decoratorMethod == null) {
                desc = forwardDesc;
                instance = target;
            } else {
                desc = Jandex2Gizmo.methodDescOf((MethodInfo)decoratorMethod.method);
                instance = capturedDecorator;
            }
            if (parameters.isEmpty()) {
                superArgs = new Expr[]{};
            } else {
                LocalVar ctxArgs = lbc.localVar("args", lbc.invokeInterface(MethodDescs.INVOCATION_CONTEXT_GET_PARAMETERS, (Expr)ctx));
                superArgs = new Expr[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    superArgs[i] = ctxArgs.elem(i);
                }
            }
            Expr superResult = decoratorMethod == null ? lbc.invokeVirtual(desc, (Expr)instance, superArgs) : lbc.invokeInterface(desc, (Expr)instance, superArgs);
            lbc.return_((Expr)(superResult.isVoid() ? Const.ofNull(Object.class) : superResult));
        });
    }

    record CodeGenInfo(List<InterceptorInfo> boundInterceptors, List<DecoratorInfo> boundDecorators, List<InterceptedDecoratedMethod> interceptedDecoratedMethods, List<MethodGroup> methodGroups) {
    }

    record MethodGroup(int id, List<InterceptedDecoratedMethod> interceptedDecoratedMethods) {
    }

    static class IntegerHolder {
        int i = 1;

        IntegerHolder() {
        }
    }

    record InterceptedDecoratedMethod(int index, MethodInfo method, BeanInfo.InterceptionInfo interception, BeanInfo.DecorationInfo decoration) {
    }
}

