/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfos;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Map;
import java.util.Set;

public class CRDGenerationInfo {
    private final boolean applyCRDs;
    private final boolean validateCRDs;
    private final CRDInfos crds;
    private final Set<String> generated;

    @RecordableConstructor
    public CRDGenerationInfo(boolean applyCRDs, boolean validateCRDs, CRDInfos crds, Set<String> generated) {
        this.applyCRDs = applyCRDs;
        this.validateCRDs = validateCRDs;
        this.crds = crds;
        this.generated = generated;
    }

    public CRDInfos getCrds() {
        return this.crds;
    }

    public Set<String> getGenerated() {
        return this.generated;
    }

    public boolean isApplyCRDs() {
        return this.applyCRDs;
    }

    @IgnoreProperty
    public Map<String, CRDInfo> getCRDInfosFor(String crdName) {
        return this.crds.getOrCreateCRDSpecVersionToInfoMapping(crdName);
    }

    public boolean isValidateCRDs() {
        return this.validateCRDs;
    }
}

