/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import io.quarkus.qute.Qute;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

public class Files {
    private static final String API_TEMPLATES_PATH = "templates/cli/api";
    private static final String ROOT_TARGET_DIR = "src/main/java/";

    private Files() {
    }

    public static boolean generateAPIFiles(String group, String version, String kind, MessageWriter messager) {
        URI apiTemplatesDirURI;
        String packageName = Files.reversePeriodSeparatedString(group);
        String finalKind = Files.capitalizeIfNeeded(kind);
        String targetDir = ROOT_TARGET_DIR + packageName.replace('.', '/') + "/";
        try {
            java.nio.file.Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            messager.error("Couldn't create target directory " + targetDir, e);
            return false;
        }
        URL apiTemplatesDir = Thread.currentThread().getContextClassLoader().getResource(API_TEMPLATES_PATH);
        if (apiTemplatesDir == null) {
            messager.error("Couldn't find templates/cli/api directory in resources");
            return false;
        }
        try {
            apiTemplatesDirURI = apiTemplatesDir.toURI();
        }
        catch (URISyntaxException e) {
            messager.error("Couldn't convert " + String.valueOf(apiTemplatesDir) + " path to URI", e);
            return false;
        }
        if ("jar".equals(apiTemplatesDirURI.getScheme())) {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                try {
                    provider.getFileSystem(apiTemplatesDirURI);
                }
                catch (FileSystemNotFoundException e) {
                    try {
                        provider.newFileSystem(apiTemplatesDirURI, Collections.emptyMap());
                    }
                    catch (IOException ex) {
                        messager.error("Couldn't initialize FileSystem instance to read resources", e);
                        return false;
                    }
                }
            }
        }
        Map<String, String> data = Map.of("packageName", packageName, "group", group, "version", version, "kind", finalKind);
        Path apiTemplatesPath = Paths.get(apiTemplatesDirURI);
        try (Stream<Path> paths = java.nio.file.Files.walk(apiTemplatesPath, new FileVisitOption[0]);){
            paths.filter(f -> java.nio.file.Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".qute")).forEach(path -> {
                try {
                    String templateAsString = java.nio.file.Files.readString(path);
                    TemplateInstance templateInstance = Qute.fmt((String)templateAsString).dataMap(data).instance();
                    Files.generateFile(path, templateInstance, finalKind, targetDir, messager);
                }
                catch (TemplateException e) {
                    throw new RuntimeException("Couldn't render " + String.valueOf(path) + " template", e.getCause());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            messager.error(e.getCause().getMessage(), e);
            return false;
        }
        return true;
    }

    private static String exceptionAsString(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private static void generateFile(Path path, TemplateInstance templateInstance, String kind, String targetDir, MessageWriter messager) throws IOException {
        String id = path.getFileName().toString();
        String className = Files.getClassNameFor(id, kind);
        File file = new File(targetDir + className + ".java");
        if (file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file) + " already exists");
        }
        try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);){
            writer.print(templateInstance.render());
        }
        messager.write("Generated " + String.valueOf(file));
    }

    private static String getClassNameFor(String id, String kind) {
        return "resource".equals(id = id.substring(0, id.lastIndexOf(46))) ? kind : kind + Files.capitalizeIfNeeded(id);
    }

    private static String reversePeriodSeparatedString(String input) {
        String[] splitString = input.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = splitString.length - 1; i >= 0; --i) {
            sb.append(splitString[i]);
            if (i <= 0) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static String capitalizeIfNeeded(String input) {
        char firstChar = input.charAt(0);
        return Character.isUpperCase(firstChar) ? input : Character.toUpperCase(firstChar) + input.substring(1);
    }

    public static interface MessageWriter {
        default public void write(String message) {
            this.write(message, null, false);
        }

        default public void error(String message) {
            this.error(message, null);
        }

        default public void error(String message, Exception e) {
            this.write(message, e, true);
        }

        default public void write(String message, Exception e, boolean forError) {
            PrintStream writer = forError ? System.err : System.out;
            writer.println(this.formatMessageWithException(message, e));
        }

        default public String formatMessageWithException(String message, Exception e) {
            return message + (String)(e != null ? ": " + Files.exceptionAsString(e) : "");
        }
    }
}

