/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Annotation;
import io.protostuff.parser.HasAnnotations;
import io.protostuff.parser.HasProto;
import io.protostuff.parser.Proto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AnnotationContainer
implements HasAnnotations,
HasProto {
    final LinkedHashMap<String, Annotation> annotations = new LinkedHashMap();
    final ArrayList<String> docs = new ArrayList();

    public ArrayList<String> getDocs() {
        return this.docs;
    }

    public void addDoc(String doc) {
        this.docs.add(doc);
    }

    @Override
    public void add(Annotation annotation) {
        if (this.annotations.put(annotation.name, annotation) != null) {
            throw AnnotationContainer.err("Duplicate annotation: " + annotation.name, null);
        }
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotations;
    }

    public final Map<String, Annotation> getA() {
        return this.annotations;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    @Override
    public Annotation getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public boolean hasAnnotation(String name) {
        return this.annotations.containsKey(name);
    }

    @Override
    public boolean addAnnotations(Map<String, Annotation> source, boolean clearSource) {
        if (source.isEmpty()) {
            return false;
        }
        this.annotations.putAll(source);
        if (clearSource) {
            source.clear();
        }
        return true;
    }

    public final boolean isEmptyA() {
        return this.annotations.isEmpty();
    }

    public static IllegalStateException err(String msg, Proto proto) {
        if (proto == null) {
            return new IllegalStateException(msg);
        }
        return new IllegalStateException(msg + " [" + proto.getSourcePath() + "]");
    }
}

