/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoLexer;
import io.protostuff.parser.ProtoParser;
import io.protostuff.parser.TextFormat;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public abstract class AbstractParser
extends Parser {
    static final boolean SUPPRESS_WARNINGS = System.getProperty("parser.suppress_warnings") != null;

    protected AbstractParser(TokenStream input) {
        super(input);
    }

    protected AbstractParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        super.displayRecognitionError(tokenNames, e);
    }

    public static void load(InputStream in, Proto proto) throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(in);
        ProtoLexer lexer = new ProtoLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ProtoParser parser = new ProtoParser((TokenStream)tokens);
        parser.parse(proto);
    }

    static String getStringFromStringLiteral(String literal) {
        return AbstractParser.getString(literal.substring(1, literal.length() - 1));
    }

    static String getString(String value) {
        return TextFormat.unescapeText(value);
    }

    static byte[] getBytesFromStringLiteral(String literal) {
        return AbstractParser.getBytes(literal.substring(1, literal.length() - 1));
    }

    static byte[] getBytes(String value) {
        ByteBuffer buffer = TextFormat.unescapeBytes(value);
        byte[] buf = new byte[buffer.limit()];
        buffer.get(buf);
        return buf;
    }

    static byte[] getBytesFromHexString(String value) {
        int start = value.startsWith("0x") ? 2 : 0;
        int len = value.length() - start;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("malformed hex string: " + value);
        }
        byte[] out = new byte[len / 2];
        int i = 0;
        while (i < out.length) {
            int left = AbstractParser.decimalFromHex(value.charAt(start++));
            int right = AbstractParser.decimalFromHex(value.charAt(start++));
            out[i++] = (byte)(right & 0xF | left << 4 & 0xF0);
        }
        return out;
    }

    static int decimalFromHex(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Not a hex character: " + c);
    }

    static void info(String msg) {
        System.out.println(msg);
    }

    static void warn(String msg) {
        if (!SUPPRESS_WARNINGS) {
            System.err.println(msg);
        }
    }
}

