/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.Exceptions;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RaceTestUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean race(T initial, Function<? super T, ? extends T> race, Predicate<? super T> stopRace, BiPredicate<? super T, ? super T> terminate) {
        Scheduler.Worker w1 = Schedulers.elastic().createWorker();
        Scheduler.Worker w2 = Schedulers.elastic().createWorker();
        try {
            AtomicReference ref1 = new AtomicReference();
            CountDownLatch cdl1 = new CountDownLatch(1);
            AtomicReference ref2 = new AtomicReference();
            CountDownLatch cdl2 = new CountDownLatch(1);
            w1.schedule(() -> {
                Object state = initial;
                while (!stopRace.test(state)) {
                    state = race.apply(state);
                    LockSupport.parkNanos(1L);
                }
                ref1.set(state);
                cdl1.countDown();
            });
            w2.schedule(() -> {
                Object state = initial;
                while (!stopRace.test(state)) {
                    state = race.apply(state);
                    LockSupport.parkNanos(1L);
                }
                ref2.set(state);
                cdl2.countDown();
            });
            try {
                cdl1.await();
                cdl2.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            boolean bl = terminate.test(ref1.get(), ref2.get());
            return bl;
        }
        finally {
            w1.dispose();
            w2.dispose();
        }
    }

    public static void race(Runnable r1, Runnable r2) {
        RaceTestUtils.race(r1, r2, Schedulers.single());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void race(Runnable r1, Runnable r2, Scheduler s) {
        AtomicInteger count = new AtomicInteger(2);
        CountDownLatch cdl = new CountDownLatch(2);
        Throwable[] errors = new Throwable[]{null, null};
        s.schedule(() -> {
            if (count.decrementAndGet() != 0) {
                while (count.get() != 0) {
                }
            }
            try {
                try {
                    r1.run();
                }
                catch (Throwable ex) {
                    errors[0] = ex;
                }
            }
            finally {
                cdl.countDown();
            }
        });
        if (count.decrementAndGet() != 0) {
            while (count.get() != 0) {
            }
        }
        try {
            try {
                r2.run();
            }
            catch (Throwable ex) {
                errors[1] = ex;
            }
        }
        finally {
            cdl.countDown();
        }
        try {
            if (!cdl.await(5L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"The wait timed out!");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (errors[0] != null && errors[1] == null) {
            throw Exceptions.propagate((Throwable)errors[0]);
        }
        if (errors[0] == null && errors[1] != null) {
            throw Exceptions.propagate((Throwable)errors[1]);
        }
        if (errors[0] != null && errors[1] != null) {
            throw Exceptions.multiple((Throwable[])errors);
        }
    }
}

