/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.maven.wagon;

import io.packagecloud.maven.wagon.PackagecloudRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;

public class PackagecloudWagon
extends AbstractWagon {
    private final CloseableHttpClient httpClient = this.getConfiguredHttpClient();
    private boolean isDebug = false;

    private CloseableHttpClient getConfiguredHttpClient() {
        return HttpClients.custom().setUserAgent("io.packagecloud.maven.wagon 0.0.6").build();
    }

    private void insertKeyValueToBuf(StringBuffer buf, String key, String value) {
        buf.append(String.format("\n  %s: %s \n", key, value));
    }

    private void insertSystemPropertyToBuf(StringBuffer buf, String key) {
        this.insertKeyValueToBuf(buf, key, System.getProperty(key));
    }

    private void outputDebug(String str) {
        if (this.isDebug()) {
            System.out.println(String.format("[PACKAGECLOUD-DEBUG] %s", str));
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        this.outputDebug("openConnectionInternal()");
        String packagecloudDebug = System.getProperty("packagecloudDebug");
        if (packagecloudDebug != null && packagecloudDebug.equals("true")) {
            this.setDebug(true);
            StringBuffer buf = new StringBuffer();
            buf.append("\n\n\n-----DEBUG VARS----\n");
            this.insertSystemPropertyToBuf(buf, "java.home");
            this.insertSystemPropertyToBuf(buf, "java.vm.name");
            this.insertSystemPropertyToBuf(buf, "java.version");
            this.insertSystemPropertyToBuf(buf, "java.vm.vendor");
            this.insertSystemPropertyToBuf(buf, "java.vm.version");
            this.insertSystemPropertyToBuf(buf, "user.home");
            this.insertKeyValueToBuf(buf, "repository id", this.getRepository().getId());
            this.insertKeyValueToBuf(buf, "repository url", this.getRepository().getUrl());
            if (this.getRepository().getPermissions() != null) {
                String dirMode = this.getRepository().getPermissions().getDirectoryMode();
                String fileMode = this.getRepository().getPermissions().getFileMode();
                String group = this.getRepository().getPermissions().getGroup();
                this.insertKeyValueToBuf(buf, "dirMode", dirMode);
                this.insertKeyValueToBuf(buf, "fileMode", fileMode);
                this.insertKeyValueToBuf(buf, "group", group);
            }
            if (this.getProxyInfo() != null) {
                this.insertKeyValueToBuf(buf, "proxy.host", this.getProxyInfo().getHost());
            }
            buf.append("\n-----END DEBUG VARS----\n");
            System.out.println(buf.toString());
        }
    }

    public void disconnect() throws ConnectionException {
        this.outputDebug("disconnect()");
    }

    protected void closeConnection() throws ConnectionException {
        this.outputDebug("closeConnection()");
    }

    public void get(String s, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.outputDebug(String.format("get(): %s", s));
        Resource resource = new Resource(s);
        this.fireGetInitiated(resource, file);
        CloseableHttpResponse response = null;
        try {
            this.fireGetStarted(resource, file);
            HttpGet httpGet = new HttpGet(this.constructArtifactRequest(s));
            response = this.httpClient.execute(this.getTargetHost(), (HttpRequest)httpGet, (HttpContext)this.getContext());
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                throw new ResourceDoesNotExistException(String.format("Not found %s", s));
            }
            if (statusLine.getStatusCode() == 401) {
                throw new AuthorizationException(String.format("Could not authenticate with %s", this.getAuthenticationInfo().getPassword()));
            }
            if (statusLine.getStatusCode() == 422) {
                String responseText = IOUtils.toString((InputStream)response.getEntity().getContent());
                throw new TransferFailedException(String.format("Download failed: %s", responseText));
            }
            if (statusLine.getStatusCode() == 500) {
                throw new TransferFailedException("There was an unexpected server error! (500)");
            }
            HttpEntity entity = response.getEntity();
            FileUtils.copyInputStreamToFile((InputStream)entity.getContent(), (File)file);
            this.postProcessListeners(resource, file, 5);
        }
        catch (IOException e) {
            throw new TransferFailedException(String.format("Could not transfer %s to %s", s, this.getTargetHost().getHostName()));
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(String.format("Could not construct url %s to %s", s, this.getTargetHost().getHostName()));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.fireGetCompleted(resource, file);
        }
    }

    public boolean getIfNewer(String s, File file, long l) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return false;
    }

    public void put(File file, String s) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.outputDebug(String.format("put: %s", s));
        Resource resource = new Resource(s);
        resource.setContentLength(file.length());
        resource.setLastModified(file.lastModified());
        this.firePutInitiated(resource, file);
        CloseableHttpResponse response = null;
        try {
            this.firePutStarted(resource, file);
            HttpPut httpPut = new HttpPut(this.constructArtifactRequest(s));
            FileEntity fileEntity = new FileEntity(file);
            httpPut.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)fileEntity));
            response = this.httpClient.execute(this.getTargetHost(), (HttpRequest)httpPut, (HttpContext)this.getContext());
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                throw new ResourceDoesNotExistException(String.format("Not found %s", s));
            }
            if (statusLine.getStatusCode() == 401) {
                throw new AuthorizationException(String.format("Could not authenticate with %s", this.getAuthenticationInfo().getPassword()));
            }
            if (statusLine.getStatusCode() == 422) {
                String responseText = IOUtils.toString((InputStream)response.getEntity().getContent());
                throw new TransferFailedException(String.format("Upload failed: %s", responseText));
            }
            if (statusLine.getStatusCode() == 500) {
                throw new TransferFailedException("There was an unexpected server error! (500)");
            }
            this.postProcessListeners(resource, file, 6);
        }
        catch (IOException e) {
            throw new TransferFailedException(String.format("Could not transfer %s to %s", s, this.getTargetHost().getHostName()));
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException(String.format("Could not construct url %s to %s", s, this.getTargetHost().getHostName()));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                this.firePutCompleted(resource, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private HttpClientContext getContext() throws AuthorizationException {
        HttpClientContext context = HttpClientContext.create();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.getTargetHost(), (AuthScheme)basicAuth);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        String password = this.getAuthenticationInfo().getPassword();
        this.outputDebug("getContext(): looking up password");
        if (password == null) {
            this.raiseAndtroubleShootPassword();
        } else {
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "basic"), (Credentials)new UsernamePasswordCredentials(password, ""));
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    private void raiseAndtroubleShootPassword() throws AuthorizationException {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\n\n-----AUTHENTICATION ERROR-----\n");
        buf.append("Cannot find password for repository id:");
        buf.append(this.getRepository().getId());
        buf.append(" in settings.xml!\n");
        buf.append("-----AUTHENTICATION ERROR-----\n\n\n");
        throw new AuthorizationException(buf.toString());
    }

    private HttpHost getTargetHost() {
        String protocol = this.getRepository().getProtocol();
        if (protocol.contains("https")) {
            return new HttpHost(this.getRepository().getHost(), this.getRepository().getPort(), "https");
        }
        return new HttpHost(this.getRepository().getHost(), this.getRepository().getPort(), "http");
    }

    private PackagecloudRepository getPackagecloudRepo() {
        return new PackagecloudRepository(this.getRepository());
    }

    private String constructArtifactRequest(String key) throws URISyntaxException {
        this.outputDebug(String.format("constructArtifactRequest(): %s", key));
        PackagecloudRepository packagecloudRepository = this.getPackagecloudRepo();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("key", new File("/", key).toString()));
        URIBuilder builder = new URIBuilder().setParameters(params).setPath(String.format("/api/v1/repos/%s/%s/artifacts.json", packagecloudRepository.getUserName(), packagecloudRepository.getRepoName()));
        return builder.build().toString();
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }
}

