/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.api.incubator.common.ExtendedAttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class InternalExtendedAttributeKeyImpl<T>
implements ExtendedAttributeKey<T> {
    private final ExtendedAttributeType type;
    private final String key;
    private final int hashCode;
    @Nullable
    private byte[] keyUtf8;
    @Nullable
    private AttributeKey<T> attributeKey;

    private InternalExtendedAttributeKeyImpl(ExtendedAttributeType type, String key) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        this.key = key;
        this.hashCode = InternalExtendedAttributeKeyImpl.buildHashCode(type, key);
    }

    public static <T> ExtendedAttributeKey<T> create(@Nullable String key, ExtendedAttributeType type) {
        return new InternalExtendedAttributeKeyImpl<T>(type, key != null ? key : "");
    }

    @Override
    public ExtendedAttributeType getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public AttributeKey<T> asAttributeKey() {
        if (this.attributeKey == null) {
            this.attributeKey = InternalExtendedAttributeKeyImpl.toAttributeKey(this);
        }
        return this.attributeKey;
    }

    public byte[] getKeyUtf8() {
        byte[] keyUtf8 = this.keyUtf8;
        if (keyUtf8 == null) {
            this.keyUtf8 = keyUtf8 = this.key.getBytes(StandardCharsets.UTF_8);
        }
        return keyUtf8;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalExtendedAttributeKeyImpl) {
            InternalExtendedAttributeKeyImpl that = (InternalExtendedAttributeKeyImpl)o;
            return this.type.equals((Object)that.getType()) && this.key.equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.key;
    }

    private int buildHashCode() {
        return InternalExtendedAttributeKeyImpl.buildHashCode(this.type, this.key);
    }

    private static int buildHashCode(ExtendedAttributeType type, String key) {
        int result = 1;
        result *= 1000003;
        result ^= type.hashCode();
        result *= 1000003;
        return result ^= key.hashCode();
    }

    @Nullable
    public static <T> AttributeKey<T> toAttributeKey(ExtendedAttributeKey<T> extendedAttributeKey) {
        switch (extendedAttributeKey.getType()) {
            case STRING: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.STRING);
            }
            case BOOLEAN: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.BOOLEAN);
            }
            case LONG: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.LONG);
            }
            case DOUBLE: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.DOUBLE);
            }
            case STRING_ARRAY: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.STRING_ARRAY);
            }
            case BOOLEAN_ARRAY: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.BOOLEAN_ARRAY);
            }
            case LONG_ARRAY: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.LONG_ARRAY);
            }
            case DOUBLE_ARRAY: {
                return InternalAttributeKeyImpl.create((String)extendedAttributeKey.getKey(), (AttributeType)AttributeType.DOUBLE_ARRAY);
            }
            case EXTENDED_ATTRIBUTES: 
            case VALUE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unrecognized extendedAttributeKey type: " + (Object)((Object)extendedAttributeKey.getType()));
    }

    public static <T> ExtendedAttributeKey<T> toExtendedAttributeKey(AttributeKey<T> attributeKey) {
        switch (attributeKey.getType()) {
            case STRING: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.STRING);
            }
            case BOOLEAN: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.BOOLEAN);
            }
            case LONG: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.LONG);
            }
            case DOUBLE: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.DOUBLE);
            }
            case STRING_ARRAY: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.STRING_ARRAY);
            }
            case BOOLEAN_ARRAY: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.BOOLEAN_ARRAY);
            }
            case LONG_ARRAY: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.LONG_ARRAY);
            }
            case DOUBLE_ARRAY: {
                return InternalExtendedAttributeKeyImpl.create(attributeKey.getKey(), ExtendedAttributeType.DOUBLE_ARRAY);
            }
        }
        throw new IllegalArgumentException("Unrecognized attributeKey type: " + attributeKey.getType());
    }
}

