/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.client.impl.Http2Content;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.pool.ChannelPool;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http2AppHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2AppHandler.class);
    private static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Channel was closed before handshake completed");
    private final DefaultHttpClient client;
    private final Http2ConnectionHandler http2ConnectionHandler;
    private final ChannelPool channelPool;
    private boolean writeReached = false;
    private int nextStreamId = 1;
    private final Map<Integer, HttpTx> txByStreamId = new HashMap<Integer, HttpTx>();

    Http2AppHandler(DefaultHttpClient defaultHttpClient, Http2ConnectionHandler http2ConnectionHandler, ChannelPool channelPool) {
        this.client = defaultHttpClient;
        this.http2ConnectionHandler = http2ConnectionHandler;
        this.channelPool = channelPool;
    }

    public boolean isSharable() {
        return false;
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.writeReached = true;
        HttpTx httpTx = (HttpTx)object;
        if (httpTx.requestTimeout.isDone()) {
            this.channelPool.offer(channelHandlerContext.channel());
            return;
        }
        this.nextStreamId += 2;
        int n = this.nextStreamId;
        this.txByStreamId.put(n, httpTx);
        try {
            ChannelFuture channelFuture;
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), true, httpTx.listener);
            LOGGER.debug("Write request {}", (Object)writableRequest);
            httpTx.listener.onWrite(channelHandlerContext.channel());
            writableRequest.getRequest().headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), n);
            if (HttpUtil.is100ContinueExpected((HttpMessage)writableRequest.getRequest())) {
                LOGGER.debug("Delaying body write");
                httpTx.pendingRequestExpectingContinue = writableRequest;
                channelFuture = writableRequest.writeWithoutContent(channelHandlerContext);
            } else {
                channelFuture = writableRequest.write(channelHandlerContext);
            }
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    if (httpTx.requestTimeout.isDone()) {
                        this.resetStream(channelHandlerContext, n);
                    } else {
                        httpTx.requestTimeout.setStreamId(n);
                    }
                } else {
                    httpTx.requestTimeout.cancel();
                    httpTx.listener.onThrowable(future.cause());
                }
            });
        }
        catch (Exception exception) {
            this.crash(channelHandlerContext, exception, httpTx.listener, true);
        }
    }

    private void channelReadHttpResponse(ChannelHandlerContext channelHandlerContext, HttpResponse httpResponse) {
        Integer n = httpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        HttpTx httpTx = this.txByStreamId.get(n);
        if (httpTx.requestTimeout.isDone()) {
            httpTx.releasePendingRequestExpectingContinue();
            this.resetStream(channelHandlerContext, n);
            return;
        }
        HttpResponseStatus httpResponseStatus = httpResponse.status();
        if (httpTx.pendingRequestExpectingContinue != null) {
            if (httpResponseStatus.equals((Object)HttpResponseStatus.CONTINUE)) {
                LOGGER.debug("Received 100-Continue");
                return;
            }
            LOGGER.debug("Request was sent with Expect:100-Continue but received response with status {}, dropping", (Object)httpResponseStatus);
            httpTx.releasePendingRequestExpectingContinue();
        }
        httpTx.listener.onHttpResponse(httpResponseStatus, httpResponse.headers());
    }

    private void channelReadHttp2Content(ChannelHandlerContext channelHandlerContext, Http2Content http2Content) {
        int n = http2Content.streamId;
        HttpTx httpTx = this.txByStreamId.get(n);
        if (httpTx.requestTimeout.isDone()) {
            this.resetStream(channelHandlerContext, n);
            return;
        }
        boolean bl = http2Content.last;
        if (httpTx.pendingRequestExpectingContinue != null) {
            if (bl) {
                LOGGER.debug("Received 100-Continue' LastHttpContent, sending body");
                httpTx.pendingRequestExpectingContinue.writeContent(channelHandlerContext);
                httpTx.pendingRequestExpectingContinue = null;
            }
            return;
        }
        httpTx.listener.onHttpResponseBodyChunk(http2Content.httpContent.content(), bl);
        if (bl) {
            httpTx.requestTimeout.cancel();
            this.closeStream(channelHandlerContext, n);
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof DefaultHttpResponse) {
            this.channelReadHttpResponse(channelHandlerContext, (HttpResponse)((DefaultHttpResponse)object));
        } else if (object instanceof Http2Content) {
            this.channelReadHttp2Content(channelHandlerContext, (Http2Content)object);
        } else if (object instanceof HttpResponse) {
            this.channelReadHttpResponse(channelHandlerContext, (HttpResponse)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, HttpListener httpListener, boolean bl) {
        try {
            if (httpListener != null) {
                httpListener.onThrowable(throwable);
            }
            this.txByStreamId.forEach((n, httpTx) -> {
                httpTx.releasePendingRequestExpectingContinue();
                httpTx.listener.onThrowable(throwable);
            });
        }
        finally {
            if (bl) {
                channelHandlerContext.close();
            }
        }
        if (throwable instanceof Error) {
            LOGGER.error("Fatal error", throwable);
            System.exit(1);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.crash(channelHandlerContext, throwable, null, true);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (!this.writeReached) {
            this.crash(channelHandlerContext, REMOTELY_CLOSED_EXCEPTION, null, false);
        }
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof GoAwayFrame) {
            GoAwayFrame goAwayFrame = (GoAwayFrame)object;
            LOGGER.debug("Received GOAWAY frame: {}", (Object)goAwayFrame);
            ChannelPool.markAsGoAway(channelHandlerContext.channel());
            ArrayList<HttpTx> arrayList = new ArrayList<HttpTx>(3);
            List<Map.Entry> list = this.txByStreamId.entrySet().stream().filter(entry -> (Integer)entry.getKey() > goAwayFrame.lastStreamId).collect(Collectors.toList());
            list.forEach(entry -> {
                this.txByStreamId.remove(entry.getKey());
                HttpTx httpTx = (HttpTx)entry.getValue();
                if (goAwayFrame.errorCode == Http2Error.NO_ERROR.code() && this.client.canRetry(httpTx)) {
                    arrayList.add(httpTx);
                } else {
                    httpTx.listener.onThrowable(REMOTELY_CLOSED_EXCEPTION);
                }
            });
            if (!arrayList.isEmpty()) {
                this.client.retryHttp2(arrayList, channelHandlerContext.channel().eventLoop());
            }
        } else if (object instanceof StreamTimeout) {
            this.resetStream(channelHandlerContext, ((StreamTimeout)object).streamId);
        }
    }

    private void closeStream(ChannelHandlerContext channelHandlerContext, int n) {
        this.txByStreamId.remove(n);
        this.http2ConnectionHandler.connection().stream(n).close();
        this.channelPool.offer(channelHandlerContext.channel());
    }

    private void resetStream(ChannelHandlerContext channelHandlerContext, int n) {
        this.txByStreamId.remove(n);
        this.http2ConnectionHandler.resetStream(channelHandlerContext, n, Http2Error.CANCEL.code(), channelHandlerContext.newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> this.channelPool.offer(channelHandlerContext.channel())));
    }

    public static final class GoAwayFrame {
        private final int lastStreamId;
        private final long errorCode;

        public GoAwayFrame(int n, long l) {
            this.lastStreamId = n;
            this.errorCode = l;
        }

        public String toString() {
            return "GoAwayFrame{lastStreamId=" + this.lastStreamId + ", errorCode=" + this.errorCode + "}";
        }
    }

    public static final class StreamTimeout {
        private final int streamId;

        public StreamTimeout(int n) {
            this.streamId = n;
        }
    }
}

